/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.loc.modpack;

import java.awt.CardLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import net.minecraft.launcher.versions.CompleteVersion;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.version.ModpackVersionDTO;
import org.tlauncher.tlauncher.ui.listener.BlockClickListener;
import org.tlauncher.tlauncher.ui.swing.box.ModpackComboBox;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;

public abstract class ModpackActButton
extends ExtendedPanel
implements BlockClickListener {
    public static final String INSTALL = "INSTALL";
    public static final String REMOVE = "REMOVE";
    public static final String PROCESSING = "PROCESSING";
    public static final String DENIED_OPERATION = "DENIED";
    protected JButton installButton;
    protected JButton removeButton;
    protected JButton processButton;
    protected String last;
    protected ModpackComboBox localmodpacks;
    protected GameType type;
    protected GameEntityDTO entity;

    public ModpackActButton(GameEntityDTO entity, GameType type, ModpackComboBox localmodpacks) {
        this.localmodpacks = localmodpacks;
        this.type = type;
        this.entity = entity;
        this.setLayout(new CardLayout(0, 0));
    }

    protected List<? extends GameEntityDTO> getSelectedModpackData() {
        if (this.localmodpacks.getSelectedIndex() > 0 && this.type != GameType.MODPACK) {
            return ((ModpackVersionDTO)((CompleteVersion)this.localmodpacks.getSelectedValue()).getModpack().getVersion()).getByType(this.type);
        }
        if (this.type == GameType.MODPACK) {
            return this.localmodpacks.getModpacks();
        }
        return new ArrayList();
    }

    public void setTypeButton(String name) {
        if (!name.equals(PROCESSING)) {
            this.last = name;
        }
        ((CardLayout)this.getLayout()).show(this, name);
    }

    public abstract void initButton();

    public void reset() {
        this.setTypeButton(this.last);
    }

    public GameEntityDTO getEntity() {
        return this.entity;
    }

    public GameType getType() {
        return this.type;
    }
}

