/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.loc.modpack;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.version.VersionDTO;
import org.tlauncher.tlauncher.ui.loc.modpack.TableActButton;
import org.tlauncher.tlauncher.ui.modpack.filter.BaseModpackFilter;
import org.tlauncher.tlauncher.ui.swing.box.ModpackComboBox;

public class ModpackTableInstallButton
extends TableActButton {
    private VersionDTO selectedVersion;

    public ModpackTableInstallButton(GameEntityDTO entity, final GameType type, ModpackComboBox localmodpacks) {
        super(entity, type, localmodpacks);
        this.filter = BaseModpackFilter.getBaseModpackStandardFilters(entity, type, localmodpacks);
        this.installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModpackTableInstallButton.this.manager.installEntity(ModpackTableInstallButton.this.getEntity(), ModpackTableInstallButton.this.selectedVersion, type, true);
            }
        });
    }

    @Override
    public void initButton() {
        for (GameEntityDTO gameEntityDTO : this.getSelectedModpackData()) {
            if (!this.entity.getId().equals(gameEntityDTO.getId())) continue;
            this.selectedVersion = gameEntityDTO.getVersion();
            this.setTypeButton("REMOVE");
            return;
        }
        for (VersionDTO versionDTO : this.entity.getVersions()) {
            if (!this.filter.isProper(versionDTO)) continue;
            this.selectedVersion = versionDTO;
        }
        if (this.selectedVersion == null) {
            this.setTypeButton("DENIED");
            return;
        }
        this.setTypeButton("INSTALL");
    }
}

