/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.loc.modpack;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import net.minecraft.launcher.versions.CompleteVersion;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.ModpackDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.version.ModpackVersionDTO;
import org.tlauncher.modpack.domain.client.version.VersionDTO;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.modpack.ModpackUtil;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.modpack.HideInstallButton;
import org.tlauncher.tlauncher.ui.modpack.filter.BaseModpackFilter;
import org.tlauncher.tlauncher.ui.modpack.filter.Filter;
import org.tlauncher.tlauncher.ui.modpack.filter.ModpackSceneFilter;
import org.tlauncher.tlauncher.ui.swing.box.ModpackComboBox;

public class UpInstallButton
extends HideInstallButton {
    private ModpackSceneFilter filter;
    private ModpackManager manager;

    public UpInstallButton(final GameEntityDTO entity, final GameType type, final ModpackComboBox localmodpacks) {
        super(Localizable.get("loginform.enter.install").toUpperCase(), "up-install.png", localmodpacks, type, entity);
        this.filter = new ModpackSceneFilter(localmodpacks, type, new Filter[0]);
        this.manager = (ModpackManager)TLauncher.getInjector().getInstance(ModpackManager.class);
        this.setBackground(DEFAULT_BACKGROUND);
        this.setHorizontalTextPosition(4);
        this.setForeground(Color.WHITE);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                UpInstallButton.this.setBackground(HideInstallButton.MOUSE_UNDER);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                UpInstallButton.this.setBackground(HideInstallButton.DEFAULT_BACKGROUND);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                UpInstallButton.this.setVisible(false);
                BaseModpackFilter<VersionDTO> filter = BaseModpackFilter.getBaseModpackStandardFilters(entity, type, localmodpacks);
                UpInstallButton.this.manager.installEntity(entity, ModpackUtil.sortByDate(filter.findAll(entity.getVersions())).get(0), type, true);
            }
        });
        this.init();
    }

    @Override
    public void init() {
        switch (this.type) {
            case MODPACK: {
                this.modpackInit();
                break;
            }
            default: {
                if (this.localmodpacks.getSelectedIndex() <= 0) break;
                for (GameEntityDTO gameEntityDTO : ((ModpackVersionDTO)((CompleteVersion)this.localmodpacks.getSelectedValue()).getModpack().getVersion()).getByType(this.type)) {
                    this.setVisible(false);
                    if (!this.entity.getId().equals(gameEntityDTO.getId())) continue;
                    return;
                }
                this.setVisible(true);
            }
        }
    }

    private void modpackInit() {
        List<ModpackDTO> list = this.localmodpacks.getModpacks();
        ModpackDTO modpackDTO = (ModpackDTO)this.entity;
        for (ModpackDTO m : list) {
            if (!modpackDTO.getId().equals(m.getId())) continue;
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
    }

    public void installEntity(GameEntityDTO e, GameType type) {
        if (this.entity.getId().equals(e.getId())) {
            this.setVisible(false);
        }
    }

    public void removeEntity(GameEntityDTO e) {
        this.init();
    }
}

