/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.modpack;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import org.tlauncher.modpack.domain.client.GameVersionDTO;
import org.tlauncher.modpack.domain.client.ModpackDTO;
import org.tlauncher.modpack.domain.client.share.ForgeStringComparator;
import org.tlauncher.modpack.domain.client.version.ModpackVersionDTO;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.editor.EditorCheckBox;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.loc.LocalizableTextField;
import org.tlauncher.tlauncher.ui.loc.UpdaterFullButton;
import org.tlauncher.tlauncher.ui.modpack.SliderModpackPanel;
import org.tlauncher.tlauncher.ui.modpack.TemlateModpackFrame;
import org.tlauncher.tlauncher.ui.swing.renderer.CreationModpackForgeComboboxRenderer;
import org.tlauncher.tlauncher.ui.swing.renderer.CreationModpackGameVersionComboboxRenderer;
import org.tlauncher.tlauncher.ui.ui.CreationModpackForgeComboboxUI;
import org.tlauncher.tlauncher.ui.ui.CreationModpackGameVersionComboboxUI;
import org.tlauncher.util.ColorUtil;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.swing.FontTL;

public class ModpackCreation
extends TemlateModpackFrame {
    private final LocalizableTextField versionName;
    private final JComboBox<GameVersionDTO> gameVersion;
    private final JComboBox<String> forges;
    private JButton create;
    private JCheckBox box;
    private JButton cancel;
    private static final Dimension maxSize = new Dimension(572, 479);
    private static final Dimension minSize = new Dimension(572, 374);
    private JLabel question;
    private Configuration c;

    public ModpackCreation(JFrame parent, List<GameVersionDTO> list) {
        super(parent, "modpack.creation.modpack", new Dimension(572, 479));
        list.sort(new GameVersionDTOComporator());
        this.question = new JLabel(ImageCache.getNativeIcon((String)"qestion-option-panel.png"));
        this.c = TLauncher.getInstance().getConfiguration();
        this.question.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ModpackCreation.this.setVisible(false);
                Alert.showLocMessage(ModpackCreation.this.c.get("memory.problem.message"));
                ModpackCreation.this.setVisible(true);
            }
        });
        SpringLayout spring = new SpringLayout();
        JPanel panel = new JPanel(spring);
        panel.setBorder(new EmptyBorder(0, 0, 33, 0));
        this.addCenter(panel);
        panel.setBackground(Color.WHITE);
        JLabel nameLabel = new JLabel(Localizable.get("modpack.creation.name"));
        nameLabel.setForeground(ColorUtil.COLOR_149);
        LocalizableLabel selectedMemory = new LocalizableLabel("settings.java.memory.label");
        LocalizableLabel memorySettings = new LocalizableLabel("modpack.config.memory.title");
        LocalizableLabel optifineLabel = new LocalizableLabel("modpack.config.system.label");
        this.box = new EditorCheckBox("modpack.config.memory.box");
        this.box.setIconTextGap(14);
        final EditorCheckBox optifineBox = new EditorCheckBox("modpack.config.skin.use");
        optifineBox.setIconTextGap(14);
        optifineBox.setSelected(true);
        JLabel versionGameLabel = new JLabel(Localizable.get("modpack.table.pack.element.version") + ":");
        versionGameLabel.setForeground(ColorUtil.COLOR_149);
        JLabel forgesLabel = new JLabel(Localizable.get("modpack.creation.forge"));
        forgesLabel.setForeground(ColorUtil.COLOR_149);
        this.create = new UpdaterFullButton(COLOR_0_174_239, ColorUtil.BLUE_MODPACK_BUTTON_UP, "modpack.create.button", "modpack-creation.button.png");
        this.create.setBorder(new EmptyBorder(0, 29, 0, 0));
        this.create.setIconTextGap(42);
        this.cancel = new UpdaterFullButton(new Color(208, 43, 43), new Color(180, 39, 39), "loginform.enter.cancel", "modpack-cancel-button.png");
        this.cancel.setBorder(new EmptyBorder(0, 29, 0, 0));
        this.cancel.setIconTextGap(42);
        this.gameVersion = new JComboBox<GameVersionDTO>(list.toArray(new GameVersionDTO[0]));
        this.gameVersion.setForeground(ColorUtil.COLOR_25);
        this.gameVersion.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, ColorUtil.COLOR_149));
        this.gameVersion.setRenderer(new CreationModpackGameVersionComboboxRenderer());
        this.gameVersion.setUI(new CreationModpackGameVersionComboboxUI());
        if (list.size() > 0) {
            list.get(0).getForgeVersions().sort(new ForgeStringComparator());
            this.forges = new JComboBox<String>(list.get(0).getForgeVersions().toArray(new String[0]));
        } else {
            this.forges = new JComboBox();
        }
        this.forges.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, ColorUtil.COLOR_149));
        this.forges.setRenderer(new CreationModpackForgeComboboxRenderer());
        this.forges.setUI(new CreationModpackForgeComboboxUI());
        this.versionName = new LocalizableTextField("modpack.creation.input.name"){

            @Override
            protected void onFocusLost() {
                super.onFocusLost();
                if (super.getValue() == null) {
                    ModpackCreation.this.versionName.setForeground(ColorUtil.COLOR_202);
                }
            }

            @Override
            protected void onFocusGained() {
                super.onFocusGained();
                ModpackCreation.this.versionName.setForeground(ColorUtil.COLOR_25);
            }
        };
        this.versionName.setHorizontalAlignment(0);
        this.versionName.setBorder(BorderFactory.createLineBorder(ColorUtil.COLOR_149, 1));
        SliderModpackPanel slider = new SliderModpackPanel(new Dimension(534, 80));
        SwingUtil.changeFontFamily(nameLabel, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_149);
        SwingUtil.changeFontFamily(forgesLabel, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_149);
        SwingUtil.changeFontFamily(versionGameLabel, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_149);
        SwingUtil.changeFontFamily(memorySettings, FontTL.ROBOTO_BOLD, 14, Color.BLACK);
        SwingUtil.changeFontFamily(selectedMemory, FontTL.ROBOTO_BOLD, 14, Color.BLACK);
        SwingUtil.changeFontFamily(optifineLabel, FontTL.ROBOTO_BOLD, 14, Color.BLACK);
        SwingUtil.changeFontFamily(optifineBox, FontTL.ROBOTO_REGULAR, 14, Color.BLACK);
        SwingUtil.changeFontFamily(this.create, FontTL.ROBOTO_BOLD, 12, Color.WHITE);
        SwingUtil.changeFontFamily(this.box, FontTL.ROBOTO_REGULAR, 14, Color.BLACK);
        SwingUtil.changeFontFamily(this.gameVersion, FontTL.ROBOTO_BOLD, 14, ColorUtil.COLOR_25);
        SwingUtil.changeFontFamily(this.forges, FontTL.ROBOTO_BOLD, 14, ColorUtil.COLOR_25);
        SwingUtil.changeFontFamily(this.cancel, FontTL.ROBOTO_BOLD, 12, Color.WHITE);
        SwingUtil.changeFontFamily(this.versionName, FontTL.ROBOTO_BOLD, 18, ColorUtil.COLOR_202);
        int height = 18;
        spring.putConstraint("West", (Component)nameLabel, 253, "West", (Component)panel);
        spring.putConstraint("East", (Component)nameLabel, 353, "West", (Component)panel);
        spring.putConstraint("North", (Component)nameLabel, 23, "North", (Component)panel);
        spring.putConstraint("South", (Component)nameLabel, 23 + height, "North", (Component)panel);
        panel.add(nameLabel);
        spring.putConstraint("West", (Component)this.versionName, 29, "West", (Component)panel);
        spring.putConstraint("East", (Component)this.versionName, -27, "East", (Component)panel);
        spring.putConstraint("North", (Component)this.versionName, 2, "South", (Component)nameLabel);
        spring.putConstraint("South", (Component)this.versionName, 46, "South", (Component)nameLabel);
        panel.add(this.versionName);
        spring.putConstraint("West", (Component)versionGameLabel, 30, "West", (Component)panel);
        spring.putConstraint("East", (Component)versionGameLabel, 267, "West", (Component)panel);
        spring.putConstraint("North", (Component)versionGameLabel, 18, "South", (Component)this.versionName);
        spring.putConstraint("South", (Component)versionGameLabel, 18 + height, "South", (Component)this.versionName);
        panel.add(versionGameLabel);
        spring.putConstraint("West", (Component)forgesLabel, 308, "West", (Component)panel);
        spring.putConstraint("East", (Component)forgesLabel, 545, "West", (Component)panel);
        spring.putConstraint("North", (Component)forgesLabel, 18, "South", (Component)this.versionName);
        spring.putConstraint("South", (Component)forgesLabel, 18 + height, "South", (Component)this.versionName);
        panel.add(forgesLabel);
        spring.putConstraint("West", this.gameVersion, 29, "West", (Component)panel);
        spring.putConstraint("East", this.gameVersion, 267, "West", (Component)panel);
        spring.putConstraint("North", this.gameVersion, 5, "South", (Component)forgesLabel);
        spring.putConstraint("South", this.gameVersion, 49, "South", (Component)forgesLabel);
        panel.add(this.gameVersion);
        spring.putConstraint("West", this.forges, 307, "West", (Component)panel);
        spring.putConstraint("East", this.forges, 545, "West", (Component)panel);
        spring.putConstraint("North", this.forges, 5, "South", (Component)forgesLabel);
        spring.putConstraint("South", this.forges, 49, "South", (Component)forgesLabel);
        panel.add(this.forges);
        spring.putConstraint("West", (Component)memorySettings, 29, "West", (Component)panel);
        spring.putConstraint("East", (Component)memorySettings, 229, "West", (Component)panel);
        spring.putConstraint("North", (Component)memorySettings, 15, "South", this.forges);
        spring.putConstraint("South", (Component)memorySettings, 32, "South", this.forges);
        panel.add(memorySettings);
        spring.putConstraint("West", (Component)this.box, 179, "West", (Component)panel);
        spring.putConstraint("East", (Component)this.box, 529, "West", (Component)panel);
        spring.putConstraint("North", (Component)this.box, 15, "South", this.forges);
        spring.putConstraint("South", (Component)this.box, 32, "South", this.forges);
        panel.add(this.box);
        spring.putConstraint("West", (Component)optifineLabel, 29, "West", (Component)panel);
        spring.putConstraint("East", (Component)optifineLabel, 229, "West", this.forges);
        spring.putConstraint("North", (Component)optifineLabel, 10, "South", (Component)memorySettings);
        spring.putConstraint("South", (Component)optifineLabel, 27, "South", (Component)memorySettings);
        panel.add(optifineLabel);
        spring.putConstraint("West", (Component)optifineBox, 179, "West", (Component)panel);
        spring.putConstraint("East", (Component)optifineBox, 529, "West", (Component)panel);
        spring.putConstraint("North", (Component)optifineBox, 10, "South", (Component)memorySettings);
        spring.putConstraint("South", (Component)optifineBox, 27, "South", (Component)memorySettings);
        panel.add(optifineBox);
        spring.putConstraint("West", (Component)this.create, 29, "West", (Component)panel);
        spring.putConstraint("East", (Component)this.create, 267, "West", (Component)panel);
        spring.putConstraint("North", (Component)this.create, -43, "South", (Component)panel);
        spring.putConstraint("South", (Component)this.create, 0, "South", (Component)panel);
        panel.add(this.create);
        spring.putConstraint("West", (Component)this.cancel, 307, "West", (Component)panel);
        spring.putConstraint("East", (Component)this.cancel, 545, "West", (Component)panel);
        spring.putConstraint("North", (Component)this.cancel, -43, "South", (Component)panel);
        spring.putConstraint("South", (Component)this.cancel, 0, "South", (Component)panel);
        panel.add(this.cancel);
        this.create.addActionListener(e -> {
            String name = this.versionName.getValue();
            if (name == null) {
                this.versionName.setBorder(BorderFactory.createLineBorder(new Color(255, 62, 62), 1));
                return;
            }
            ModpackManager modpackManager = (ModpackManager)TLauncher.getInjector().getInstance(ModpackManager.class);
            if (!modpackManager.checkNameVersion(Lists.newArrayList((Object[])new String[]{name}))) {
                this.setVisible(false);
                Alert.showLocWarning("modpack.config.memory.message");
                this.setVisible(true);
                return;
            }
            ModpackDTO modpackDTO = new ModpackDTO();
            modpackDTO.setId(-U.n());
            ModpackVersionDTO v = new ModpackVersionDTO();
            v.setId(-U.n() - 1L);
            modpackDTO.setName(name);
            v.setGameVersion(((GameVersionDTO)Objects.requireNonNull(this.gameVersion.getSelectedItem())).getName());
            v.setName("1.0");
            v.setForgeVersion((String)this.forges.getSelectedItem());
            modpackDTO.setVersion(v);
            if (!this.box.isSelected()) {
                modpackDTO.setModpackMemory(true);
                modpackDTO.setMemory(slider.getValue());
            }
            modpackManager.createModpack(name, modpackDTO, optifineBox.isSelected());
            this.setVisible(false);
        });
        this.gameVersion.addItemListener(new ItemListener(){
            private ItemListener l;

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ModpackCreation.this.forges.removeAllItems();
                    GameVersionDTO g = (GameVersionDTO)e.getItem();
                    g.getForgeVersions().sort(new ForgeStringComparator());
                    GameVersionDTO g1_7_10 = new GameVersionDTO();
                    g1_7_10.setName("1.7.10");
                    if (this.l != null) {
                        optifineBox.removeItemListener(this.l);
                    }
                    if (new GameVersionDTOComporator().compare(g1_7_10, g) < 0) {
                        optifineBox.setSelected(false);
                        this.l = i -> {
                            if (i.getStateChange() == 1) {
                                ModpackCreation.this.setVisible(false);
                                Alert.showLocMessage("modpack.config.skin.install.message");
                                optifineBox.setSelected(false);
                                ModpackCreation.this.setVisible(true);
                            }
                        };
                        optifineBox.addItemListener(this.l);
                    } else {
                        optifineBox.setSelected(true);
                    }
                    for (String s : g.getForgeVersions()) {
                        ModpackCreation.this.forges.addItem(s);
                    }
                }
            }
        });
        this.box.addItemListener(e -> {
            if (e.getStateChange() == 2) {
                this.setCenter(maxSize);
                spring.putConstraint("West", (Component)slider, 12, "West", (Component)panel);
                spring.putConstraint("East", (Component)slider, -13, "East", (Component)panel);
                spring.putConstraint("North", (Component)slider, 259, "North", (Component)panel);
                spring.putConstraint("South", (Component)slider, 339, "South", (Component)panel);
                panel.add(slider);
                spring.putConstraint("West", (Component)selectedMemory, 29, "West", (Component)panel);
                spring.putConstraint("East", (Component)selectedMemory, 29 + SwingUtil.getWidthText(selectedMemory, selectedMemory.getText()) + 5, "West", (Component)panel);
                spring.putConstraint("North", (Component)selectedMemory, 245, "North", (Component)panel);
                spring.putConstraint("South", (Component)selectedMemory, 263, "North", (Component)panel);
                panel.add(selectedMemory);
                spring.putConstraint("West", (Component)this.question, 2, "East", (Component)selectedMemory);
                spring.putConstraint("East", (Component)this.question, 25, "East", (Component)selectedMemory);
                spring.putConstraint("North", (Component)this.question, -153, "South", (Component)panel);
                spring.putConstraint("South", (Component)this.question, -133, "South", (Component)panel);
                panel.add(this.question);
                this.setCenter(maxSize);
                if (!this.c.isExist("memory.problem.message")) {
                    this.question.setVisible(false);
                }
            } else {
                panel.remove(selectedMemory);
                panel.remove(slider);
                panel.remove(this.question);
                this.setCenter(minSize);
            }
        });
        this.cancel.addActionListener(e -> this.setVisible(false));
        this.box.setSelected(true);
    }

    public static class GameVersionDTOComporator
    implements Comparator<GameVersionDTO> {
        private ForgeStringComparator comparator = new ForgeStringComparator();

        @Override
        public int compare(GameVersionDTO o1, GameVersionDTO o2) {
            return this.comparator.compare(o1.getName(), o2.getName());
        }
    }
}

