/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.modpack;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.CompoundBorder;
import net.minecraft.launcher.Http;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.tlauncher.ui.modpack.TemlateModpackFrame;
import org.tlauncher.tlauncher.ui.swing.TextWrapperLabel;
import org.tlauncher.util.ColorUtil;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.TlauncherUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.async.AsyncThread;
import org.tlauncher.util.swing.FontTL;

public class OldModpackFrame
extends TemlateModpackFrame {
    public OldModpackFrame(JFrame parent, GameEntityDTO entity, GameType type) {
        super(parent, "modpack.request.update.title", new Dimension(500, 320));
        SpringLayout spring = new SpringLayout();
        JPanel panel = new JPanel(spring);
        panel.setBackground(Color.WHITE);
        this.addCenter(panel);
        TextWrapperLabel question = new TextWrapperLabel(Localizable.get("modpack.element.old.question"));
        UpdaterButton send = new UpdaterButton(BLUE_COLOR, BLUE_COLOR_UNDER, "log.form.send");
        final JTextField link = new JTextField();
        final CompoundBorder border = new CompoundBorder(BorderFactory.createLineBorder(ColorUtil.COLOR_233, 1), BorderFactory.createEmptyBorder(0, 21, 0, 0));
        CompoundBorder redBorder = new CompoundBorder(BorderFactory.createLineBorder(Color.RED, 1), BorderFactory.createEmptyBorder(0, 21, 0, 0));
        link.setBorder(border);
        SwingUtil.changeFontFamily(link, FontTL.ROBOTO_REGULAR, 14, Color.BLACK);
        SwingUtil.changeFontFamily(question, FontTL.ROBOTO_REGULAR, 14, Color.BLACK);
        SwingUtil.changeFontFamily(send, FontTL.ROBOTO_REGULAR, 14, Color.WHITE);
        spring.putConstraint("West", (Component)question, 34, "West", (Component)panel);
        spring.putConstraint("East", (Component)question, -34, "East", (Component)panel);
        spring.putConstraint("North", (Component)question, 51, "North", (Component)panel);
        spring.putConstraint("South", (Component)question, 130, "North", (Component)panel);
        panel.add(question);
        spring.putConstraint("West", (Component)link, 34, "West", (Component)panel);
        spring.putConstraint("East", (Component)link, -34, "East", (Component)panel);
        spring.putConstraint("North", (Component)link, 20, "South", (Component)question);
        spring.putConstraint("South", (Component)link, 66, "South", (Component)question);
        panel.add(link);
        spring.putConstraint("West", (Component)send, 133, "West", (Component)panel);
        spring.putConstraint("East", (Component)send, -133, "East", (Component)panel);
        spring.putConstraint("North", (Component)send, 20, "South", (Component)link);
        spring.putConstraint("South", (Component)send, 59, "South", (Component)link);
        panel.add(send);
        send.addActionListener(e -> {
            int code = TlauncherUtil.hostAvailabilityCheck(link.getText());
            if (code == 404 || code > 500) {
                link.setBorder(redBorder);
                return;
            }
            this.setVisible(false);
            AsyncThread.execute(() -> {
                try {
                    String subUrl = TLauncher.getInnerSettings().get("modpack.operation.url") + ModpackManager.ModpackServerCommand.UPDATE.toString().toLowerCase() + "/" + entity.getId();
                    String url = Http.get(subUrl, (Map<String, Object>)new HashMap<String, Object>(){
                        {
                            this.put("url", link.getText());
                        }
                    });
                    Http.performPost(Http.constantURL(url), "", "application/json");
                    Alert.showLocMessage("modpack.send.success");
                }
                catch (Throwable throwable) {
                    Alert.showMonologError(Localizable.get().get("modpack.error.send.unsuccess"), 0);
                    U.log(throwable);
                }
            });
        });
        link.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                link.setBorder(border);
            }
        });
    }
}

