/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.settings;

import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.SpringLayout;
import net.minecraft.launcher.versions.ReleaseType;
import org.tlauncher.tlauncher.managers.VersionLists;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.editor.EditorCheckBox;
import org.tlauncher.tlauncher.ui.editor.EditorFieldChangeListener;
import org.tlauncher.tlauncher.ui.editor.EditorFileField;
import org.tlauncher.tlauncher.ui.editor.EditorResolutionField;
import org.tlauncher.tlauncher.ui.editor.EditorTextField;
import org.tlauncher.tlauncher.ui.explorer.FileChooser;
import org.tlauncher.tlauncher.ui.settings.HandlerSettings;
import org.tlauncher.tlauncher.ui.settings.PageSettings;
import org.tlauncher.tlauncher.ui.settings.SettingElement;
import org.tlauncher.tlauncher.ui.settings.SettingsMemorySlider;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.OS;

public class MinecraftSettings
extends PageSettings {
    public static final String MINECRAFT_SETTING_RAM = "minecraft.memory.ram2";
    SettingsMemorySlider slider;

    public MinecraftSettings() {
        this.setOpaque(false);
        SpringLayout springLayout = new SpringLayout();
        FileChooser fileChooser = (FileChooser)TLauncher.getInjector().getInstance(FileChooser.class);
        fileChooser.setFileSelectionMode(1);
        EditorFileField editorFileField = new EditorFileField("settings.client.gamedir.prompt", fileChooser){

            @Override
            public boolean isValueValid() {
                try {
                    File f = new File(this.getSettingsValue(), "testChooserFolder");
                    FileUtil.createFolder(f);
                    FileUtil.deleteDirectory(f);
                }
                catch (IOException e) {
                    Alert.showLocError("settings.client.gamedir.noaccess", e);
                    return false;
                }
                return super.isValueValid();
            }
        };
        EditorResolutionField editorResolutionField = new EditorResolutionField("settings.client.resolution.width", "settings.client.resolution.height", this.global.getDefaultClientWindowSize(), false);
        EditorCheckBox box = new EditorCheckBox("settings.client.resolution.fullscreen");
        ArrayList<EditorCheckBox> versions = new ArrayList<EditorCheckBox>();
        ArrayList<HandlerSettings> settings = new ArrayList<HandlerSettings>();
        EditorTextField jvmArguments = new EditorTextField("settings.java.args.jvm", true);
        EditorTextField minecraftArguments = new EditorTextField("settings.java.args.minecraft", true);
        FileChooser chooser = (FileChooser)TLauncher.getInjector().getInstance(FileChooser.class);
        JavaPathField javaPathField = new JavaPathField(OS.is(OS.WINDOWS) ? "settings.java.path.prompt.win" : "settings.java.path.prompt.other", true, chooser);
        this.slider = new SettingsMemorySlider();
        EditorFieldChangeListener changeListener = new EditorFieldChangeListener(){

            @Override
            public void onChange(String oldValue, String newValue) {
                TLauncher.getInstance().getVersionManager().updateVersionList();
            }
        };
        for (ReleaseType releaseType : ReleaseType.getDefinable()) {
            EditorCheckBox editorCheckBox = new EditorCheckBox("settings.versions." + (Object)((Object)releaseType));
            HandlerSettings handlerSettings = new HandlerSettings("minecraft.versions." + (Object)((Object)releaseType), editorCheckBox, changeListener);
            this.addHandler(handlerSettings);
            settings.add(handlerSettings);
            versions.add(editorCheckBox);
        }
        EditorCheckBox oldRelease = new EditorCheckBox("settings.versions.sub." + (Object)((Object)ReleaseType.SubType.OLD_RELEASE));
        HandlerSettings handlerSettings = new HandlerSettings("minecraft.versions.sub." + (Object)((Object)ReleaseType.SubType.OLD_RELEASE), oldRelease, changeListener);
        this.addHandler(handlerSettings);
        settings.add(handlerSettings);
        versions.add(2, oldRelease);
        SettingElement directorySettings = new SettingElement("settings.client.gamedir.label", editorFileField, 31);
        SettingElement resolution = new SettingElement("settings.client.resolution.label", this.doublePanel(editorResolutionField, 16, box), 21);
        SettingElement versionList = new SettingElement("settings.versions.label", this.createBoxes(versions), 121);
        SettingElement javaPath = new SettingElement("settings.java.path.label", javaPathField, 31);
        SettingElement memory = new SettingElement("settings.java.memory.label", this.slider, 84);
        ExtendedPanel argPanel = new ExtendedPanel();
        argPanel.setLayout(new BoxLayout(argPanel, 1));
        argPanel.add((Component)jvmArguments);
        argPanel.add(Box.createVerticalStrut(9));
        argPanel.add((Component)minecraftArguments);
        SettingElement arguments = new SettingElement("settings.java.args.label", argPanel, 84);
        this.setLayout(springLayout);
        springLayout.putConstraint("North", (Component)directorySettings, 0, "North", (Component)this);
        springLayout.putConstraint("West", (Component)directorySettings, 0, "West", (Component)this);
        springLayout.putConstraint("South", (Component)directorySettings, 27, "North", (Component)this);
        springLayout.putConstraint("East", (Component)directorySettings, 0, "East", (Component)this);
        this.add((Component)directorySettings);
        springLayout.putConstraint("North", (Component)resolution, 17, "South", (Component)directorySettings);
        springLayout.putConstraint("West", (Component)resolution, 0, "West", (Component)this);
        springLayout.putConstraint("South", (Component)resolution, 43, "South", (Component)directorySettings);
        springLayout.putConstraint("East", (Component)resolution, 0, "East", (Component)directorySettings);
        this.add((Component)resolution);
        springLayout.putConstraint("North", (Component)versionList, 6, "South", (Component)resolution);
        springLayout.putConstraint("West", (Component)versionList, 0, "West", (Component)this);
        springLayout.putConstraint("South", (Component)versionList, 138, "South", (Component)resolution);
        springLayout.putConstraint("East", (Component)versionList, 0, "East", (Component)directorySettings);
        this.add((Component)versionList);
        int gap = 0;
        if (!OS.is(OS.WINDOWS)) {
            gap = 10;
        }
        springLayout.putConstraint("North", (Component)arguments, 11, "South", (Component)versionList);
        springLayout.putConstraint("West", (Component)arguments, 0, "West", (Component)this);
        springLayout.putConstraint("South", (Component)arguments, 66 + gap, "South", (Component)versionList);
        springLayout.putConstraint("East", (Component)arguments, 0, "East", (Component)directorySettings);
        this.add((Component)arguments);
        springLayout.putConstraint("West", (Component)javaPath, 0, "West", (Component)directorySettings);
        springLayout.putConstraint("East", (Component)javaPath, 0, "East", (Component)directorySettings);
        springLayout.putConstraint("North", (Component)javaPath, 19 - gap, "South", (Component)arguments);
        springLayout.putConstraint("South", (Component)javaPath, 40, "South", (Component)arguments);
        this.add((Component)javaPath);
        springLayout.putConstraint("North", (Component)memory, 19, "South", (Component)javaPath);
        springLayout.putConstraint("South", (Component)memory, 114, "South", (Component)javaPath);
        springLayout.putConstraint("West", (Component)memory, 0, "West", (Component)directorySettings);
        springLayout.putConstraint("East", (Component)memory, 0, "East", (Component)directorySettings);
        this.add((Component)memory);
        EditorFieldChangeListener editorFieldChangeListener = new EditorFieldChangeListener(){

            @Override
            public void onChange(String oldValue, String newValue) {
                if (!MinecraftSettings.this.tlauncher.isReady()) {
                    return;
                }
                try {
                    MinecraftSettings.this.tlauncher.getManager().getComponent(VersionLists.class).updateLocal();
                }
                catch (IOException e) {
                    Alert.showLocError("settings.client.gamedir.noaccess", e);
                    return;
                }
                MinecraftSettings.this.tlauncher.getVersionManager().asyncRefresh();
                MinecraftSettings.this.tlauncher.getProfileManager().recreate();
            }
        };
        this.addHandler(new HandlerSettings("minecraft.gamedir", editorFileField, editorFieldChangeListener));
        this.addHandler(new HandlerSettings("minecraft.size", editorResolutionField));
        this.addHandler(new HandlerSettings("minecraft.fullscreen", box));
        this.addHandler(new HandlerSettings("minecraft.javaargs", jvmArguments));
        this.addHandler(new HandlerSettings("minecraft.args", minecraftArguments));
        this.addHandler(new HandlerSettings("minecraft.javadir", javaPathField));
        this.addHandler(new HandlerSettings(MINECRAFT_SETTING_RAM, this.slider));
    }

    private ExtendedPanel doublePanel(JComponent com1, int gap, JComponent comp2) {
        ExtendedPanel extendedPanel = new ExtendedPanel(new FlowLayout(0, 0, 0));
        extendedPanel.add((Component)com1);
        extendedPanel.add(Box.createHorizontalStrut(gap));
        extendedPanel.add((Component)comp2);
        return extendedPanel;
    }

    private ExtendedPanel createBoxes(List<EditorCheckBox> list) {
        ExtendedPanel extendedPanel = new ExtendedPanel();
        extendedPanel.setLayout(new BoxLayout(extendedPanel, 1));
        for (EditorCheckBox box : list) {
            extendedPanel.add((Component)box);
        }
        return extendedPanel;
    }

    @Override
    public void init() {
        this.slider.initMemoryQuestion();
        super.init();
    }

    class JavaPathField
    extends EditorFileField {
        public JavaPathField(String prompt, boolean canBeEmpty, FileChooser chooser) {
            super(prompt, canBeEmpty, chooser);
        }

        @Override
        public boolean isValueValid() {
            if (this.checkPath()) {
                return true;
            }
            Alert.showLocError("settings.java.path.doesnotexist");
            return false;
        }

        private boolean checkPath() {
            String path = this.getSettingsValue();
            if (path == null) {
                return true;
            }
            if (!(path.endsWith("java") || path.endsWith("java.exe") || path.endsWith("javaw.exe"))) {
                return false;
            }
            File javaDir = new File(path);
            return javaDir.isFile();
        }
    }
}

