/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.LocalizableRadioButton;

public class GameRadioTextButton
extends LocalizableRadioButton {
    protected Color defaultColor = new Color(60, 170, 232);
    private Color under = new Color(255, 202, 41);
    private boolean mouseUnder;

    public GameRadioTextButton(String string) {
        super(string);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                GameRadioTextButton.this.mouseUnder = true;
                GameRadioTextButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                GameRadioTextButton.this.mouseUnder = false;
                GameRadioTextButton.this.repaint();
            }
        });
        this.setForeground(Color.WHITE);
        this.setPreferredSize(new Dimension(129, 55));
    }

    @Override
    protected void paintComponent(Graphics gr) {
        super.paintComponent(gr);
        Rectangle rec = this.getVisibleRect();
        Graphics2D g2 = (Graphics2D)gr;
        this.paintBackground(g2, rec);
        this.paintText(g2, rec);
    }

    protected void paintBackground(Graphics2D g2, Rectangle rec) {
        int y = rec.y;
        g2.drawImage((Image)ImageCache.getBufferedImage((String)"modpack-radio-button-background.png"), 0, 0, null);
        if (this.isSelected() || this.mouseUnder) {
            g2.setColor(this.under);
            for (y = rec.y + rec.height - 9; y < rec.height + rec.y; ++y) {
                g2.drawLine(rec.x, y, rec.x + rec.width, y);
            }
        } else {
            g2.setColor(this.defaultColor);
            for (y = rec.y + rec.height - 9; y < rec.height + rec.y; ++y) {
                g2.drawLine(rec.x, y, rec.x + rec.width, y);
            }
        }
    }

    protected void paintText(Graphics2D g, Rectangle textRect) {
        g.setColor(this.getForeground());
        String text = this.getText();
        Graphics2D g2d = g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontMetrics fm = g2d.getFontMetrics();
        Rectangle2D r = fm.getStringBounds(text, g2d);
        g.setFont(this.getFont());
        int x = (this.getWidth() - (int)r.getWidth()) / 2;
        int y = (this.getHeight() - (int)r.getHeight()) / 2 + fm.getAscent();
        g2d.drawString(text, x, y);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }
}

