/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util;

import java.io.File;
import java.io.IOException;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.OS;
import org.tlauncher.util.U;

public class MinecraftUtil {
    public static File getWorkingDirectory() {
        if (TLauncher.getInstance() == null) {
            return MinecraftUtil.getDefaultWorkingDirectory();
        }
        Configuration settings = TLauncher.getInstance().getConfiguration();
        String sdir = settings.get("minecraft.gamedir");
        if (sdir == null) {
            return MinecraftUtil.getDefaultWorkingDirectory();
        }
        File dir = new File(sdir);
        try {
            FileUtil.createFolder(dir);
        }
        catch (IOException e) {
            U.log("Cannot createScrollWrapper specified Minecraft folder:", dir.getAbsolutePath());
            return MinecraftUtil.getDefaultWorkingDirectory();
        }
        return dir;
    }

    public static File getSystemRelatedFile(String path) {
        File file;
        String userHome = System.getProperty("user.home", ".");
        switch (OS.CURRENT) {
            case LINUX: 
            case SOLARIS: {
                file = new File(userHome, path);
                break;
            }
            case WINDOWS: {
                String applicationData = System.getenv("APPDATA");
                String folder = applicationData != null ? applicationData : userHome;
                file = new File(folder, path);
                break;
            }
            case OSX: {
                file = new File(userHome, "Library/Application Support/" + path);
                break;
            }
            default: {
                file = new File(userHome, path);
            }
        }
        return file;
    }

    public static File getSystemRelatedDirectory(String path) {
        if (!OS.is(OS.OSX, OS.UNKNOWN)) {
            path = '.' + path;
        }
        return MinecraftUtil.getSystemRelatedFile(path);
    }

    public static File getDefaultWorkingDirectory() {
        return MinecraftUtil.getSystemRelatedDirectory(TLauncher.getFolder());
    }

    public static File getTLauncherFile(String path) {
        return new File(MinecraftUtil.getSystemRelatedDirectory("tlauncher"), path);
    }
}

