/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util.advertising;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.launcher.Http;
import org.apache.commons.lang3.StringUtils;
import org.tlauncher.skin.domain.AdvertisingDTO;
import org.tlauncher.skin.domain.responce.AdvertisingResponseDTO;
import org.tlauncher.tlauncher.managers.ProfileManager;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.util.U;
import org.tlauncher.util.advertising.AdvertisingStatusObserver;

public class AdvertisingStatusObservable
implements Runnable {
    private List<AdvertisingStatusObserver> listeners = new ArrayList<AdvertisingStatusObserver>();
    private ProfileManager manager;

    @Override
    public void run() {
        this.log("started to get ad information");
        AdvertisingDTO dto = new AdvertisingDTO();
        try {
            TLauncher.getInstance();
            String url = TLauncher.getInnerSettings().get("skin.server.advertising");
            for (Account acc : this.manager.getAuthDatabase().getAccounts()) {
                if (acc.getType() != Account.AccountType.TLAUNCHER) continue;
                U.debug(acc);
                JsonObject send = new JsonObject();
                send.add("clientToken", new JsonPrimitive(this.manager.getClientToken().toString()));
                send.add("accessToken", new JsonPrimitive(acc.getAccessToken() == null ? "null" : acc.getAccessToken()));
                String res = Http.performPost(new URL(url), send.toString(), "application/json");
                AdvertisingResponseDTO advertisingResponseDTO = new Gson().fromJson(res, AdvertisingResponseDTO.class);
                if (StringUtils.isNotBlank((CharSequence)advertisingResponseDTO.getError())) {
                    this.log(advertisingResponseDTO.getError() + " " + advertisingResponseDTO.getErrorMessage());
                    continue;
                }
                acc.setAccessToken(advertisingResponseDTO.getAccessToken());
                if (!advertisingResponseDTO.getUser().isAccountStatus()) continue;
                acc.setPremiumAccount(true);
                dto = advertisingResponseDTO.getAdvertising();
                break;
            }
        }
        catch (MalformedURLException e) {
            this.log(e);
        }
        catch (JsonSyntaxException | IOException e) {
            this.log(e);
        }
        this.log("finished to get add information");
        this.notifyObserver(dto);
    }

    public void addListeners(AdvertisingStatusObserver advertisingStatusListerner) {
        this.listeners.add(advertisingStatusListerner);
    }

    public void removeListener(AdvertisingStatusObserver advertisingStatusListerner) {
        this.listeners.remove(advertisingStatusListerner);
    }

    public ProfileManager getManager() {
        return this.manager;
    }

    public void setManager(ProfileManager manager) {
        this.manager = manager;
    }

    public void notifyObserver(AdvertisingDTO advertisingDTO) {
        for (AdvertisingStatusObserver advertisingStatusObserver : this.listeners) {
            advertisingStatusObserver.advertisingReceived(advertisingDTO);
        }
    }

    private void log(Object o) {
        U.log("[AdvertisingStatusObserver] ", o);
    }
}

