/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util.gson.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import net.minecraft.launcher.versions.json.DateTypeAdapter;
import net.minecraft.launcher.versions.json.LowerCaseEnumTypeAdapterFactory;
import org.tlauncher.modpack.domain.client.MapDTO;
import org.tlauncher.modpack.domain.client.version.MetadataDTO;
import org.tlauncher.modpack.domain.client.version.VersionDTO;
import org.tlauncher.util.gson.serializer.ElementCollectionsPool;
import org.tlauncher.util.gson.serializer.MetadataDTOAdapter;

public class MapDTOTypeAdapter
implements JsonSerializer<MapDTO>,
JsonDeserializer<MapDTO> {
    private Gson gson;

    public MapDTOTypeAdapter() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory(new LowerCaseEnumTypeAdapterFactory());
        builder.registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)MetadataDTO.class), new MetadataDTOAdapter());
        builder.enableComplexMapKeySerialization();
        this.gson = builder.create();
    }

    @Override
    public MapDTO deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        MapDTO dto = this.gson.fromJson(jsonElement, MapDTO.class);
        JsonObject object = jsonElement.getAsJsonObject();
        VersionDTO version = this.gson.fromJson(object.get("version"), VersionDTO.class);
        dto.setVersions((List)this.gson.fromJson(object.get("versions"), new TypeToken<List<VersionDTO>>(){}.getType()));
        dto.setVersion(version);
        ElementCollectionsPool.fill(dto);
        return dto;
    }

    @Override
    public JsonElement serialize(MapDTO modpackDTO, Type type, JsonSerializationContext jsonSerializationContext) {
        return this.gson.toJsonTree(modpackDTO);
    }
}

