/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util.stream;

import java.io.IOException;
import java.io.OutputStream;
import org.tlauncher.util.stream.LinkedStringStream;

public class MirroredLinkedStringStream
extends LinkedStringStream {
    private OutputStream mirror;

    protected MirroredLinkedStringStream() {
    }

    protected OutputStream getMirror() {
        return this.mirror;
    }

    public void setMirror(OutputStream stream) {
        this.mirror = stream;
    }

    @Override
    public void write(char b) {
        super.write(b);
        if (this.mirror != null) {
            try {
                this.mirror.write(b);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot log into the mirror!", e);
            }
        }
    }

    @Override
    public void flush() {
        super.flush();
        if (this.mirror != null) {
            try {
                this.mirror.flush();
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot flush the mirror!", e);
            }
        }
    }
}

