/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util.stream;

import java.io.PrintStream;
import java.util.Formatter;
import java.util.Locale;
import org.tlauncher.util.U;
import org.tlauncher.util.stream.LinkedStringStream;
import org.tlauncher.util.stream.Logger;

public class PrintLogger
extends PrintStream
implements Logger {
    private LinkedStringStream stream;
    private Logger mirror;
    private Formatter formatter;

    private PrintLogger(LinkedStringStream stream, Logger mirror) {
        super(stream);
        this.stream = stream;
        this.mirror = mirror;
    }

    public PrintLogger(LinkedStringStream stream) {
        this(stream, null);
    }

    public void setMirror(Logger logger) {
        if (this == logger) {
            throw new IllegalArgumentException();
        }
        this.mirror = logger;
    }

    @Override
    public void log(Object ... o) {
        this.log(U.toLog(o));
    }

    @Override
    public void log(String s) {
        this.println(s);
        if (this.mirror != null) {
            this.mirror.log(s);
        }
    }

    @Override
    public void rawlog(String s) {
        if (this.mirror != null) {
            this.mirror.rawlog(s);
        }
    }

    @Override
    public void rawlog(char[] c) {
        if (this.mirror != null) {
            this.mirror.rawlog(c);
        }
    }

    public LinkedStringStream getStream() {
        return this.stream;
    }

    @Override
    public synchronized void write(int b) {
        this.stream.write(b);
    }

    @Override
    public synchronized void write(byte[] buf, int off, int len) {
        this.stream.write(buf, off, len);
    }

    private synchronized void write(String s) {
        if (s == null) {
            s = "null";
        }
        this.stream.write(s.toCharArray());
    }

    @Override
    public synchronized void print(char c) {
        this.stream.write(c);
    }

    @Override
    public synchronized void print(char[] s) {
        this.stream.write(s);
    }

    @Override
    public synchronized void print(boolean b) {
        this.write(b ? "true" : "false");
    }

    @Override
    public synchronized void print(int i) {
        this.write(String.valueOf(i));
    }

    @Override
    public synchronized void print(long l) {
        this.write(String.valueOf(l));
    }

    @Override
    public synchronized void print(float f) {
        this.write(String.valueOf(f));
    }

    @Override
    public synchronized void print(double d) {
        this.write(String.valueOf(d));
    }

    @Override
    public synchronized void print(String s) {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    @Override
    public synchronized void print(Object obj) {
        this.write(String.valueOf(obj));
    }

    private void newLine() {
        this.write(10);
    }

    @Override
    public synchronized void println() {
        this.newLine();
    }

    @Override
    public synchronized void println(boolean x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public synchronized void println(char x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public synchronized void println(int x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public synchronized void println(long x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public synchronized void println(float x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public synchronized void println(double x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public synchronized void println(char[] x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public synchronized void println(String x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public synchronized void println(Object x) {
        this.print(String.valueOf(x));
        this.newLine();
    }

    @Override
    public synchronized PrintStream printf(String format, Object ... args) {
        return this.format(format, args);
    }

    @Override
    public synchronized PrintStream printf(Locale l, String format, Object ... args) {
        return this.format(l, format, args);
    }

    @Override
    public synchronized PrintStream format(String format, Object ... args) {
        if (this.formatter == null || this.formatter.locale() != Locale.getDefault()) {
            this.formatter = new Formatter((Appendable)this);
        }
        this.formatter.format(Locale.getDefault(), format, args);
        return this;
    }

    @Override
    public synchronized PrintStream format(Locale l, String format, Object ... args) {
        if (this.formatter == null || this.formatter.locale() != l) {
            this.formatter = new Formatter(this, l);
        }
        this.formatter.format(l, format, args);
        return this;
    }

    @Override
    public synchronized PrintStream append(CharSequence csq) {
        if (csq == null) {
            this.print("null");
        } else {
            this.print(csq.toString());
        }
        return this;
    }

    @Override
    public synchronized PrintStream append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public synchronized PrintStream append(char c) {
        this.print(c);
        return this;
    }
}

