/*
 * Decompiled with CFR 0.152.
 */
package com.sothawo.mapjfx.cache;

import com.sothawo.mapjfx.cache.CachedDataInfo;
import com.sothawo.mapjfx.cache.CachingURLStreamHandlerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public enum OfflineCache {
    INSTANCE;

    private static final Logger logger;
    private static final String TILE_OPENSTREETMAP_ORG = "[a-z]\\.tile\\.openstreetmap\\.org";
    private final Collection<Pattern> noCachePatterns = new ArrayList<Pattern>();
    private boolean urlStreamHandlerFactoryIsInitialized = false;
    private boolean active = false;
    private Path cacheDirectory;

    static void clearDirectory(Path path) throws IOException {
        Files.walkFileTree(path, new DeletingFileVisitor(path));
    }

    public Collection<String> getNoCacheFilters() {
        return this.noCachePatterns.stream().map(Pattern::toString).collect(Collectors.toList());
    }

    public void setNoCacheFilters(Collection<String> noCacheFilters) {
        this.noCachePatterns.clear();
        if (null != noCacheFilters) {
            noCacheFilters.stream().map(Pattern::compile).forEach(this.noCachePatterns::add);
        }
    }

    public Path getCacheDirectory() {
        return this.cacheDirectory;
    }

    public void setCacheDirectory(Path cacheDirectory) {
        Path dir = Objects.requireNonNull(cacheDirectory);
        if (!Files.isDirectory(dir, new LinkOption[0]) || !Files.isWritable(dir)) {
            throw new IllegalArgumentException("cacheDirectory: " + dir);
        }
        this.cacheDirectory = dir;
    }

    public void setCacheDirectory(String cacheDirectory) {
        this.setCacheDirectory(FileSystems.getDefault().getPath(Objects.requireNonNull(cacheDirectory), new String[0]));
    }

    public void removeExpiredCache() {
        try {
            for (File f : this.cacheDirectory.toFile().listFiles()) {
                CachedDataInfo cdi;
                File info;
                String[] ss = f.getName().split("\\.");
                if (ss.length < 2 || ss[ss.length - 1].equalsIgnoreCase("datainfo") || !(info = new File(f.getAbsoluteFile() + ".dataInfo")).exists() || (cdi = this.readCachedDataInfo(info)) == null || cdi.getTimestamp() > System.currentTimeMillis()) continue;
                f.delete();
                info.delete();
            }
        }
        catch (Exception ex) {
            logger.error("error with cleaning", ex);
        }
    }

    boolean urlShouldBeCached(URL u) {
        if (!this.isActive()) {
            return false;
        }
        String urlString = u.toString();
        return this.noCachePatterns.stream().filter(pattern -> pattern.matcher(urlString).matches()).noneMatch(pattern -> true);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        if (active && null == this.cacheDirectory) {
            throw new IllegalArgumentException("cannot setActive when no cacheDirectory is set");
        }
        if (active) {
            this.setupURLStreamHandlerFactory();
        }
        this.active = active;
    }

    private void setupURLStreamHandlerFactory() {
        if (!this.urlStreamHandlerFactoryIsInitialized) {
            String msg;
            block5: {
                try {
                    URL.setURLStreamHandlerFactory(new CachingURLStreamHandlerFactory(this));
                    this.urlStreamHandlerFactoryIsInitialized = true;
                    return;
                }
                catch (Error e) {
                    msg = "cannot setup URLStreamFactoryHandler, it is already set in this application. " + e.getMessage();
                    if (logger.isTraceEnabled()) {
                        logger.error(msg);
                    }
                }
                catch (SecurityException e) {
                    msg = "cannot setup URLStreamFactoryHandler. " + e.getMessage();
                    if (!logger.isTraceEnabled()) break block5;
                    logger.error(msg);
                }
            }
            throw new IllegalStateException(msg);
        }
    }

    boolean isCached(URL url) {
        try {
            Path cacheFile = this.filenameForURL(url);
            return Files.exists(cacheFile, new LinkOption[0]) && Files.isReadable(cacheFile) && Files.size(cacheFile) > 0L;
        }
        catch (Exception e) {
            if (logger.isTraceEnabled()) {
                logger.warn(e.getMessage());
            }
            return false;
        }
    }

    Path filenameForURL(URL url) throws UnsupportedEncodingException {
        if (null == this.cacheDirectory) {
            throw new IllegalStateException("cannot resolve filename for url");
        }
        String mappedString = Objects.requireNonNull(this.doMappings(url.toExternalForm()));
        String encodedString = URLEncoder.encode(mappedString, "UTF-8");
        return this.cacheDirectory.resolve(encodedString);
    }

    private String doMappings(String urlString) {
        if (null == urlString || urlString.isEmpty()) {
            return urlString;
        }
        return urlString.replaceAll(TILE_OPENSTREETMAP_ORG, "x.tile.openstreetmap.org");
    }

    void saveCachedDataInfo(Path cacheFile, CachedDataInfo cachedDataInfo) {
        block15: {
            Path cacheDataFile = Paths.get(cacheFile + ".dataInfo", new String[0]);
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(cacheDataFile.toFile()));){
                oos.writeObject(cachedDataInfo);
                oos.flush();
                if (logger.isTraceEnabled()) {
                    logger.trace("saved dataInfo " + cacheDataFile);
                }
            }
            catch (Exception e) {
                if (!logger.isTraceEnabled()) break block15;
                logger.warn("could not save dataInfo " + cacheDataFile);
            }
        }
    }

    CachedDataInfo readCachedDataInfo(Path cacheFile) {
        CachedDataInfo cachedDataInfo;
        block15: {
            cachedDataInfo = null;
            Path cacheDataFile = Paths.get(cacheFile + ".dataInfo", new String[0]);
            if (Files.exists(cacheDataFile, new LinkOption[0])) {
                try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(cacheDataFile.toFile()));){
                    cachedDataInfo = (CachedDataInfo)ois.readObject();
                }
                catch (Exception e) {
                    if (!logger.isTraceEnabled()) break block15;
                    logger.warn("could not read dataInfo from " + cacheDataFile + ", " + e.getMessage());
                }
            }
        }
        return cachedDataInfo;
    }

    private CachedDataInfo readCachedDataInfo(File f) {
        CachedDataInfo cachedDataInfo;
        block14: {
            cachedDataInfo = null;
            try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));){
                cachedDataInfo = (CachedDataInfo)ois.readObject();
            }
            catch (Exception e) {
                if (!logger.isTraceEnabled()) break block14;
                logger.warn("could not read dataInfo from " + f + ", " + e.getMessage());
            }
        }
        return cachedDataInfo;
    }

    public void clear() throws IOException {
        if (null != this.cacheDirectory) {
            OfflineCache.clearDirectory(this.cacheDirectory);
        }
    }

    static {
        logger = Logger.getLogger(OfflineCache.class);
    }

    private static class DeletingFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path rootDir;

        public DeletingFileVisitor(Path path) {
            this.rootDir = path;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (!attrs.isDirectory()) {
                Files.delete(file);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (!dir.equals(this.rootDir)) {
                Files.delete(dir);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

