/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.common.NBTBase;

public class NBTTagDouble
extends NBTBase {
    public double data;

    public NBTTagDouble(String par1Str) {
        super(par1Str);
    }

    public NBTTagDouble(String par1Str, double par2) {
        super(par1Str);
        this.data = par2;
    }

    @Override
    void write(DataOutput par1DataOutput) throws IOException {
        par1DataOutput.writeDouble(this.data);
    }

    @Override
    void load(DataInput par1DataInput, int par2) throws IOException {
        this.data = par1DataInput.readDouble();
    }

    @Override
    public byte getId() {
        return 6;
    }

    public String toString() {
        return "" + this.data;
    }

    @Override
    public NBTBase copy() {
        return new NBTTagDouble(this.getName(), this.data);
    }

    @Override
    public boolean equals(Object par1Obj) {
        if (super.equals(par1Obj)) {
            NBTTagDouble var2 = (NBTTagDouble)par1Obj;
            return this.data == var2.data;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long var1 = Double.doubleToLongBits(this.data);
        return super.hashCode() ^ (int)(var1 ^ var1 >>> 32);
    }
}

