/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.launcher.process.JavaProcess;
import net.minecraft.launcher.process.JavaProcessListener;

class ProcessMonitorThread
extends Thread {
    private final JavaProcess process;
    private JavaProcessListener listener;

    public ProcessMonitorThread(JavaProcess process, JavaProcessListener listener) {
        this.process = process;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Process raw = this.process.getRawProcess();
        InputStreamReader reader = new InputStreamReader(raw.getInputStream());
        BufferedReader buf = new BufferedReader(reader);
        while (this.process.isRunning()) {
            try {
                String line;
                while ((line = buf.readLine()) != null) {
                    if (this.listener != null) {
                        this.listener.onJavaProcessLog(this.process, line);
                    }
                    this.process.getSysOutLines().add(line);
                }
            }
            catch (Throwable ex) {}
            continue;
            finally {
                try {
                    buf.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(ProcessMonitorThread.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        if (Objects.nonNull(this.listener)) {
            this.listener.onJavaProcessEnded(this.process);
        }
    }
}

