/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.launcher.updater.StreamVersionList;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.Version;
import net.minecraft.launcher.versions.json.Argument;
import net.minecraft.launcher.versions.json.ArgumentType;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.version.ModpackVersionDTO;
import org.tlauncher.tlauncher.repository.ClientInstanceRepo;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.OS;
import org.tlauncher.util.U;

public class LocalVersionList
extends StreamVersionList {
    private File baseDirectory;
    private File baseVersionsDir;

    public LocalVersionList(File baseDirectory) throws IOException {
        this.setBaseDirectory(baseDirectory);
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(File directory) throws IOException {
        if (directory == null) {
            throw new IllegalArgumentException("Base directory is NULL!");
        }
        FileUtil.createFolder(directory);
        this.log("Base directory:", directory.getAbsolutePath());
        this.baseDirectory = directory;
        this.baseVersionsDir = new File(this.baseDirectory, "versions");
    }

    @Override
    public synchronized void refreshVersions() {
        this.clearCache();
        File[] files = this.baseVersionsDir.listFiles();
        if (files == null) {
            return;
        }
        for (File directory : files) {
            String id = directory.getName();
            File jsonFile = new File(directory, id + ".json");
            if (!directory.isDirectory() || !jsonFile.isFile()) continue;
            try {
                CompleteVersion version = this.gson.fromJson(this.getUrl("versions/" + id + "/" + id + ".json"), CompleteVersion.class);
                if (version == null) {
                    this.log("JSON descriptor of version \"" + id + "\" in NULL, it won't be added in list as local.");
                    continue;
                }
                version.setID(id);
                version.setSource(ClientInstanceRepo.LOCAL_VERSION_REPO);
                version.setVersionList(this);
                if (version.getID().equals("17w43b") && version.getArguments() == null) {
                    this.log("skip 17w43b version ");
                    continue;
                }
                boolean save = false;
                if (version.getID().length() > 256) {
                    version.setID(id);
                    save = true;
                }
                if (version.isModpack()) {
                    if (version.getModpack().getName().length() > 256) {
                        version.getModpack().setName(id);
                        save = true;
                    }
                    for (GameType type : GameType.getSubEntities()) {
                        List<? extends GameEntityDTO> list = ((ModpackVersionDTO)version.getModpack().getVersion()).getByType(type);
                        Iterator<? extends GameEntityDTO> it = list.iterator();
                        while (it.hasNext()) {
                            GameEntityDTO el = it.next();
                            if (type.equals((Object)GameType.MAP)) {
                                if (el.getName().length() <= 256 && el.getVersion().getMetadata().getPath().length() <= 256) continue;
                                it.remove();
                                save = true;
                                continue;
                            }
                            if (el.getName().length() <= 256) continue;
                            save = true;
                            el.setName("fixed_bug_2.49_" + U.n());
                        }
                    }
                }
                if (version.getID().equalsIgnoreCase(version.getInheritsFrom())) {
                    version = this.renameVersion(version, this.findNewVersionName(version.getID(), 0));
                }
                if (save) {
                    this.saveVersion(version);
                    U.gc();
                }
                this.checkDoubleArgument(version);
                this.addVersion(version);
            }
            catch (Throwable ex) {
                this.log("Error occurred while parsing local version", id, ex);
            }
        }
    }

    private void checkDoubleArgument(CompleteVersion version) throws IOException {
        Map<ArgumentType, List<Argument>> map = version.getArguments();
        if (Objects.nonNull(map)) {
            List<Argument> list = map.get((Object)ArgumentType.GAME);
            if (Objects.isNull(list)) {
                return;
            }
            if (list.size() > 30) {
                HashSet set = new HashSet();
                list.removeIf(e -> {
                    String value = Arrays.toString(e.getValues());
                    if (set.contains(value)) {
                        U.log("removed arg " + e);
                        return true;
                    }
                    set.add(value);
                    return false;
                });
                this.saveVersion(version);
            }
        }
    }

    private String findNewVersionName(String name, int i) {
        String newName = name + " fixed " + i;
        File f = new File(this.baseVersionsDir, newName);
        if (f.exists()) {
            return this.findNewVersionName(name, ++i);
        }
        return newName;
    }

    public synchronized void saveVersion(CompleteVersion version) throws IOException {
        String text = this.serializeVersion(version);
        File target = new File(this.baseVersionsDir, version.getID() + "/" + version.getID() + ".json");
        FileUtil.writeFile(target, text);
    }

    public synchronized void deleteVersion(String id, boolean deleteLibraries) throws IOException {
        CompleteVersion version = this.getCompleteVersion(id);
        if (version == null) {
            throw new IllegalArgumentException("Version is not installed! id = " + id);
        }
        File dir = new File(this.baseVersionsDir, id + '/');
        if (!dir.isDirectory()) {
            throw new IOException("Cannot find directory: " + dir.getAbsolutePath());
        }
        FileUtil.deleteDirectory(dir);
        if (!deleteLibraries) {
            return;
        }
        for (File library : version.getClassPath(this.baseDirectory)) {
            FileUtil.deleteFile(library);
        }
        for (String nativeLib : version.getNatives()) {
            FileUtil.deleteFile(new File(this.baseDirectory, nativeLib));
        }
    }

    @Override
    protected InputStream getInputStream(String uri) throws IOException {
        return new FileInputStream(new File(this.baseDirectory, uri));
    }

    @Override
    public boolean hasAllFiles(CompleteVersion version, OS os) {
        Set<String> files = version.getRequiredFiles(os);
        for (String file : files) {
            File required = new File(this.baseDirectory, file);
            if (required.isFile() && required.length() != 0L) continue;
            return false;
        }
        return true;
    }

    public synchronized CompleteVersion renameVersion(CompleteVersion version, String name) throws IOException {
        File newFolder;
        CompleteVersion newVersion = version.fullCopy(new CompleteVersion());
        newVersion.setID(name);
        if (Objects.nonNull(version.getModpack())) {
            newVersion.getModpack().setName(name);
        }
        if ((newFolder = new File(this.baseVersionsDir.toString(), newVersion.getID())).exists()) {
            throw new IOException("folder exists " + newFolder);
        }
        String oldName = version.getID();
        File oldJar = new File(this.baseVersionsDir.toString(), version.getID() + "/" + version.getID() + ".jar");
        File newJar = new File(this.baseVersionsDir.toString(), version.getID() + "/" + newVersion.getID() + ".jar");
        if (oldJar.exists() && !oldJar.renameTo(newJar)) {
            throw new IOException("can't rename from " + oldJar + "to " + newJar);
        }
        File oldFolder = new File(this.baseVersionsDir.toString(), oldName);
        if (!oldFolder.renameTo(newFolder)) {
            throw new IOException("can't rename from " + version.getID() + "to " + newVersion.getID());
        }
        FileUtil.deleteFile(new File(this.baseVersionsDir.toString(), newVersion.getID() + "/" + version.getID() + ".json"));
        this.saveVersion(newVersion);
        return newVersion;
    }

    public synchronized void refreshLocalVersion(CompleteVersion version) throws IOException {
        this.saveVersion(version);
        version.setSource(ClientInstanceRepo.LOCAL_VERSION_REPO);
        version.setVersionList(this);
        this.byName.put(version.getID(), version);
        for (int i = 0; i < this.versions.size(); ++i) {
            if (!((Version)this.versions.get(i)).getID().equalsIgnoreCase(version.getID())) continue;
            this.versions.remove(i);
            this.versions.add(i, version);
            return;
        }
    }
}

