/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.Library;
import net.minecraft.launcher.versions.Version;
import org.tlauncher.tlauncher.downloader.Downloadable;
import org.tlauncher.tlauncher.managers.VersionManager;
import org.tlauncher.tlauncher.repository.ClientInstanceRepo;
import org.tlauncher.tlauncher.repository.Repo;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.OS;

public class VersionSyncInfo {
    Version localVersion;
    Version remoteVersion;
    private CompleteVersion completeLocal;
    private CompleteVersion completeRemote;
    private String id;

    public VersionSyncInfo(Version localVersion, Version remoteVersion) {
        if (localVersion == null && remoteVersion == null) {
            throw new NullPointerException("Cannot createScrollWrapper sync info from NULLs!");
        }
        this.localVersion = localVersion;
        this.remoteVersion = remoteVersion;
        if (localVersion != null && remoteVersion != null) {
            localVersion.setVersionList(remoteVersion.getVersionList());
        }
        if (this.getID() == null) {
            throw new NullPointerException("Cannot createScrollWrapper sync info from versions that have NULL IDs");
        }
    }

    public VersionSyncInfo(VersionSyncInfo info) {
        this(info.getLocal(), info.getRemote());
    }

    private VersionSyncInfo() {
        this.localVersion = null;
        this.remoteVersion = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.getID() == null || !(o instanceof VersionSyncInfo)) {
            return false;
        }
        VersionSyncInfo v = (VersionSyncInfo)o;
        return this.getID().equals(v.getID());
    }

    public Version getLocal() {
        return this.localVersion;
    }

    public void setLocal(Version version) {
        this.localVersion = version;
        if (version instanceof CompleteVersion) {
            this.completeLocal = (CompleteVersion)version;
        }
    }

    public Version getRemote() {
        return this.remoteVersion;
    }

    public void setRemote(Version version) {
        this.remoteVersion = version;
        if (version instanceof CompleteVersion) {
            this.completeRemote = (CompleteVersion)version;
        }
    }

    public String getID() {
        if (this.id != null) {
            return this.id;
        }
        if (this.localVersion != null) {
            return this.localVersion.getID();
        }
        if (this.remoteVersion != null) {
            return this.remoteVersion.getID();
        }
        return null;
    }

    public void setID(String id) {
        if (id != null && id.isEmpty()) {
            throw new IllegalArgumentException("ID cannot be empty!");
        }
        this.id = id;
    }

    public Version getLatestVersion() {
        if (this.remoteVersion != null) {
            return this.remoteVersion;
        }
        return this.localVersion;
    }

    public Version getAvailableVersion() {
        if (this.localVersion != null) {
            return this.localVersion;
        }
        return this.remoteVersion;
    }

    public boolean isInstalled() {
        return this.localVersion != null;
    }

    public boolean hasRemote() {
        return this.remoteVersion != null;
    }

    public boolean isUpToDate() {
        if (this.localVersion == null) {
            return false;
        }
        if (this.remoteVersion == null) {
            return true;
        }
        return this.localVersion.getUpdatedTime().compareTo(this.remoteVersion.getUpdatedTime()) >= 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{id='" + this.getID() + "',\nlocal=" + this.localVersion + ",\nremote=" + this.remoteVersion + ", isInstalled=" + this.isInstalled() + ", hasRemote=" + this.hasRemote() + ", isUpToDate=" + this.isUpToDate() + "}";
    }

    public CompleteVersion resolveCompleteVersion(VersionManager manager, boolean latest) throws IOException {
        Version version = latest ? this.getLatestVersion() : (this.isInstalled() ? this.getLocal() : this.getRemote());
        if (version.equals(this.localVersion) && this.completeLocal != null && this.completeLocal.getInheritsFrom() == null) {
            return this.completeLocal;
        }
        if (version.equals(this.remoteVersion) && this.completeRemote != null && this.completeRemote.getInheritsFrom() == null) {
            return this.completeRemote;
        }
        CompleteVersion complete = version.getVersionList().getCompleteVersion(version).resolve(manager, latest);
        if (version == this.localVersion) {
            this.completeLocal = complete;
        } else if (version == this.remoteVersion) {
            this.completeRemote = complete;
        }
        return complete;
    }

    public CompleteVersion getCompleteVersion(boolean latest) throws IOException {
        Version version = latest ? this.getLatestVersion() : (this.isInstalled() ? this.getLocal() : this.getRemote());
        if (version.equals(this.localVersion) && this.completeLocal != null) {
            return this.completeLocal;
        }
        if (version.equals(this.remoteVersion) && this.completeRemote != null) {
            return this.completeRemote;
        }
        CompleteVersion complete = version.getVersionList().getCompleteVersion(version);
        if (version == this.localVersion) {
            this.completeLocal = complete;
        } else if (version == this.remoteVersion) {
            this.completeRemote = complete;
        }
        return complete;
    }

    public CompleteVersion getLatestCompleteVersion() throws IOException {
        return this.getCompleteVersion(true);
    }

    public CompleteVersion getLocalCompleteVersion() {
        return this.completeLocal;
    }

    private Set<Downloadable> getRequiredDownloadables(OS os, File targetDirectory, boolean force, boolean tlauncher) throws IOException {
        File local;
        Repo source;
        HashSet<Downloadable> neededFiles = new HashSet<Downloadable>();
        CompleteVersion version = this.getCompleteVersion(force);
        version = TLauncher.getInstance().getTLauncherManager().addReplacedLibraries(version, tlauncher);
        Repo repo = source = this.hasRemote() ? this.remoteVersion.getSource() : ClientInstanceRepo.OFFICIAL_VERSION_REPO;
        if (!source.isSelectable()) {
            return neededFiles;
        }
        for (Library library : version.getRelevantLibraries()) {
            local = this.analizeFolderLibrary(os, targetDirectory, force, library);
            if (local == null) continue;
            neededFiles.add(library.getDownloadable(source, local, os));
        }
        if (version.getModsLibraries() != null) {
            for (Library library : version.getModsLibraries()) {
                local = this.analizeFolderLibrary(os, targetDirectory, force, library);
                if (local == null) continue;
                neededFiles.add(library.getDownloadable(source, local, os));
            }
        }
        return neededFiles;
    }

    private File analizeFolderLibrary(OS os, File targetDirectory, boolean force, Library library) {
        String file = null;
        if (library.getNatives() != null) {
            String natives = library.getNatives().get((Object)os);
            if (natives != null) {
                file = library.getArtifactPath(natives);
            }
        } else {
            file = library.getArtifactPath();
        }
        if (file == null) {
            return null;
        }
        File local = new File(targetDirectory, "libraries/" + file);
        if (!force && local.isFile()) {
            if (library.getChecksum() == null || Objects.nonNull(library.getDeleteEntriesList())) {
                return null;
            }
            if (library.getChecksum().equals(FileUtil.getChecksum(local, "SHA-1"))) {
                return null;
            }
        }
        return local;
    }

    public Set<Downloadable> getRequiredDownloadables(File targetDirectory, boolean force, boolean tlauncher) throws IOException {
        return this.getRequiredDownloadables(OS.CURRENT, targetDirectory, force, tlauncher);
    }

    public static VersionSyncInfo createEmpty() {
        return new VersionSyncInfo();
    }
}

