/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.launcher.updater.VersionList;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.AbstractVersion;
import net.minecraft.launcher.versions.Library;
import net.minecraft.launcher.versions.ReleaseType;
import net.minecraft.launcher.versions.Rule;
import net.minecraft.launcher.versions.Version;
import net.minecraft.launcher.versions.json.Argument;
import net.minecraft.launcher.versions.json.ArgumentType;
import net.minecraft.launcher.versions.json.DateTypeAdapter;
import net.minecraft.launcher.versions.json.LowerCaseEnumTypeAdapterFactory;
import net.minecraft.launcher.versions.json.RepoTypeAdapter;
import org.tlauncher.modpack.domain.client.ModpackDTO;
import org.tlauncher.modpack.domain.client.version.MetadataDTO;
import org.tlauncher.tlauncher.managers.VersionManager;
import org.tlauncher.tlauncher.repository.ClientInstanceRepo;
import org.tlauncher.tlauncher.repository.Repo;
import org.tlauncher.util.OS;
import org.tlauncher.util.U;
import org.tlauncher.util.gson.serializer.ModpackDTOTypeAdapter;

public class CompleteVersion
extends AbstractVersion
implements Cloneable {
    String id;
    String jar;
    String inheritsFrom;
    Date time;
    Date releaseTime;
    ReleaseType type;
    String jvmArguments;
    String minecraftArguments;
    String mainClass;
    Integer minimumLauncherVersion = 0;
    Integer tlauncherVersion = 0;
    Map<ArgumentType, List<Argument>> arguments;
    String assets;
    Repo source;
    VersionList list;
    private boolean skinVersion;
    List<Library> libraries;
    List<Rule> rules;
    List<String> deleteEntries;
    private List<Library> modsLibraries;
    private Map<String, MetadataDTO> downloads;
    private AssetsMetadata assetIndex;
    private List<MetadataDTO> additionalFiles;
    private ModpackDTO modpack;

    public boolean isModpack() {
        return this.modpack != null;
    }

    public AssetsMetadata getAssetIndex() {
        return this.assetIndex;
    }

    public void setAssetIndex(AssetsMetadata assetIndex) {
        this.assetIndex = assetIndex;
    }

    public Map<String, MetadataDTO> getDownloads() {
        return this.downloads;
    }

    public void setDownloads(Map<String, MetadataDTO> downloads) {
        this.downloads = downloads;
    }

    public List<Library> getModsLibraries() {
        return this.modsLibraries;
    }

    public void setModsLibraries(List<Library> modsLibraries) {
        this.modsLibraries = modsLibraries;
    }

    @Override
    public boolean isSkinVersion() {
        return this.skinVersion;
    }

    @Override
    public void setSkinVersion(boolean skinVersion) {
        this.skinVersion = skinVersion;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("ID is NULL or empty");
        }
        this.id = id;
    }

    @Override
    public ReleaseType getReleaseType() {
        return this.type;
    }

    @Override
    public Repo getSource() {
        return this.source;
    }

    @Override
    public void setSource(Repo repo) {
        if (repo == null) {
            throw new NullPointerException();
        }
        this.source = repo;
    }

    @Override
    public Date getUpdatedTime() {
        return this.time;
    }

    public void setUpdatedTime(Date time) {
        if (time == null) {
            throw new NullPointerException("Time is NULL!");
        }
        this.time = time;
    }

    @Override
    public Date getReleaseTime() {
        return this.releaseTime;
    }

    @Override
    public VersionList getVersionList() {
        return this.list;
    }

    @Override
    public void setVersionList(VersionList list) {
        if (list == null) {
            throw new NullPointerException("VersionList cannot be NULL!");
        }
        this.list = list;
    }

    @Override
    public String getJar() {
        return this.jar;
    }

    public String getInheritsFrom() {
        return this.inheritsFrom;
    }

    public String getJVMArguments() {
        return this.jvmArguments;
    }

    public String getMinecraftArguments() {
        return this.minecraftArguments;
    }

    public void setMinecraftArguments(String args) {
        this.minecraftArguments = args;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String clazz) {
        this.mainClass = clazz;
    }

    public List<Library> getLibraries() {
        return this.libraries;
    }

    public List<Rule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public List<String> getDeleteEntries() {
        return this.deleteEntries;
    }

    public int getMinimumLauncherVersion() {
        return this.minimumLauncherVersion;
    }

    public int getMinimumCustomLauncherVersion() {
        return this.tlauncherVersion;
    }

    public String getAssets() {
        return this.assets == null ? "legacy" : this.assets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.hashCode() == o.hashCode()) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version compare = (Version)o;
        if (compare.getID() == null) {
            return false;
        }
        return compare.getID().equals(this.id);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{id='" + this.id + "', time=" + this.time + ", release=" + this.releaseTime + ", type=" + (Object)((Object)this.type) + ", class=" + this.mainClass + ", minimumVersion=" + this.minimumLauncherVersion + ", assets='" + this.assets + "', source=" + this.source + ", list=" + this.list + ", libraries=" + this.libraries + "}";
    }

    public File getFile(File base) {
        return new File(base, "versions/" + this.getID() + "/" + this.getID() + ".jar");
    }

    public boolean appliesToCurrentEnvironment() {
        if (this.rules == null) {
            return true;
        }
        for (Rule rule : this.rules) {
            Rule.Action action = rule.getAppliedAction();
            if (action != Rule.Action.DISALLOW) continue;
            return false;
        }
        return true;
    }

    public Collection<Library> getRelevantLibraries() {
        ArrayList<Library> result = new ArrayList<Library>();
        for (Library library : this.libraries) {
            if (!library.appliesToCurrentEnvironment()) continue;
            result.add(library);
        }
        return result;
    }

    public Collection<File> getClassPath(OS os, File base) {
        Collection<Library> libraries = this.getRelevantLibraries();
        ArrayList<File> result = new ArrayList<File>();
        for (Library library : libraries) {
            if (library.getNatives() != null) continue;
            result.add(new File(base, "libraries/" + library.getArtifactPath()));
        }
        result.add(new File(base, "versions/" + this.getID() + "/" + this.getID() + ".jar"));
        return result;
    }

    public Collection<File> getClassPath(File base) {
        return this.getClassPath(OS.CURRENT, base);
    }

    public Collection<String> getNatives(OS os) {
        Collection<Library> libraries = this.getRelevantLibraries();
        ArrayList<String> result = new ArrayList<String>();
        for (Library library : libraries) {
            Map<OS, String> natives = library.getNatives();
            if (natives == null || !natives.containsKey((Object)os)) continue;
            result.add("libraries/" + library.getArtifactPath(natives.get((Object)os)));
        }
        return result;
    }

    public Collection<String> getNatives() {
        return this.getNatives(OS.CURRENT);
    }

    public Set<String> getRequiredFiles(OS os) {
        HashSet<String> neededFiles = new HashSet<String>();
        for (Library library : this.getRelevantLibraries()) {
            if (library.getNatives() != null) {
                String natives = library.getNatives().get((Object)os);
                if (natives == null) continue;
                neededFiles.add("libraries/" + library.getArtifactPath(natives));
                continue;
            }
            neededFiles.add("libraries/" + library.getArtifactPath());
        }
        return neededFiles;
    }

    public Collection<String> getExtractFiles(OS os) {
        Collection<Library> libraries = this.getRelevantLibraries();
        ArrayList<String> result = new ArrayList<String>();
        for (Library library : libraries) {
            Map<OS, String> natives = library.getNatives();
            if (natives == null || !natives.containsKey((Object)os)) continue;
            result.add("libraries/" + library.getArtifactPath(natives.get((Object)os)));
        }
        return result;
    }

    public CompleteVersion resolve(VersionManager vm) throws IOException {
        return this.resolve(vm, false);
    }

    public CompleteVersion resolve(VersionManager vm, boolean useLatest) throws IOException {
        return this.resolve(vm, useLatest, new ArrayList<String>());
    }

    protected CompleteVersion resolve(VersionManager vm, boolean useLatest, List<String> inheristance) throws IOException {
        CompleteVersion result;
        if (vm == null) {
            throw new NullPointerException("version manager");
        }
        if (this.inheritsFrom == null) {
            return this;
        }
        this.log("Resolving...");
        if (inheristance.contains(this.id)) {
            throw new IllegalArgumentException(this.id + " should be already resolved.");
        }
        inheristance.add(this.id);
        this.log("Inherits from", this.inheritsFrom);
        VersionSyncInfo parentSyncInfo = vm.getVersionSyncInfo(this.inheritsFrom);
        try {
            if (parentSyncInfo == null) {
                return null;
            }
            result = (CompleteVersion)parentSyncInfo.getCompleteVersion(useLatest).resolve(vm, useLatest, inheristance).clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return this.partCopyInto(result);
    }

    private CompleteVersion partCopyInto(CompleteVersion result) {
        ArrayList<Library> newLibraries;
        result.id = this.id;
        if (this.jar != null) {
            result.jar = this.jar;
        }
        result.inheritsFrom = null;
        if (this.time.getTime() != 0L) {
            result.time = this.time;
        }
        if (this.type != ReleaseType.UNKNOWN) {
            result.type = this.type;
        }
        if (this.jvmArguments != null) {
            result.jvmArguments = this.jvmArguments;
        }
        if (this.minecraftArguments != null) {
            result.minecraftArguments = this.minecraftArguments;
        }
        if (Objects.nonNull(result.arguments) || Objects.nonNull(this.arguments)) {
            HashMap<ArgumentType, List<Argument>> args = new HashMap<ArgumentType, List<Argument>>();
            args.put(ArgumentType.GAME, new ArrayList());
            args.put(ArgumentType.JVM, new ArrayList());
            if (Objects.nonNull(result.arguments)) {
                result.arguments.forEach((key, value) -> ((List)args.get(key)).addAll(value));
            }
            if (Objects.nonNull(this.arguments)) {
                this.arguments.forEach((key, value) -> ((List)args.get(key)).addAll(value));
            }
            result.arguments = args;
        }
        if (this.mainClass != null) {
            result.mainClass = this.mainClass;
        }
        if (this.libraries != null) {
            newLibraries = new ArrayList<Library>(this.libraries);
            if (result.libraries != null) {
                newLibraries.addAll(result.libraries);
            }
            result.libraries = newLibraries;
        }
        if (this.rules != null) {
            if (result.rules != null) {
                result.rules.addAll(this.rules);
            } else {
                ArrayList rulesCopy = new ArrayList(this.rules.size());
                Collections.copy(rulesCopy, this.rules);
                result.rules = this.rules;
            }
        }
        if (this.deleteEntries != null) {
            if (result.deleteEntries != null) {
                result.deleteEntries.addAll(this.deleteEntries);
            } else {
                result.deleteEntries = new ArrayList<String>(this.deleteEntries);
            }
        }
        if (this.minimumLauncherVersion != 0) {
            result.minimumLauncherVersion = this.minimumLauncherVersion;
        }
        if (this.tlauncherVersion != 0) {
            result.tlauncherVersion = this.tlauncherVersion;
        }
        if (this.assets != null && !this.assets.equals("legacy")) {
            result.assets = this.assets;
        }
        if (this.source != null) {
            result.source = this.source;
        }
        result.setSkinVersion(this.skinVersion);
        if (this.url != null) {
            result.setUrl(this.getUrl());
        }
        if (this.assetIndex != null) {
            result.setAssetIndex(this.getAssetIndex());
        }
        if (this.downloads != null) {
            result.setDownloads(this.getDownloads());
        }
        if (this.modsLibraries != null) {
            newLibraries = new ArrayList<Library>(this.modsLibraries);
            if (result.modsLibraries != null) {
                newLibraries.addAll(result.modsLibraries);
            }
            result.modsLibraries = newLibraries;
        }
        if (this.modpack != null) {
            ModpackDTO newModpack = new ModpackDTO();
            this.modpack.copy(newModpack);
            result.modpack = newModpack;
        }
        if (result.releaseTime == null) {
            result.releaseTime = this.releaseTime;
        }
        if (Objects.nonNull(this.getAdditionalFiles())) {
            result.setAdditionalFiles(new ArrayList<MetadataDTO>(this.getAdditionalFiles()));
        }
        result.list = this.list;
        return result;
    }

    public CompleteVersion fullCopy(CompleteVersion c) {
        this.partCopyInto(c);
        c.inheritsFrom = this.inheritsFrom;
        return c;
    }

    public Map<ArgumentType, List<Argument>> getArguments() {
        return this.arguments;
    }

    private void log(Object ... o) {
        U.log("[Version:" + this.id + "]", o);
    }

    public ModpackDTO getModpack() {
        return this.modpack;
    }

    public void setModpackDTO(ModpackDTO modpack) {
        this.modpack = modpack;
    }

    public List<MetadataDTO> getAdditionalFiles() {
        return this.additionalFiles;
    }

    public void setAdditionalFiles(List<MetadataDTO> additionalFiles) {
        this.additionalFiles = additionalFiles;
    }

    public static class CompleteVersionSerializer
    implements JsonSerializer<CompleteVersion>,
    JsonDeserializer<CompleteVersion> {
        private final Gson defaultContext;

        public CompleteVersionSerializer() {
            GsonBuilder builder = new GsonBuilder();
            builder.registerTypeAdapterFactory(new LowerCaseEnumTypeAdapterFactory());
            builder.registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter());
            builder.registerTypeAdapter((Type)((Object)Library.class), new Library.LibrarySerializer());
            builder.registerTypeAdapter((Type)((Object)Argument.class), new Argument.Serializer());
            builder.registerTypeAdapter((Type)((Object)ModpackDTO.class), new ModpackDTOTypeAdapter());
            builder.registerTypeAdapter((Type)((Object)Repo.class), new RepoTypeAdapter());
            builder.enableComplexMapKeySerialization();
            builder.disableHtmlEscaping();
            builder.setPrettyPrinting();
            this.defaultContext = builder.create();
        }

        @Override
        public CompleteVersion deserialize(JsonElement elem, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonElement unnecessaryEntries;
            JsonObject object = elem.getAsJsonObject();
            JsonElement originalId = object.get("original_id");
            if (originalId != null && originalId.isJsonPrimitive()) {
                String jar = originalId.getAsString();
                object.remove("original_id");
                object.addProperty("jar", jar);
            }
            if (Objects.nonNull(object.get("inheritsFrom")) && Objects.isNull(object.get("jar"))) {
                object.addProperty("jar", object.get("inheritsFrom").getAsString());
            }
            if ((unnecessaryEntries = object.get("unnecessaryEntries")) != null && unnecessaryEntries.isJsonArray()) {
                object.remove("unnecessaryEntries");
                object.add("deleteEntries", unnecessaryEntries);
            }
            CompleteVersion version = this.defaultContext.fromJson(elem, CompleteVersion.class);
            if (version.id == null) {
                throw new JsonParseException("Version ID is NULL!");
            }
            if (version.type == null) {
                version.type = ReleaseType.UNKNOWN;
            }
            if (version.source == null) {
                version.source = ClientInstanceRepo.LOCAL_VERSION_REPO;
            }
            if (version.time == null) {
                version.time = new Date(0L);
            }
            if (version.assets == null) {
                version.assets = "legacy";
            }
            return version;
        }

        @Override
        public JsonElement serialize(CompleteVersion version0, Type type, JsonSerializationContext context) {
            CompleteVersion version;
            try {
                version = (CompleteVersion)version0.clone();
            }
            catch (CloneNotSupportedException e) {
                U.log("Cloning of CompleteVersion is not supported O_o", e);
                return this.defaultContext.toJsonTree(version0, type);
            }
            version.list = null;
            JsonObject object = (JsonObject)this.defaultContext.toJsonTree(version, type);
            JsonElement jar = object.get("jar");
            if (jar == null) {
                object.remove("downloadJarLibraries");
            }
            return object;
        }
    }

    public static class AssetsMetadata {
        private String id;
        private int totalSize;
        protected String name;
        protected long size;
        protected String path;
        protected String url;

        public String getId() {
            return this.id;
        }

        public int getTotalSize() {
            return this.totalSize;
        }

        public String getName() {
            return this.name;
        }

        public long getSize() {
            return this.size;
        }

        public String getPath() {
            return this.path;
        }

        public String getUrl() {
            return this.url;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setTotalSize(int totalSize) {
            this.totalSize = totalSize;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssetsMetadata)) {
                return false;
            }
            AssetsMetadata other = (AssetsMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            if (this.getTotalSize() != other.getTotalSize()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            if (this.getSize() != other.getSize()) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AssetsMetadata;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            result = result * 59 + this.getTotalSize();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            long $size = this.getSize();
            result = result * 59 + (int)($size >>> 32 ^ $size);
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        public String toString() {
            return "CompleteVersion.AssetsMetadata(id=" + this.getId() + ", totalSize=" + this.getTotalSize() + ", name=" + this.getName() + ", size=" + this.getSize() + ", path=" + this.getPath() + ", url=" + this.getUrl() + ")";
        }
    }
}

