/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.modpack.domain.client.share;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.MapDTO;
import org.tlauncher.modpack.domain.client.ModDTO;
import org.tlauncher.modpack.domain.client.ModpackDTO;
import org.tlauncher.modpack.domain.client.ResourcePackDTO;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum GameType {
    MAP,
    MOD,
    MODPACK,
    RESOURCEPACK,
    NOT_MODPACK;


    @JsonValue
    public String toString() {
        return this.name().toLowerCase();
    }

    @JsonCreator
    public static GameType create(String value) {
        return GameType.valueOf(value.toUpperCase());
    }

    public static Class<? extends GameEntityDTO> createDTO(GameType type) {
        switch (type) {
            case MAP: {
                return MapDTO.class;
            }
            case MOD: {
                return ModDTO.class;
            }
            case RESOURCEPACK: {
                return ResourcePackDTO.class;
            }
            case MODPACK: {
                return ModpackDTO.class;
            }
        }
        throw new NullPointerException();
    }

    public static GameType create(Class<? extends GameEntityDTO> c) {
        return GameType.create(c.getSimpleName().replaceAll("DTO", ""));
    }

    public static List<GameType> getSubEntities() {
        return new ArrayList<GameType>(){
            {
                this.add(MAP);
                this.add(MOD);
                this.add(RESOURCEPACK);
            }
        };
    }
}

