/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.modpack.domain.client.version;

import java.util.ArrayList;
import java.util.List;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.MapDTO;
import org.tlauncher.modpack.domain.client.ModDTO;
import org.tlauncher.modpack.domain.client.ModpackDTO;
import org.tlauncher.modpack.domain.client.ResourcePackDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.version.MetadataDTO;
import org.tlauncher.modpack.domain.client.version.VersionDTO;

public class ModpackVersionDTO
extends VersionDTO {
    private List<ModDTO> mods = new ArrayList<ModDTO>();
    private List<ResourcePackDTO> resourcePacks = new ArrayList<ResourcePackDTO>();
    private List<MapDTO> maps = new ArrayList<MapDTO>();
    private MetadataDTO additionalFile;
    private String forgeVersion;
    private String gameVersion;

    public List<? extends GameEntityDTO> getByType(GameType type) {
        List<Object> list = new ArrayList();
        switch (type) {
            case MOD: {
                list = this.mods;
                break;
            }
            case MAP: {
                list = this.maps;
                break;
            }
            case RESOURCEPACK: {
                list = this.resourcePacks;
            }
        }
        return list;
    }

    public ModpackVersionDTO copy(ModpackVersionDTO version) {
        version.setId(this.getId());
        version.setAdditionalFile(this.additionalFile);
        version.setForgeVersion(this.forgeVersion);
        version.setGameVersions(this.getGameVersions());
        version.setMaps(new ModpackDTO.CheckNullList<MapDTO>(this.maps));
        version.setMods(new ModpackDTO.CheckNullList<ModDTO>(this.mods));
        version.setName(this.getName());
        version.setResourcePacks(new ModpackDTO.CheckNullList<ResourcePackDTO>(this.resourcePacks));
        version.setType(this.getType());
        version.setUpdateDate(this.getUpdateDate());
        version.setJavaVersions(this.getJavaVersions());
        version.setGameVersion(this.getGameVersion());
        return version;
    }

    public List<ModDTO> getMods() {
        return this.mods;
    }

    public List<ResourcePackDTO> getResourcePacks() {
        return this.resourcePacks;
    }

    public List<MapDTO> getMaps() {
        return this.maps;
    }

    public MetadataDTO getAdditionalFile() {
        return this.additionalFile;
    }

    public String getForgeVersion() {
        return this.forgeVersion;
    }

    public String getGameVersion() {
        return this.gameVersion;
    }

    public void setMods(List<ModDTO> mods) {
        this.mods = mods;
    }

    public void setResourcePacks(List<ResourcePackDTO> resourcePacks) {
        this.resourcePacks = resourcePacks;
    }

    public void setMaps(List<MapDTO> maps) {
        this.maps = maps;
    }

    public void setAdditionalFile(MetadataDTO additionalFile) {
        this.additionalFile = additionalFile;
    }

    public void setForgeVersion(String forgeVersion) {
        this.forgeVersion = forgeVersion;
    }

    public void setGameVersion(String gameVersion) {
        this.gameVersion = gameVersion;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModpackVersionDTO)) {
            return false;
        }
        ModpackVersionDTO other = (ModpackVersionDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ModDTO> this$mods = this.getMods();
        List<ModDTO> other$mods = other.getMods();
        if (this$mods == null ? other$mods != null : !((Object)this$mods).equals(other$mods)) {
            return false;
        }
        List<ResourcePackDTO> this$resourcePacks = this.getResourcePacks();
        List<ResourcePackDTO> other$resourcePacks = other.getResourcePacks();
        if (this$resourcePacks == null ? other$resourcePacks != null : !((Object)this$resourcePacks).equals(other$resourcePacks)) {
            return false;
        }
        List<MapDTO> this$maps = this.getMaps();
        List<MapDTO> other$maps = other.getMaps();
        if (this$maps == null ? other$maps != null : !((Object)this$maps).equals(other$maps)) {
            return false;
        }
        MetadataDTO this$additionalFile = this.getAdditionalFile();
        MetadataDTO other$additionalFile = other.getAdditionalFile();
        if (this$additionalFile == null ? other$additionalFile != null : !((Object)this$additionalFile).equals(other$additionalFile)) {
            return false;
        }
        String this$forgeVersion = this.getForgeVersion();
        String other$forgeVersion = other.getForgeVersion();
        if (this$forgeVersion == null ? other$forgeVersion != null : !this$forgeVersion.equals(other$forgeVersion)) {
            return false;
        }
        String this$gameVersion = this.getGameVersion();
        String other$gameVersion = other.getGameVersion();
        return !(this$gameVersion == null ? other$gameVersion != null : !this$gameVersion.equals(other$gameVersion));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ModpackVersionDTO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ModDTO> $mods = this.getMods();
        result = result * 59 + ($mods == null ? 43 : ((Object)$mods).hashCode());
        List<ResourcePackDTO> $resourcePacks = this.getResourcePacks();
        result = result * 59 + ($resourcePacks == null ? 43 : ((Object)$resourcePacks).hashCode());
        List<MapDTO> $maps = this.getMaps();
        result = result * 59 + ($maps == null ? 43 : ((Object)$maps).hashCode());
        MetadataDTO $additionalFile = this.getAdditionalFile();
        result = result * 59 + ($additionalFile == null ? 43 : ((Object)$additionalFile).hashCode());
        String $forgeVersion = this.getForgeVersion();
        result = result * 59 + ($forgeVersion == null ? 43 : $forgeVersion.hashCode());
        String $gameVersion = this.getGameVersion();
        result = result * 59 + ($gameVersion == null ? 43 : $gameVersion.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ModpackVersionDTO(mods=" + this.getMods() + ", resourcePacks=" + this.getResourcePacks() + ", maps=" + this.getMaps() + ", additionalFile=" + this.getAdditionalFile() + ", forgeVersion=" + this.getForgeVersion() + ", gameVersion=" + this.getGameVersion() + ")";
    }
}

