/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.downloader.mods;

import java.io.File;
import java.nio.file.Path;
import org.apache.commons.io.FilenameUtils;
import org.tlauncher.modpack.domain.client.version.MetadataDTO;
import org.tlauncher.tlauncher.downloader.RetryDownloadException;
import org.tlauncher.tlauncher.downloader.mods.GameEntityDownloader;
import org.tlauncher.tlauncher.repository.ClientInstanceRepo;
import org.tlauncher.util.FileUtil;

public class MapDownloader
extends GameEntityDownloader {
    public MapDownloader(boolean forceDownload, MetadataDTO metadata, Path folder) {
        super(ClientInstanceRepo.createModpackRepo(), forceDownload, metadata.getUrl(), new File(folder.toFile(), "saves/" + FilenameUtils.getName(metadata.getPath())));
        this.setMetadata(metadata);
    }

    @Override
    protected void onComplete() throws RetryDownloadException {
        super.onComplete();
        try {
            File f = this.getDestination();
            FileUtil.unzipUniversal(f, f.getParentFile());
            FileUtil.deleteFile(f);
        }
        catch (Throwable t) {
            throw new RetryDownloadException("cannot unpack archive", t);
        }
    }
}

