/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.entity;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.launcher.versions.CompleteVersion;
import org.tlauncher.tlauncher.entity.AdditionalModLib;
import org.tlauncher.tlauncher.entity.TLauncherLib;

public class TLauncherVersionChanger {
    private Set<String> tlauncherSkinCapeVersion;
    private double version;
    private List<TLauncherLib> libraries;
    private List<AdditionalModLib> additionalMods;

    public List<AdditionalModLib> getAddedMods(CompleteVersion v, boolean customTexture) {
        return this.additionalMods.stream().filter(l -> customTexture || !l.isActiveCustomUserTexture()).filter(l -> l.getSupports().contains(v.getID())).collect(Collectors.toList());
    }

    public Set<String> getTlauncherSkinCapeVersion() {
        return this.tlauncherSkinCapeVersion;
    }

    public double getVersion() {
        return this.version;
    }

    public List<TLauncherLib> getLibraries() {
        return this.libraries;
    }

    public List<AdditionalModLib> getAdditionalMods() {
        return this.additionalMods;
    }

    public void setTlauncherSkinCapeVersion(Set<String> tlauncherSkinCapeVersion) {
        this.tlauncherSkinCapeVersion = tlauncherSkinCapeVersion;
    }

    public void setVersion(double version) {
        this.version = version;
    }

    public void setLibraries(List<TLauncherLib> libraries) {
        this.libraries = libraries;
    }

    public void setAdditionalMods(List<AdditionalModLib> additionalMods) {
        this.additionalMods = additionalMods;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TLauncherVersionChanger)) {
            return false;
        }
        TLauncherVersionChanger other = (TLauncherVersionChanger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$tlauncherSkinCapeVersion = this.getTlauncherSkinCapeVersion();
        Set<String> other$tlauncherSkinCapeVersion = other.getTlauncherSkinCapeVersion();
        if (this$tlauncherSkinCapeVersion == null ? other$tlauncherSkinCapeVersion != null : !((Object)this$tlauncherSkinCapeVersion).equals(other$tlauncherSkinCapeVersion)) {
            return false;
        }
        if (Double.compare(this.getVersion(), other.getVersion()) != 0) {
            return false;
        }
        List<TLauncherLib> this$libraries = this.getLibraries();
        List<TLauncherLib> other$libraries = other.getLibraries();
        if (this$libraries == null ? other$libraries != null : !((Object)this$libraries).equals(other$libraries)) {
            return false;
        }
        List<AdditionalModLib> this$additionalMods = this.getAdditionalMods();
        List<AdditionalModLib> other$additionalMods = other.getAdditionalMods();
        return !(this$additionalMods == null ? other$additionalMods != null : !((Object)this$additionalMods).equals(other$additionalMods));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TLauncherVersionChanger;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $tlauncherSkinCapeVersion = this.getTlauncherSkinCapeVersion();
        result = result * 59 + ($tlauncherSkinCapeVersion == null ? 43 : ((Object)$tlauncherSkinCapeVersion).hashCode());
        long $version = Double.doubleToLongBits(this.getVersion());
        result = result * 59 + (int)($version >>> 32 ^ $version);
        List<TLauncherLib> $libraries = this.getLibraries();
        result = result * 59 + ($libraries == null ? 43 : ((Object)$libraries).hashCode());
        List<AdditionalModLib> $additionalMods = this.getAdditionalMods();
        result = result * 59 + ($additionalMods == null ? 43 : ((Object)$additionalMods).hashCode());
        return result;
    }

    public String toString() {
        return "TLauncherVersionChanger(tlauncherSkinCapeVersion=" + this.getTlauncherSkinCapeVersion() + ", version=" + this.getVersion() + ", libraries=" + this.getLibraries() + ", additionalMods=" + this.getAdditionalMods() + ")";
    }
}

