/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.handlers;

import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.util.Reflect;
import org.tlauncher.util.TlauncherUtil;
import org.tlauncher.util.U;

public class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static ExceptionHandler instance;
    private static long gcLastCall;

    public static ExceptionHandler getInstance() {
        if (instance == null) {
            instance = new ExceptionHandler();
        }
        return instance;
    }

    private ExceptionHandler() {
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        OutOfMemoryError asOOM = Reflect.cast(e, OutOfMemoryError.class);
        if (asOOM != null && ExceptionHandler.reduceMemory(asOOM)) {
            return;
        }
        if (ExceptionHandler.scanTrace(e)) {
            try {
                Alert.showError("Exception in thread " + t.getName(), e);
            }
            catch (Exception w) {
                w.printStackTrace();
            }
        } else {
            U.log("Hidden exception in thread " + t.getName(), e);
        }
        if (e instanceof UnsatisfiedLinkError && e.getMessage().contains("jfxwebkit.dll")) {
            U.log("should use new jvm");
            TLauncher.getInstance().getConfiguration().set("not.work.jfxwebkit.dll", (Object)true);
        }
        TlauncherUtil.sendLog(e);
    }

    public static boolean reduceMemory(OutOfMemoryError e) {
        if (e == null) {
            return false;
        }
        U.log("OutOfMemory error has occurred, solving...");
        long currentTime = System.currentTimeMillis();
        long diff = Math.abs(currentTime - gcLastCall);
        if (diff > 5000L) {
            gcLastCall = currentTime;
            U.gc();
            return true;
        }
        U.log("GC is unable to reduce memory usage");
        return false;
    }

    private static boolean scanTrace(Throwable e) {
        StackTraceElement[] elements;
        for (StackTraceElement element : elements = e.getStackTrace()) {
            if (!element.getClassName().startsWith("org.tlauncher")) continue;
            return true;
        }
        return false;
    }
}

