/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.minecraft.auth;

import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.tlauncher.tlauncher.minecraft.auth.GameProfile;
import org.tlauncher.tlauncher.minecraft.auth.UUIDTypeAdapter;
import org.tlauncher.tlauncher.minecraft.auth.User;
import org.tlauncher.tlauncher.minecraft.auth.UserProperty;
import org.tlauncher.util.Reflect;

public class Account {
    private String username;
    private String userID;
    private String displayName;
    private String password;
    private String accessToken;
    private String uuid;
    private List<Map<String, String>> userProperties;
    private AccountType type = AccountType.FREE;
    @Expose
    private boolean premiumAccount;
    private GameProfile[] profiles;
    private GameProfile selectedProfile;
    private User user;

    public Account() {
    }

    public Account(String username) {
        this();
        this.setUsername(username);
    }

    public Account(Map<String, Object> map) {
        this();
        this.fillFromMap(map);
    }

    public String getUsername() {
        return this.username;
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getDisplayName() {
        return this.displayName == null ? this.username : this.displayName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        if ("null".equals(accessToken)) {
            accessToken = null;
        }
        this.accessToken = accessToken;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public GameProfile[] getProfiles() {
        return this.profiles;
    }

    public void setProfiles(GameProfile[] p) {
        this.profiles = p;
    }

    public GameProfile getProfile() {
        return this.selectedProfile != null ? this.selectedProfile : GameProfile.DEFAULT_PROFILE;
    }

    public void setProfile(GameProfile p) {
        this.selectedProfile = p;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Map<String, List<String>> getProperties() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ArrayList<UserProperty> list = new ArrayList<UserProperty>();
        if (this.userProperties != null) {
            for (Map<String, String> properties : this.userProperties) {
                list.add(new UserProperty(properties.get("name"), properties.get("value")));
            }
        }
        if (this.user != null && this.user.getProperties() != null) {
            for (Map<String, String> properties : this.user.getProperties()) {
                list.add(new UserProperty(properties.get("name"), properties.get("value")));
            }
        }
        for (UserProperty property : list) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(property.getValue());
            map.put(property.getKey(), values);
        }
        return map;
    }

    void setProperties(List<Map<String, String>> properties) {
        this.userProperties = properties;
    }

    public AccountType getType() {
        return this.type;
    }

    public void setType(AccountType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = type;
    }

    public boolean isFree() {
        return this.type.equals((Object)AccountType.FREE);
    }

    Map<String, Object> createMap() {
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("username", this.username);
        r.put("userid", this.userID);
        r.put("uuid", UUIDTypeAdapter.toUUID(this.uuid));
        r.put("displayName", this.displayName);
        if (!this.isFree()) {
            r.put("type", (Object)this.type);
            r.put("accessToken", this.accessToken);
        }
        if (this.userProperties != null) {
            r.put("userProperties", this.userProperties);
        }
        return r;
    }

    void fillFromMap(Map<String, Object> map) {
        if (map.containsKey("username")) {
            this.setUsername(map.get("username").toString());
        }
        this.setUserID(map.containsKey("userid") ? map.get("userid").toString() : this.getUsername());
        this.setDisplayName(map.containsKey("displayName") ? map.get("displayName").toString() : this.getUsername());
        this.setProperties(map.containsKey("userProperties") ? (List)map.get("userProperties") : null);
        this.setUUID(map.containsKey("uuid") ? UUIDTypeAdapter.toUUID(map.get("uuid").toString()) : null);
        boolean hasAccessToken = map.containsKey("accessToken");
        if (hasAccessToken) {
            this.setAccessToken(map.get("accessToken").toString());
        }
        this.setType(map.containsKey("type") ? Reflect.parseEnum(AccountType.class, map.get("type").toString()) : (hasAccessToken ? AccountType.MOJANG : AccountType.FREE));
    }

    public void complete(Account acc) {
        if (acc == null) {
            throw new NullPointerException();
        }
        boolean sameName = acc.username.equals(this.username);
        this.username = acc.username;
        this.type = acc.type;
        if (acc.userID != null) {
            this.userID = acc.userID;
        }
        if (acc.displayName != null) {
            this.displayName = acc.displayName;
        }
        if (acc.password != null) {
            this.password = acc.password;
        }
        if (!sameName) {
            this.accessToken = null;
        }
    }

    public boolean equals(Account acc) {
        if (acc == null) {
            return false;
        }
        if (this.username == null) {
            return acc.username == null;
        }
        return this.username.equals(acc.username) && this.type.equals((Object)acc.type) && (this.password == null || this.password.equals(acc.password));
    }

    public String toString() {
        return this.toDebugString();
    }

    public String toDebugString() {
        Map<String, Object> map = this.createMap();
        if (map.containsKey("accessToken")) {
            map.remove("accessToken");
            map.put("accessToken", "(not null)");
        }
        return "Account" + map;
    }

    public static Account randomAccount() {
        return new Account("random" + new Random().nextLong());
    }

    public boolean isPremiumAccount() {
        return this.premiumAccount;
    }

    public void setPremiumAccount(boolean premiumAccount) {
        this.premiumAccount = premiumAccount;
    }

    public static enum AccountType {
        TLAUNCHER,
        MOJANG,
        FREE,
        SPECIAL;

    }
}

