/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.minecraft.crash;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tlauncher.tlauncher.minecraft.crash.Crash;
import org.tlauncher.tlauncher.minecraft.crash.CrashSignatureContainer;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftLauncher;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.U;

public class CrashDescriptor {
    private static CrashSignatureContainer container;
    public static final int goodExitCode = 0;
    private static final String loggerPrefix = "[Crash]";
    private final MinecraftLauncher launcher;

    public CrashDescriptor(MinecraftLauncher launcher) {
        if (launcher == null) {
            throw new NullPointerException();
        }
        this.launcher = launcher;
    }

    public Crash scan() {
        int exitCode = this.launcher.getExitCode();
        if (exitCode == 0) {
            return null;
        }
        Crash crash = new Crash();
        Pattern filePattern = container.getPattern("crash");
        String version = this.launcher.getVersionName();
        Scanner scanner = new Scanner(this.launcher.getOutput());
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (filePattern.matcher(line).matches()) {
                Matcher fileMatcher = filePattern.matcher(line);
                if (!fileMatcher.matches() || fileMatcher.groupCount() != 1) continue;
                crash.setFile(fileMatcher.group(1));
                this.log("Found crash report file:", crash.getFile());
                continue;
            }
            for (CrashSignatureContainer.CrashSignature signature : container.getSignatures()) {
                if (signature.hasVersion() && !signature.getVersion().matcher(version).matches() || signature.getExitCode() != 0 && signature.getExitCode() != exitCode || signature.hasPattern() && !signature.getPattern().matcher(line).matches()) continue;
                if (signature.isFake()) {
                    this.log("Minecraft closed with an illegal exit code not due to error. Scanning has been cancelled");
                    this.log("Fake signature:", signature.getName());
                    scanner.close();
                    return null;
                }
                if (crash.hasSignature(signature)) continue;
                this.log("Signature \"" + signature.getName() + "\" matches!");
                crash.addSignature(signature);
            }
        }
        scanner.close();
        if (crash.isRecognized()) {
            this.log("Crash has been recognized!");
        }
        return crash;
    }

    void log(Object ... w) {
        this.launcher.log(loggerPrefix, w);
        U.log(loggerPrefix, w);
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter((Type)((Object)CrashSignatureContainer.class), new CrashSignatureContainer.CrashSignatureContainerDeserializer());
        Gson gson = builder.create();
        try {
            container = gson.fromJson(FileUtil.getResource(TLauncher.class.getResource("/signatures.json")), CrashSignatureContainer.class);
        }
        catch (Exception e) {
            U.log("Cannot parse crash signatures!", e);
            container = new CrashSignatureContainer();
        }
    }
}

