/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.minecraft.launcher.assitent;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import net.minecraft.launcher.Http;
import org.tlauncher.modpack.domain.client.version.MetadataDTO;
import org.tlauncher.tlauncher.downloader.Downloadable;
import org.tlauncher.tlauncher.downloader.DownloadableContainer;
import org.tlauncher.tlauncher.downloader.Downloader;
import org.tlauncher.tlauncher.downloader.RetryDownloadException;
import org.tlauncher.tlauncher.downloader.mods.GameEntityDownloader;
import org.tlauncher.tlauncher.downloader.mods.GameEntityHandler;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftException;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftLauncher;
import org.tlauncher.tlauncher.minecraft.launcher.assitent.MinecraftLauncherAssistantWrapper;
import org.tlauncher.tlauncher.repository.ClientInstanceRepo;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.MinecraftUtil;
import org.tlauncher.util.U;

public class AdditionalFileAssistance
extends MinecraftLauncherAssistantWrapper {
    @Inject
    public AdditionalFileAssistance(@Assisted MinecraftLauncher launcher) {
        super(launcher);
    }

    @Override
    public void collectResources(Downloader d, boolean force) throws MinecraftException {
        List<MetadataDTO> list = this.launcher.getVersion().getAdditionalFiles();
        if (Objects.isNull(list)) {
            return;
        }
        DownloadableContainer c = new DownloadableContainer();
        try {
            for (MetadataDTO m : list) {
                if (!this.notExistsOrCorrect(m) || this.copyFromLocalRepo(m)) continue;
                c.add(new AdditionalFileDownloader(m));
            }
        }
        catch (IOException e) {
            U.log(e);
            throw new MinecraftException(e.getMessage(), "download-jar", e);
        }
        if (!c.getList().isEmpty()) {
            c.addHandler(new GameEntityHandler(){

                @Override
                public void onComplete(DownloadableContainer c, Downloadable d) throws RetryDownloadException {
                    super.onComplete(c, d);
                    GameEntityDownloader g = (GameEntityDownloader)d;
                    try {
                        AdditionalFileAssistance.this.copyFromLocalRepo(g.getMetadata());
                    }
                    catch (IOException e) {
                        U.log(e);
                        throw new RetryDownloadException("problem with file", e);
                    }
                }
            });
            d.add(c);
        }
    }

    private boolean copyFromLocalRepo(MetadataDTO m) throws IOException {
        File source = new File(MinecraftUtil.getWorkingDirectory().getAbsolutePath(), new URL(m.getUrl()).getPath());
        File target = new File(MinecraftUtil.getWorkingDirectory(), m.getPath());
        if (m.getSha1().equalsIgnoreCase(FileUtil.getChecksum(source))) {
            if (source.equals(target)) {
                return true;
            }
            FileUtil.copyFile(source, target, true);
            return true;
        }
        return false;
    }

    private boolean notExistsOrCorrect(MetadataDTO m) {
        File target = new File(MinecraftUtil.getWorkingDirectory(), m.getPath());
        if (!target.exists()) {
            return true;
        }
        return !m.getSha1().equalsIgnoreCase(FileUtil.getChecksum(target));
    }

    private class AdditionalFileDownloader
    extends GameEntityDownloader {
        public AdditionalFileDownloader(MetadataDTO metadata) {
            super(ClientInstanceRepo.EMPTY_REPO, true, metadata.getUrl(), new File(MinecraftUtil.getWorkingDirectory().getAbsolutePath(), Http.constantURL(metadata.getUrl()).getPath()));
            this.setMetadata(metadata);
        }
    }
}

