/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.modpack;

import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.Version;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.GameEntityDependencyDTO;
import org.tlauncher.modpack.domain.client.ModDTO;
import org.tlauncher.modpack.domain.client.ModpackDTO;
import org.tlauncher.modpack.domain.client.share.DependencyType;
import org.tlauncher.modpack.domain.client.share.ForgeStringComparator;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.version.ModpackVersionDTO;
import org.tlauncher.modpack.domain.client.version.VersionDTO;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.util.FileUtil;

public class ModpackUtil {
    public static List<? extends VersionDTO> sortByDate(List<VersionDTO> versions) {
        ArrayList<VersionDTO> sortList = new ArrayList<VersionDTO>(versions);
        sortList.sort((o1, o2) -> o2.getUpdateDate().compareTo(o1.getUpdateDate()));
        return sortList;
    }

    public static Path getPathByVersion(Version version, String ... paths) {
        StringBuilder builder = new StringBuilder();
        builder.append("versions").append("/").append(version.getID());
        for (String line : paths) {
            builder.append("/").append(line);
        }
        return FileUtil.getRelative(builder.toString());
    }

    public static Path getPathByVersion(CompleteVersion version) {
        return ModpackUtil.getPathByVersion(version, "");
    }

    public static String getLatestGameVersion(Set<String> c) {
        if (c.isEmpty()) {
            return null;
        }
        ArrayList list = Lists.newArrayList(c);
        list.sort(new ForgeStringComparator());
        return (String)list.get(0);
    }

    public static void extractIncompatible(GameEntityDTO en, Set<Long> set) {
        if (en.getDependencies() == null) {
            return;
        }
        for (GameEntityDependencyDTO d : en.getDependencies()) {
            if (d.getDependencyType() != DependencyType.INCOMPATIBLE) continue;
            set.add(d.getId());
        }
    }

    public static Set<Long> getAllModpackIds(ModpackDTO m) {
        HashSet<Long> set = new HashSet<Long>();
        if (m.getId() != null) {
            set.add(m.getId());
        }
        for (GameType t : GameType.getSubEntities()) {
            for (GameEntityDTO gameEntityDTO : ((ModpackVersionDTO)m.getVersion()).getByType(t)) {
                if (gameEntityDTO.getId() == null) continue;
                set.add(gameEntityDTO.getId());
            }
        }
        return set;
    }

    public static String getPictureURL(Integer id, String type) {
        return TLauncher.getInnerSettings().getArray("modpack.repo")[new Random().nextInt(2)] + "/pictures/" + id + type + ".png";
    }

    public static StringBuilder buildMessage(List<GameEntityDTO> list) {
        StringBuilder b = new StringBuilder();
        for (GameEntityDTO dependency : list) {
            b.append(dependency.getName()).append("(").append(Localizable.get("modpack.button." + (Object)((Object)GameType.create(dependency.getClass())))).append(")").append(" ");
        }
        return b;
    }

    public static Path getPath(CompleteVersion v, GameType type) {
        switch (type) {
            case RESOURCEPACK: {
                return ModpackUtil.getPathByVersion(v, "resourcepacks");
            }
            case MOD: {
                return ModpackUtil.getPathByVersion(v, "mods");
            }
            case MAP: {
                return ModpackUtil.getPathByVersion(v, "saves");
            }
        }
        throw new RuntimeException("not proper type");
    }

    public static boolean useSkinMod(CompleteVersion version) {
        for (ModDTO m : ((ModpackVersionDTO)version.getModpack().getVersion()).getMods()) {
            if (!ModDTO.SKIN_MODS.contains(m.getId())) continue;
            return true;
        }
        return false;
    }
}

