/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.accounts;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.tlauncher.tlauncher.managers.ProfileManager;
import org.tlauncher.tlauncher.managers.ProfileManagerListener;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.minecraft.auth.AuthenticatorDatabase;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.block.Unblockable;
import org.tlauncher.tlauncher.ui.center.CenterPanel;
import org.tlauncher.tlauncher.ui.loc.ImageUdaterButton;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.tlauncher.ui.scenes.AccountEditorScene;
import org.tlauncher.tlauncher.ui.swing.AccountCellRenderer;
import org.tlauncher.tlauncher.ui.swing.ImageButton;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedButton;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;
import org.tlauncher.tlauncher.ui.swing.scroll.AccountScrollBarUI;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.swing.FontTL;

public class AccountList
extends CenterPanel {
    private static final long serialVersionUID = 3280495266368287215L;
    private final AccountEditorScene scene;
    public final DefaultListModel<Account> model;
    public final JList<Account> list;
    public final UpdaterButton add;
    public final UpdaterButton remove;
    public static final Dimension SIZE = new Dimension(211, 171);

    public AccountList(AccountEditorScene sc) {
        super(noInsets);
        this.setPreferredSize(SIZE);
        this.scene = sc;
        ExtendedPanel panel = new ExtendedPanel(new BorderLayout(0, 0));
        LocalizableLabel label = new LocalizableLabel("account.list");
        SwingUtil.changeFontFamily(label, FontTL.ROBOTO_BOLD);
        label.setFont(label.getFont().deriveFont(14));
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 13, 0));
        label.setHorizontalAlignment(2);
        label.setVerticalAlignment(1);
        this.model = new DefaultListModel();
        this.list = new JList<Account>(this.model);
        this.list.setCellRenderer(new AccountCellRenderer(AccountCellRenderer.AccountCellType.EDITOR));
        this.list.setSelectionMode(0);
        this.list.setBackground(AccountEditorScene.BACKGROUND_ACCOUNT_COLOR);
        this.list.addListSelectionListener(e -> {
            Account account = this.list.getSelectedValue();
            this.scene.handler.refreshEditor(account);
        });
        JScrollPane scroll = new JScrollPane(this.list);
        scroll.getVerticalScrollBar().setUI(new AccountScrollBarUI());
        scroll.setBorder(null);
        scroll.setHorizontalScrollBarPolicy(31);
        scroll.setVerticalScrollBarPolicy(20);
        ExtendedPanel buttons = new ExtendedPanel();
        buttons.setLayout(new FlowLayout(0, 0, 0));
        buttons.setPreferredSize(new Dimension(AccountList.SIZE.width, 26));
        this.add = new UpdaterButton(ExtendedButton.ORRANGE_COLOR, "account.list.add");
        this.add.setFont(this.add.getFont().deriveFont(1, 16.0f));
        this.add.setForeground(Color.WHITE);
        this.add.setPreferredSize(new Dimension(100, 26));
        this.add.addActionListener(e -> {
            this.scene.handler.addAccount();
            this.defocus();
        });
        this.remove = new UpdaterButton(ImageUdaterButton.ORRANGE_COLOR, "account.list.remove");
        this.remove.setPreferredSize(new Dimension(100, 26));
        this.remove.setFont(this.remove.getFont().deriveFont(1, 16.0f));
        this.remove.setForeground(Color.WHITE);
        this.remove.addActionListener(e -> {
            this.scene.handler.removeAccount();
            this.defocus();
        });
        ((Container)buttons).add(this.add);
        ((Container)buttons).add(Box.createHorizontalStrut(11));
        ((Container)buttons).add(this.remove);
        panel.add("South", (Component)buttons);
        panel.add("Center", (Component)scroll);
        panel.add("North", (Component)label);
        this.add((Component)panel);
        ProfileManagerListener listener = new ProfileManagerListener(){

            @Override
            public void onProfilesRefreshed(ProfileManager pm) {
                AccountList.this.refreshFrom(pm.getAuthDatabase());
            }

            @Override
            public void onProfileManagerChanged(ProfileManager pm) {
                AccountList.this.refreshFrom(pm.getAuthDatabase());
            }

            @Override
            public void onAccountsRefreshed(AuthenticatorDatabase db) {
                AccountList.this.refreshFrom(db);
            }
        };
        TLauncher.getInstance().getProfileManager().addListener(listener);
    }

    public void refreshFrom(AuthenticatorDatabase db) {
        this.model.clear();
        for (Account account : db.getAccounts()) {
            this.model.addElement(account);
        }
        if (this.model.isEmpty()) {
            this.scene.handler.notifyEmpty();
        }
    }

    class UnblockableImageButton
    extends ImageButton
    implements Unblockable {
        public UnblockableImageButton(String imagepath) {
            super(imagepath);
        }
    }
}

