/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.alert;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.tlauncher.tlauncher.ui.alert.AlertPanel;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableCheckbox;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.tlauncher.ui.swing.HtmlTextPane;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.U;

public class Alert {
    private static final Color YES = new Color(88, 159, 42);
    private static final Color NO = new Color(204, 118, 47);
    private static final JFrame frame = new JFrame();
    private static final String PREFIX = "TLauncher : ";
    private static final String MISSING_TITLE = "MISSING TITLE";
    private static final String MISSING_MESSAGE = "MISSING MESSAGE";
    private static final String MISSING_QUESTION = "MISSING QUESTION";
    private static String DEFAULT_TITLE = "An error occurred";
    private static String DEFAULT_MESSAGE = "An unexpected error occurred";

    public static void showError(String title, String message, Object textarea) {
        if (textarea instanceof Throwable) {
            U.log("Showing error:", textarea);
            Throwable throwable = (Throwable)textarea;
            String messageThrowable = throwable.getMessage();
            Alert.showMonolog(0, title, message, throwable.getClass().getName() + ": " + messageThrowable);
            return;
        }
        Alert.showMonolog(0, title, message, textarea);
    }

    public static void showError(String title, String message) {
        Alert.showError(title, message, null);
    }

    public static void showError(String message, Object textarea) {
        Alert.showError(DEFAULT_TITLE, message, textarea);
    }

    public static void showError(Object textarea, boolean exit) {
        Alert.showError(DEFAULT_TITLE, DEFAULT_MESSAGE, textarea);
        if (exit) {
            System.exit(-1);
        }
    }

    public static void showError(Object textarea) {
        Alert.showError(textarea, false);
    }

    public static void showLocError(String titlePath, String messagePath, Object textarea) {
        Alert.showError(Alert.getLoc(titlePath, MISSING_TITLE), Alert.getLoc(messagePath, MISSING_MESSAGE), textarea);
    }

    public static void showLocError(String path, Object textarea) {
        Alert.showError(Alert.getLoc(path + ".title", MISSING_TITLE), Alert.getLoc(path, MISSING_MESSAGE), textarea);
    }

    public static void showLocError(String path) {
        Alert.showLocError(path, null);
    }

    public static void showMessage(String title, String message, Object textarea) {
        Alert.showMonolog(1, title, message, textarea);
    }

    public static void showMessage(String title, String message) {
        Alert.showMessage(title, message, null);
    }

    public static void showLocMessage(String titlePath, String messagePath, Object textarea) {
        Alert.showMessage(Alert.getLoc(titlePath, MISSING_TITLE), Alert.getLoc(messagePath, MISSING_MESSAGE), textarea);
    }

    public static void showLocMessage(String path, Object textarea) {
        Alert.showMessage(Alert.getLoc(path + ".title", MISSING_TITLE), Alert.getLoc(path, MISSING_MESSAGE), textarea);
    }

    public static void showLocMessageWithoutTitle(String path) {
        Alert.showMessage(Alert.getLoc("", MISSING_TITLE), Alert.getLoc(path, MISSING_MESSAGE));
    }

    public static void showLocMessage(String path) {
        Alert.showLocMessage(path, null);
    }

    public static void showWarning(String title, String message, Object textarea) {
        Alert.showMonolog(2, title, message, textarea);
    }

    public static void showWarning(String title, String message) {
        Alert.showWarning(title, message, null);
    }

    public static void showLocWarning(String titlePath, String messagePath, Object textarea) {
        Alert.showWarning(Alert.getLoc(titlePath, MISSING_TITLE), Alert.getLoc(messagePath, MISSING_MESSAGE), textarea);
    }

    private static void showLocWarning(String titlePath, String messagePath) {
        Alert.showLocWarning(titlePath, messagePath, null);
    }

    public static void showLocWarning(String path, Object textarea) {
        Alert.showWarning(Alert.getLoc(path + ".title", MISSING_TITLE), Alert.getLoc(path, MISSING_MESSAGE), textarea);
    }

    public static void showLocWarning(String path) {
        Alert.showLocWarning(path, null);
    }

    public static boolean showQuestion(String title, String question, Object textarea) {
        return Alert.showConfirmDialog(0, 3, title, question, textarea) == 0;
    }

    public static boolean showQuestion(String title, String question) {
        return Alert.showQuestion(title, question, null);
    }

    public static boolean showLocQuestion(String titlePath, String questionPath, Object textarea) {
        return Alert.showQuestion(Alert.getLoc(titlePath, MISSING_TITLE), Alert.getLoc(questionPath, MISSING_QUESTION), textarea);
    }

    public static boolean showLocQuestion(String titlePath, String questionPath) {
        return Alert.showQuestion(Alert.getLoc(titlePath, titlePath), Alert.getLoc(questionPath, questionPath), null);
    }

    public static boolean showLocQuestion(String path, Object textarea) {
        return Alert.showQuestion(Alert.getLoc(path + ".title", MISSING_TITLE), Alert.getLoc(path, MISSING_QUESTION), textarea);
    }

    public static boolean showLocQuestion(String path) {
        return Alert.showLocQuestion(path, null);
    }

    private static void showMonolog(int messageType, String title, String message, Object textarea) {
        String button = "ui.ok";
        if (!Localizable.exists()) {
            button = "OK";
        }
        UpdaterButton ok = new UpdaterButton(UpdaterButton.GREEN_COLOR, button);
        Alert.addListener(ok, YES);
        ok.setForeground(Color.WHITE);
        JOptionPane.showOptionDialog(frame, new AlertPanel(message, textarea), Alert.getTitle(title), 1, messageType, null, new Object[]{ok}, 0);
    }

    public static int showErrorMessage(String title, String message, String button1Text, String button2Text) {
        UpdaterButton button1 = new UpdaterButton(UpdaterButton.GREEN_COLOR, button1Text);
        UpdaterButton button2 = new UpdaterButton(UpdaterButton.ORRANGE_COLOR, button2Text);
        Alert.addListener(button1, YES);
        Alert.addListener(button2, NO);
        button1.setForeground(Color.WHITE);
        SwingUtil.setFontSize(button1, 13.0f);
        SwingUtil.setFontSize(button2, 13.0f);
        button2.setForeground(Color.WHITE);
        return JOptionPane.showOptionDialog(frame, Localizable.get(message), Localizable.get(title), 0, 0, null, new Object[]{button1, button2}, 0);
    }

    public static void showCustomMonolog(String title, Object textarea) {
        UpdaterButton ok = new UpdaterButton(UpdaterButton.GREEN_COLOR, "ui.ok");
        Alert.addListener(ok, YES);
        ok.setForeground(Color.WHITE);
        JOptionPane.showOptionDialog(frame, textarea, Alert.getTitle(title), 0, -1, null, new Object[]{ok}, 0);
    }

    public static int showConfirmDialog(int optionType, int messageType, String title, String message, Object textarea) {
        UpdaterButton yes = new UpdaterButton(UpdaterButton.GREEN_COLOR, "ui.yes");
        yes.setForeground(Color.WHITE);
        UpdaterButton no = new UpdaterButton(UpdaterButton.ORRANGE_COLOR, "ui.no");
        no.setForeground(Color.WHITE);
        Alert.addListener(yes, YES);
        Alert.addListener(no, NO);
        return JOptionPane.showOptionDialog(frame, new AlertPanel(message, textarea), Alert.getTitle(title), 0, messageType, null, new Object[]{yes, no}, 0);
    }

    public static void prepareLocal() {
        DEFAULT_TITLE = Alert.getLoc("alert.error.title", DEFAULT_TITLE);
        DEFAULT_MESSAGE = Alert.getLoc("alert.error.message", DEFAULT_MESSAGE);
    }

    private static String getTitle(String title) {
        return PREFIX + (title == null ? MISSING_TITLE : title);
    }

    private static String getLoc(String path, String fallbackMessage) {
        String result = Localizable.get(path);
        return result == null ? fallbackMessage : result;
    }

    public static void showMonologError(String message, int number) {
        JOptionPane.showMessageDialog(null, new AlertPanel(message, null), "", number, null);
    }

    protected static JOptionPane getOptionPane(JComponent parent) {
        JOptionPane pane = !(parent instanceof JOptionPane) ? Alert.getOptionPane((JComponent)parent.getParent()) : (JOptionPane)parent;
        return pane;
    }

    public static void addListener(final UpdaterButton changes, final Color color) {
        changes.addActionListener(e -> {
            JOptionPane pane = Alert.getOptionPane((JComponent)e.getSource());
            pane.setValue(changes);
        });
        changes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                changes.setBackground(color);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                changes.setBackground(changes.getBackgroundColor());
            }
        });
    }

    public static boolean showWarningMessageWithCheckBox(String title, String message, int width) {
        return Alert.showWarningMessageWithCheckBox(title, message, width, "skin.notification.state");
    }

    public static boolean showWarningMessageWithCheckBox(String title, String message, int width, String buttonText) {
        UpdaterButton ok = new UpdaterButton(UpdaterButton.GREEN_COLOR, "ui.ok");
        Alert.addListener(ok, YES);
        LocalizableCheckbox b = new LocalizableCheckbox(buttonText, LocalizableCheckbox.PANEL_TYPE.SETTINGS);
        b.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        b.setHorizontalAlignment(0);
        b.setIconTextGap(10);
        b.setState(false);
        JPanel panel = new JPanel(new BorderLayout(0, 10));
        HtmlTextPane pane = HtmlTextPane.get(Localizable.get(message), width);
        panel.add((Component)pane, "Center");
        panel.add((Component)b, "South");
        ok.setForeground(Color.WHITE);
        JOptionPane.showOptionDialog(frame, panel, " " + Localizable.get(title), 0, 1, (Icon)ImageCache.getIcon((String)"warning.png"), new Object[]{ok}, null);
        return b.getState();
    }

    public static void showHtmlMessage(String title, String message, int type, int width) {
        String textValue = Localizable.exists() ? Localizable.get("ui.ok") : "OK";
        UpdaterButton ok = new UpdaterButton(UpdaterButton.GREEN_COLOR, textValue);
        Alert.addListener(ok, YES);
        ok.setForeground(Color.WHITE);
        JOptionPane.showOptionDialog(frame, HtmlTextPane.get(Localizable.get(message), width), Localizable.get(title), 0, type, null, new Object[]{ok}, null);
    }

    public static void showErrorHtml(String message, int width) {
        Alert.showHtmlMessage("", message, 0, width);
    }

    public static void showErrorHtml(String title, String message) {
        Alert.showHtmlMessage(title, message, 0, 500);
    }

    public static void showMessage(String title, JPanel content, JButton[] buttons) {
        JDialog jDialog = new JDialog((Frame)frame, title);
        Arrays.stream(buttons).forEach(e -> e.addActionListener(a -> jDialog.setVisible(false)));
        jDialog.setAlwaysOnTop(true);
        jDialog.setResizable(false);
        jDialog.setContentPane(content);
        jDialog.setModal(true);
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(true);
    }

    public static boolean showWarningMessageWithCheckBox1(String title, String message, int width, String buttonText) {
        JButton ok = new JButton("OK");
        ok.addActionListener(e -> {
            JOptionPane pane = Alert.getOptionPane((JComponent)e.getSource());
            pane.setValue(ok);
        });
        JCheckBox b = new JCheckBox(buttonText);
        b.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        b.setHorizontalAlignment(0);
        b.setIconTextGap(10);
        b.getModel().setSelected(false);
        JPanel panel = new JPanel(new BorderLayout(0, 10));
        HtmlTextPane pane = HtmlTextPane.get(Localizable.get(message), width);
        panel.add((Component)pane, "Center");
        panel.add((Component)b, "South");
        ok.setForeground(Color.WHITE);
        JOptionPane.showOptionDialog(null, panel, " " + Localizable.get(title), 0, 1, null, new Object[]{ok}, null);
        return b.getModel().isSelected();
    }

    static {
        frame.setAlwaysOnTop(true);
    }
}

