/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.login;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.tlauncher.tlauncher.managers.ProfileManager;
import org.tlauncher.tlauncher.managers.ProfileManagerListener;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.minecraft.auth.Authenticator;
import org.tlauncher.tlauncher.minecraft.auth.AuthenticatorDatabase;
import org.tlauncher.tlauncher.minecraft.auth.AuthenticatorListener;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.block.Blockable;
import org.tlauncher.tlauncher.ui.listener.AuthUIListener;
import org.tlauncher.tlauncher.ui.loc.LocalizableComponent;
import org.tlauncher.tlauncher.ui.login.LoginException;
import org.tlauncher.tlauncher.ui.login.LoginForm;
import org.tlauncher.tlauncher.ui.login.LoginWaitException;
import org.tlauncher.tlauncher.ui.swing.AccountCellRenderer;
import org.tlauncher.tlauncher.ui.swing.SimpleComboBoxModel;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedComboBox;

public class AccountComboBox
extends ExtendedComboBox<Account>
implements Blockable,
LoginForm.LoginProcessListener,
ProfileManagerListener,
LocalizableComponent {
    private static final long serialVersionUID = 6618039863712810645L;
    private static final Account EMPTY = AccountCellRenderer.EMPTY;
    private static final Account MANAGE = AccountCellRenderer.MANAGE;
    private final ProfileManager manager;
    private final LoginForm loginForm;
    private final AuthenticatorListener listener;
    private final SimpleComboBoxModel<Account> model;
    private Account selectedAccount;

    AccountComboBox(LoginForm lf) {
        super(new AccountCellRenderer());
        this.loginForm = lf;
        this.model = this.getSimpleModel();
        this.manager = TLauncher.getInstance().getProfileManager();
        this.manager.addListener(this);
        this.listener = new AuthUIListener(lf);
        this.addItemListener(e -> {
            Account selected = (Account)this.getSelectedItem();
            if (selected == null || selected.equals(EMPTY)) {
                return;
            }
            if (selected.equals(MANAGE)) {
                this.loginForm.pane.openAccountEditor();
                return;
            }
            if (selected != null) {
                this.selectedAccount = selected;
                TLauncher.getInstance().getConfiguration().set("account.selected", this.selectedAccount.getUserID(), true);
            }
        });
    }

    public Account getAccount() {
        Account value = (Account)this.getSelectedItem();
        return value == null || value.equals(EMPTY) ? null : value;
    }

    public void setAccount(Account account) {
        if (account == null) {
            return;
        }
        if (account.equals(this.getAccount())) {
            return;
        }
        this.setSelectedItem(account);
    }

    void setAccount(String username, Account.AccountType type) {
        if (username != null) {
            this.setSelectedItem(this.manager.getAuthDatabase().getByUsername(username));
        }
    }

    @Override
    public void logginingIn() throws LoginException {
        Account account = this.getAccount();
        if (account == null) {
            this.loginForm.pane.openAccountEditor();
            Alert.showLocError("account.empty.error");
            throw new LoginException("Account list is empty!");
        }
        if (!account.isFree()) {
            throw new LoginWaitException("Waiting for auth...", () -> Authenticator.instanceFor(account).pass(this.listener));
        }
    }

    @Override
    public void loginFailed() {
    }

    @Override
    public void loginSucceed() {
    }

    public void refreshAccounts(AuthenticatorDatabase db, Account select) {
        if (select == null && this.selectedAccount != null) {
            select = this.selectedAccount;
        }
        this.removeAllItems();
        Collection<Account> list = db.getAccounts();
        if (list.isEmpty()) {
            this.addItem(EMPTY);
        } else {
            String id = null;
            if (this.selectedAccount == null) {
                id = TLauncher.getInstance().getConfiguration().get("account.selected");
            }
            this.model.addElements(list);
            if (StringUtils.isNotBlank((CharSequence)id)) {
                for (Account account : list) {
                    if (!id.equals(account.getUserID())) continue;
                    this.selectedAccount = select = account;
                    break;
                }
            } else if (this.selectedAccount != null) {
                TLauncher.getInstance().getConfiguration().set("account.selected", this.selectedAccount.getUserID(), true);
            }
            for (Account account : list) {
                if (select == null || !select.equals(account)) continue;
                this.setSelectedItem(account);
            }
        }
        this.addItem(MANAGE);
    }

    @Override
    public void updateLocale() {
        this.refreshAccounts(this.manager.getAuthDatabase(), this.selectedAccount);
    }

    @Override
    public void onAccountsRefreshed(AuthenticatorDatabase db) {
        this.refreshAccounts(db, this.selectedAccount);
    }

    @Override
    public void onProfilesRefreshed(ProfileManager pm) {
        this.refreshAccounts(pm.getAuthDatabase(), this.selectedAccount);
    }

    @Override
    public void onProfileManagerChanged(ProfileManager pm) {
        this.refreshAccounts(pm.getAuthDatabase(), this.selectedAccount);
    }

    @Override
    public void block(Object reason) {
        this.setEnabled(false);
    }

    @Override
    public void unblock(Object reason) {
        this.setEnabled(true);
    }
}

