/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.login;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javafx.application.Platform;
import javax.swing.BorderFactory;
import javax.swing.SpringLayout;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.block.BlockablePanel;
import org.tlauncher.tlauncher.ui.loc.LocalizableCheckbox;
import org.tlauncher.tlauncher.ui.login.AccountComboBox;
import org.tlauncher.tlauncher.ui.login.LoginForm;
import org.tlauncher.tlauncher.ui.login.UsernameField;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;
import org.tlauncher.util.OS;

public class AccountPanel
extends BlockablePanel {
    public final AccountComboBox accountComboBox;
    public final LoginForm loginForm;
    public final UsernameField username;
    public final LocalizableCheckbox chooseTypeAccount;
    private Account.AccountType type;
    private static boolean helperOpen = false;
    private ExtendedPanel accountPanel;

    public AccountPanel(LoginForm lf, boolean chooser) {
        this.loginForm = lf;
        this.username = new UsernameField(lf.global.get("login.account"));
        EmptyBorder empty = new EmptyBorder(0, 9, 0, 0);
        CompoundBorder border = new CompoundBorder(BorderFactory.createEmptyBorder(), empty);
        this.username.setBorder(border);
        this.accountComboBox = new AccountComboBox(lf);
        this.chooseTypeAccount = new LocalizableCheckbox("loginform.checkbox.account");
        this.chooseTypeAccount.setForeground(Color.WHITE);
        this.chooseTypeAccount.setIconTextGap(14);
        this.chooseTypeAccount.setFocusPainted(false);
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        this.accountPanel = new ExtendedPanel(new GridLayout(1, 1));
        springLayout.putConstraint("North", (Component)this.accountPanel, 11, "North", (Component)this);
        springLayout.putConstraint("West", (Component)this.accountPanel, 0, "West", (Component)this);
        springLayout.putConstraint("South", (Component)this.accountPanel, 35, "North", (Component)this);
        springLayout.putConstraint("East", (Component)this.accountPanel, 0, "East", (Component)this);
        this.add((Component)this.accountPanel);
        if (chooser) {
            this.accountPanel.add((Component)this.accountComboBox);
            this.type = Account.AccountType.MOJANG;
            lf.addLoginProcessListener(this.accountComboBox);
        } else {
            this.accountPanel.add((Component)this.username);
            this.type = Account.AccountType.FREE;
            lf.addLoginProcessListener(this.username);
        }
        if (!OS.is(OS.WINDOWS)) {
            Font f = this.chooseTypeAccount.getFont();
            this.chooseTypeAccount.setFont(new Font(f.getFamily(), f.getStyle(), 11));
        }
        springLayout.putConstraint("North", (Component)this.chooseTypeAccount, 44, "North", (Component)this);
        springLayout.putConstraint("South", (Component)this.chooseTypeAccount, -11, "South", (Component)this);
        springLayout.putConstraint("West", (Component)this.chooseTypeAccount, -4, "West", (Component)this.accountPanel);
        springLayout.putConstraint("East", (Component)this.chooseTypeAccount, 0, "East", (Component)this.accountPanel);
        this.add((Component)this.chooseTypeAccount);
        this.chooseTypeAccount.getModel().setSelected(chooser);
        this.chooseTypeAccount.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AccountPanel.this.changeTypeAccount(Account.AccountType.SPECIAL);
                        TLauncher.getInstance().getConfiguration().set("chooser.type.account", (Object)true);
                        if (TLauncher.getInstance().getConfiguration().isFirstRun() && !helperOpen) {
                            AccountPanel.this.loginForm.pane.openAccountEditor();
                            AccountPanel.this.loginForm.pane.accountEditor.setShownAccountHelper(true, true);
                            helperOpen = true;
                            AccountPanel.this.loginForm.pane.accountEditor.addComponentListener(new ComponentListener(){

                                @Override
                                public void componentShown(ComponentEvent e) {
                                }

                                @Override
                                public void componentResized(ComponentEvent e) {
                                }

                                @Override
                                public void componentMoved(ComponentEvent e) {
                                }

                                @Override
                                public void componentHidden(ComponentEvent e) {
                                    AccountPanel.this.loginForm.pane.accountEditor.setShownAccountHelper(false, false);
                                }
                            });
                        }
                    }
                });
            } else {
                this.changeTypeAccount(Account.AccountType.FREE);
                TLauncher.getInstance().getConfiguration().set("chooser.type.account", (Object)false);
            }
        });
    }

    public void changeTypeAccount(Account.AccountType type) {
        if (type.equals((Object)Account.AccountType.SPECIAL)) {
            if (this.accountPanel.contains(this.username)) {
                this.accountPanel.remove(this.username);
            }
            this.accountPanel.add((Component)this.accountComboBox);
            this.loginForm.addLoginProcessListener(this.accountComboBox);
            this.loginForm.removeLoginProcessListener(this.username);
            this.type = Account.AccountType.SPECIAL;
        } else {
            if (this.accountPanel.contains(this.accountComboBox)) {
                this.accountPanel.remove(this.accountComboBox);
            }
            this.accountPanel.add((Component)this.username);
            this.loginForm.addLoginProcessListener(this.username);
            this.loginForm.removeLoginProcessListener(this.accountComboBox);
            this.type = Account.AccountType.FREE;
        }
        this.revalidate();
        this.repaint();
    }

    public String getUsername() {
        if (this.type.equals((Object)Account.AccountType.FREE)) {
            return this.username.getUsername();
        }
        return ((Account)this.accountComboBox.getSelectedItem()).getUsername();
    }

    public Account.AccountType getTypeAccountShow() {
        return this.type;
    }
}

