/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.modpack;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.apache.commons.io.IOUtils;
import org.tlauncher.tlauncher.modpack.ModpackUtil;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.loc.ImageUdaterButton;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.modpack.BigPictureObserver;
import org.tlauncher.tlauncher.ui.scenes.ModpackScene;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;
import org.tlauncher.tlauncher.ui.swing.renderer.PictureListRenderer;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.async.AsyncThread;

public class PicturePanel
extends ExtendedPanel {
    private JButton previousPicture;
    private JButton nextPicture;
    private JList<ImageIcon> list;
    private final int WIDHT_BUTTON = 64;
    private int current;
    private Dimension buttonSize = new Dimension(64, 155);
    private List<ImageIcon> cache = new ArrayList<ImageIcon>();

    public PicturePanel(final Integer[] array) {
        this.setPreferredSize(new Dimension(1050, 318));
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setOpaque(false);
        this.previousPicture = new ImageUdaterButton(Color.WHITE, Color.WHITE, "previous-arrow.png", "previous-arrow-under.png");
        this.nextPicture = new ImageUdaterButton(Color.WHITE, Color.WHITE, "next-arrow.png", "next-arrow-under.png");
        this.list = new JList();
        this.list.setPreferredSize(new Dimension(ModpackScene.SIZE.width - 128, 190));
        if (array.length == 1) {
            this.list.setBorder(BorderFactory.createEmptyBorder(64, 304, 0, 0));
        } else {
            this.list.setBorder(BorderFactory.createEmptyBorder(64, 0, 0, 0));
        }
        this.list.setOpaque(false);
        this.list.setLayoutOrientation(2);
        this.list.setVisibleRowCount(1);
        this.nextPicture.setPreferredSize(this.buttonSize);
        this.previousPicture.setPreferredSize(this.buttonSize);
        this.list.setCellRenderer(new PictureListRenderer());
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (PicturePanel.this.list.getModel().getSize() > 0 && PicturePanel.this.current != -1) {
                    BigPictureObserver pictureObserver = new BigPictureObserver((JFrame)TLauncher.getInstance().getFrame(), "", array, PicturePanel.this.current + PicturePanel.this.list.locationToIndex(e.getPoint()));
                    pictureObserver.setVisible(true);
                }
            }
        });
        this.previousPicture.setOpaque(false);
        this.nextPicture.setOpaque(false);
        if (array.length > 3) {
            this.add((Component)this.previousPicture, "West");
            this.add((Component)this.nextPicture, "East");
        } else {
            this.setBorder(BorderFactory.createEmptyBorder(0, 64, 0, 64));
        }
        this.nextPicture.addActionListener(e -> this.updateNext());
        this.previousPicture.addActionListener(e -> this.updatePrevious());
        if (array.length == 0) {
            LocalizableLabel l = new LocalizableLabel("modpack.complete.picture.empty");
            l.setHorizontalAlignment(0);
            l.setVerticalAlignment(0);
            SwingUtil.setFontSize(l, 16.0f);
            this.add((Component)l, "Center");
        } else {
            final LocalizableLabel downloadingLabel = new LocalizableLabel("loginform.loading");
            downloadingLabel.setHorizontalAlignment(0);
            downloadingLabel.setVerticalAlignment(0);
            SwingUtil.setFontSize(downloadingLabel, 16.0f);
            this.add((Component)downloadingLabel, "Center");
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent c) {
                    CompletableFuture.runAsync(() -> {
                        if (PicturePanel.this.cache.isEmpty()) {
                            PicturePanel.this.loadImages(array);
                            SwingUtilities.invokeLater(() -> {
                                PicturePanel.this.updateData();
                                PicturePanel.this.remove(downloadingLabel);
                                PicturePanel.this.add((Component)PicturePanel.this.list, "Center");
                                PicturePanel.this.revalidate();
                                PicturePanel.this.repaint();
                            });
                        }
                    });
                }
            });
        }
    }

    private void loadImages(Integer[] array) {
        List<CompletableFuture> futures = Arrays.stream(array).map(e -> ModpackUtil.getPictureURL(e, "_small_full")).map(s -> CompletableFuture.supplyAsync(() -> {
            try {
                U.debug(s);
                return new ImageIcon(IOUtils.toByteArray(new URL((String)s)));
            }
            catch (Exception e) {
                U.log(e);
                return null;
            }
        }, AsyncThread.getService())).collect(Collectors.toList());
        try {
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).get();
            for (CompletableFuture f : futures) {
                if (f.get() == null) continue;
                this.cache.add((ImageIcon)f.get());
            }
        }
        catch (Exception e2) {
            U.log(e2);
        }
    }

    private void updateNext() {
        int enable = this.cache.size() - 3 - this.current;
        if (enable > 0) {
            ++this.current;
            this.updateData();
        }
    }

    private void updatePrevious() {
        if (this.current > 0) {
            --this.current;
            this.updateData();
        }
    }

    private void updateData() {
        DefaultListModel<ImageIcon> page = new DefaultListModel<ImageIcon>();
        int i = this.current;
        for (int j = 0; i < this.cache.size() && j < 3; ++i, ++j) {
            page.addElement(this.cache.get(i));
        }
        this.list.setModel(page);
        this.nextPicture.setPreferredSize(this.buttonSize);
        this.previousPicture.setPreferredSize(this.buttonSize);
        this.repaint();
    }
}

