/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.modpack.right.panel;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import net.minecraft.launcher.versions.CompleteVersion;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.share.Category;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.version.VersionDTO;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.listener.BlockClickListener;
import org.tlauncher.tlauncher.ui.listener.mods.GameEntityListener;
import org.tlauncher.tlauncher.ui.listener.mods.UpdateGameListener;
import org.tlauncher.tlauncher.ui.loc.modpack.GameRightButton;
import org.tlauncher.tlauncher.ui.modpack.filter.BaseModpackFilter;
import org.tlauncher.tlauncher.ui.modpack.filter.CategoryFilter;
import org.tlauncher.tlauncher.ui.modpack.filter.Filter;
import org.tlauncher.tlauncher.ui.modpack.filter.ModpackSceneFilter;
import org.tlauncher.tlauncher.ui.modpack.filter.NameFilter;
import org.tlauncher.tlauncher.ui.modpack.filter.WordFilter;
import org.tlauncher.tlauncher.ui.modpack.right.panel.RightTableModel;
import org.tlauncher.tlauncher.ui.scenes.CompleteSubEntityScene;
import org.tlauncher.tlauncher.ui.scenes.ModpackScene;
import org.tlauncher.tlauncher.ui.swing.box.ModpackComboBox;
import org.tlauncher.util.ColorUtil;
import org.tlauncher.util.SwingUtil;

public class GameEntityRightPanel
extends JTable
implements GameEntityListener {
    private final ModpackComboBox localmodpacks;
    private final ModpackScene.SearchPanel search;
    private final JComboBox<Category> categoriesBox;
    private final GameType type;
    private static final int HEIGHT_RIGHT_ELEMENT = 159;
    private List<Long> changeableElements = new ArrayList<Long>();

    public GameEntityRightPanel(ModpackComboBox localmodpacks, ModpackScene.SearchPanel search, JComboBox<Category> categoriesBox, GameType type) {
        this.search = search;
        this.localmodpacks = localmodpacks;
        this.categoriesBox = categoriesBox;
        this.type = type;
        this.setBackground(ColorUtil.COLOR_233);
        this.setRowHeight(159);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setDefaultEditor(GameRightElement.class, new RightRenderer());
        this.setDefaultRenderer(GameRightElement.class, new RightRenderer());
        MouseAdapter mouse = new MouseAdapter(){
            int current = -1;

            @Override
            public void mouseMoved(MouseEvent e) {
                this.check(e);
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                GameEntityRightPanel.this.getParent().dispatchEvent(e);
                this.check(e);
            }

            private void check(MouseEvent e) {
                int i = GameEntityRightPanel.this.rowAtPoint(e.getPoint());
                if (i != -1 && i != this.current) {
                    GameEntityRightPanel.this.editCellAt(i, 0);
                    this.current = i;
                }
            }
        };
        this.addMouseWheelListener(mouse);
        this.addMouseMotionListener(mouse);
    }

    public void addElements(List<? extends GameEntityDTO> list, GameType type) {
        RightTableModel<? extends GameEntityDTO> model = new RightTableModel<GameEntityDTO>(list);
        this.setModel(model);
    }

    @Override
    public void processingStarted(GameEntityDTO e, VersionDTO version) {
        this.changeableElements.add(e.getId());
        for (Component c : Arrays.asList(this.getComponents())) {
            GameRightElement el;
            if (!(c instanceof GameRightElement) || !(el = (GameRightElement)c).getEntity().getId().equals(e.getId())) continue;
            el.processingInstall();
        }
    }

    @Override
    public void installEntity(GameEntityDTO e, GameType type) {
        this.changeableElements.remove(e.getId());
        this.filterRightPanel(TLauncher.getInstance().getFrame().mp.modpackScene.getCurrent());
        this.updateRow();
    }

    @Override
    public void installError(GameEntityDTO e, VersionDTO v, Throwable t) {
        this.changeableElements.remove(e.getId());
        GameRightElement elem = this.find(e);
        if (elem != null) {
            elem.modpackActButton.reset();
        }
    }

    private GameRightElement find(GameEntityDTO e) {
        for (Component c : Arrays.asList(this.getComponents())) {
            GameRightElement el;
            if (!(c instanceof GameRightElement) || !(el = (GameRightElement)c).getEntity().getId().equals(e.getId())) continue;
            return el;
        }
        return null;
    }

    @Override
    public void populateStatus(GameEntityDTO e, GameType type, boolean state) {
        GameRightElement elem = this.find(e);
        if (elem != null) {
            elem.getStatusStarButton().setStatus(state);
        }
    }

    @Override
    public void removeEntity(GameEntityDTO e) {
        this.changeableElements.remove(e.getId());
        this.filterRightPanel(TLauncher.getInstance().getFrame().mp.modpackScene.getCurrent());
        this.updateRow();
    }

    void updateRow() {
        final int row = this.getEditingRow();
        if (row >= 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GameEntityRightPanel.this.editCellAt(row, 0);
                }
            });
        }
    }

    public void filterRightPanel(final GameType current) {
        Container container = this.getParent();
        CardLayout cardLayout = (CardLayout)container.getLayout();
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        RowFilter<RightTableModel, Integer> filter = new RowFilter<RightTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends RightTableModel, ? extends Integer> entry) {
                Object dto = entry.getModel().getValueAt(entry.getIdentifier(), 0);
                ModpackSceneFilter gameEntityFilterI = new ModpackSceneFilter(GameEntityRightPanel.this.localmodpacks, current, new Filter[0]);
                if (GameEntityRightPanel.this.search.isNotEmpty()) {
                    gameEntityFilterI.addFilter(new NameFilter(GameEntityRightPanel.this.search.getSearchLine()));
                    gameEntityFilterI.addFilter(new WordFilter(GameEntityRightPanel.this.search.getSearchLine()));
                }
                gameEntityFilterI.addFilter(new CategoryFilter((Category)((Object)GameEntityRightPanel.this.categoriesBox.getSelectedItem())));
                if (((BaseModpackFilter)gameEntityFilterI).isProper(dto)) {
                    if (!atomicBoolean.get()) {
                        atomicBoolean.set(true);
                    }
                    return true;
                }
                return false;
            }
        };
        TableRowSorter sorter = (TableRowSorter)this.getRowSorter();
        sorter.setRowFilter(filter);
        sorter.sort();
        if (atomicBoolean.get()) {
            cardLayout.show(container, ModpackScene.NOT_EMPTY);
        } else {
            cardLayout.show(container, ModpackScene.EMPTY);
        }
    }

    @Override
    public void installEntity(CompleteVersion e) {
    }

    @Override
    public void activationStarted(GameEntityDTO e) {
    }

    @Override
    public void activation(GameEntityDTO e) {
    }

    @Override
    public void activationError(GameEntityDTO e, Throwable t) {
    }

    @Override
    public void updateVersion(CompleteVersion v, CompleteVersion newVersion) {
    }

    @Override
    public void removeCompleteVersion(CompleteVersion e) {
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return GameRightElement.class;
    }

    private class RightRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            GameRightElement el = new GameRightElement((GameEntityDTO)value, GameEntityRightPanel.this.type, row);
            if (GameEntityRightPanel.this.changeableElements.contains(((GameEntityDTO)value).getId())) {
                el.modpackActButton.setTypeButton("PROCESSING");
            }
            el.setBackground(ColorUtil.COLOR_247);
            return el;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            GameRightElement el = new GameRightElement((GameEntityDTO)value, GameEntityRightPanel.this.type, row);
            if (GameEntityRightPanel.this.changeableElements.contains(((GameEntityDTO)value).getId())) {
                el.modpackActButton.setTypeButton("PROCESSING");
            }
            el.setBackground(Color.WHITE);
            return el;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }

    public class GameRightElement
    extends CompleteSubEntityScene.DescriptionGamePanel
    implements UpdateGameListener {
        private GameEntityDTO entity;
        private int row;
        private GameRightButton modpackActButton;

        public GameEntityDTO getEntity() {
            return this.entity;
        }

        public GameRightElement(final GameEntityDTO entity, final GameType type, int row) {
            super(entity, type);
            this.row = row;
            this.description.setVisible(true);
            this.entity = entity;
            this.modpackActButton = new GameRightButton(entity, type, GameEntityRightPanel.this.localmodpacks){

                @Override
                public void updateRow() {
                    GameEntityRightPanel.this.repaint();
                }
            };
            JLabel shadow = new JLabel(){

                @Override
                protected void paintComponent(Graphics g) {
                    Rectangle rec = this.getBounds();
                    SwingUtil.paintShadowLine(rec, g, this.getParent().getBackground().getRed() - 14, 14);
                }
            };
            shadow.setBackground(Color.green);
            this.descriptionLayout.putConstraint("West", (Component)shadow, 0, "West", (Component)this);
            this.descriptionLayout.putConstraint("East", (Component)shadow, 0, "East", (Component)this);
            this.descriptionLayout.putConstraint("North", (Component)shadow, 0, "North", (Component)this);
            this.descriptionLayout.putConstraint("South", (Component)shadow, 14, "North", (Component)this);
            this.add(shadow);
            this.modpackActButton.initButton();
            this.imagePanel.addMoapckActButton(this.modpackActButton);
            this.descriptionLayout.putConstraint("West", (Component)this.imagePanel, 27, "West", (Component)this);
            this.descriptionLayout.putConstraint("East", (Component)this.imagePanel, 138, "West", (Component)this);
            class MouseBackgroundListener
            extends MouseAdapter
            implements BlockClickListener {
                MouseBackgroundListener() {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 1) {
                        ((ModpackManager)TLauncher.getInjector().getInstance(ModpackManager.class)).showFullGameEntity(entity, type);
                    }
                }
            }
            MouseBackgroundListener adapter = new MouseBackgroundListener();
            this.addMouseListener(adapter);
            for (Component comp : this.getComponents()) {
                comp.removeMouseListener(adapter);
            }
            this.description.addMouseListener(adapter);
        }

        @Override
        public void processingActivation() {
        }

        @Override
        public void processingInstall() {
            this.modpackActButton.setTypeButton("PROCESSING");
            ((RightTableModel)GameEntityRightPanel.this.getModel()).fireTableCellUpdated(this.row, 0);
        }

        @Override
        public void initGameEntity() {
        }
    }
}

