/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.scenes;

import com.google.inject.Injector;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableRowSorter;
import net.minecraft.launcher.versions.CompleteVersion;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.GameVersionDTO;
import org.tlauncher.modpack.domain.client.ModpackDTO;
import org.tlauncher.modpack.domain.client.SubModpackDTO;
import org.tlauncher.modpack.domain.client.share.Category;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.share.InfoMod;
import org.tlauncher.modpack.domain.client.version.ModpackVersionDTO;
import org.tlauncher.modpack.domain.client.version.VersionDTO;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.minecraft.crash.Crash;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftException;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftListener;
import org.tlauncher.tlauncher.modpack.ModpackUtil;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.MainPane;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.button.StateModpackElementButton;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.listener.mods.DeferredDocumentListener;
import org.tlauncher.tlauncher.ui.listener.mods.GameEntityPanel;
import org.tlauncher.tlauncher.ui.listener.mods.ModpackBoxListener;
import org.tlauncher.tlauncher.ui.listener.mods.UpdateGameListener;
import org.tlauncher.tlauncher.ui.loc.ImageUdaterButton;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableComponent;
import org.tlauncher.tlauncher.ui.loc.LocalizableHTMLLabel;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.loc.LocalizableTextField;
import org.tlauncher.tlauncher.ui.loc.UpdaterFullButton;
import org.tlauncher.tlauncher.ui.loc.modpack.ShadowButton;
import org.tlauncher.tlauncher.ui.login.LoginForm;
import org.tlauncher.tlauncher.ui.menu.ModpackPopup;
import org.tlauncher.tlauncher.ui.modpack.ModpackConfigFrame;
import org.tlauncher.tlauncher.ui.modpack.ModpackCreation;
import org.tlauncher.tlauncher.ui.modpack.filter.BaseModpackFilter;
import org.tlauncher.tlauncher.ui.modpack.filter.NameFilter;
import org.tlauncher.tlauncher.ui.modpack.right.panel.GameEntityRightPanel;
import org.tlauncher.tlauncher.ui.modpack.right.panel.RightTableModel;
import org.tlauncher.tlauncher.ui.scenes.PseudoScene;
import org.tlauncher.tlauncher.ui.scenes.UniverseBackPanel;
import org.tlauncher.tlauncher.ui.swing.GameRadioTextButton;
import org.tlauncher.tlauncher.ui.swing.ImageButton;
import org.tlauncher.tlauncher.ui.swing.ScrollPane;
import org.tlauncher.tlauncher.ui.swing.box.ModpackComboBox;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;
import org.tlauncher.tlauncher.ui.swing.renderer.CategoryListRenderer;
import org.tlauncher.tlauncher.ui.swing.renderer.ModpackComboxRenderer;
import org.tlauncher.tlauncher.ui.swing.renderer.UserCategoryListRenderer;
import org.tlauncher.tlauncher.ui.ui.ModpackComboBoxUI;
import org.tlauncher.tlauncher.ui.ui.ModpackScrollBarUI;
import org.tlauncher.util.ColorUtil;
import org.tlauncher.util.OS;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.swing.FontTL;

public class ModpackScene
extends PseudoScene
implements MinecraftListener {
    public static final Dimension SIZE = new Dimension(MainPane.SIZE.width, 585);
    public static final Color UP_BACKGROUND_PANEL_COLOR = new Color(60, 170, 252);
    public static final Color BACKGROUND_RIGHT_UNDER_PANEL = new Color(241, 241, 241);
    private static final GameType[] GAME_TYPES = new GameType[]{GameType.MODPACK, GameType.MOD, GameType.RESOURCEPACK, GameType.MAP};
    public static int LEFT_WIDTH = 234;
    public static int RIGHT_WIDTH = ModpackScene.SIZE.width - LEFT_WIDTH;
    public static String EMPTY = "EMPTY";
    public static String NOT_EMPTY = "NOT_EMPTY";
    protected final ModpackComboBox localmodpacks = new ModpackComboBox();
    private final ExtendedPanel panel = new ExtendedPanel();
    private final JPanel layoutCenterPanel;
    private final GameEntityRightPanel modpacksPanel;
    private final GameEntityRightPanel modsPanel;
    private final GameEntityRightPanel resourcePackPanel;
    private final GameEntityRightPanel mapsPanel;
    private final ExtendedPanel entitiesPanel;
    private final Injector injector;
    private final GameEntityLeftPanel modLeftPanel = new GameEntityLeftPanel();
    private final GameEntityLeftPanel mapLeftPanel = new GameEntityLeftPanel();
    private final GameEntityLeftPanel resourceLeftPanel = new GameEntityLeftPanel();
    private final GameRadioTextButton modpacks;
    private final ItemListener modpackBoxListener = new ModpackBoxListener();
    private final SearchPanel search;
    private ModpackManager manager;
    private GameType current = GameType.MODPACK;
    private GameType last;
    private ButtonGroup group = new ButtonGroup();
    private JComboBox<Category> categoriesBox;
    private JComboBox<UserCategory> sortBox;

    public ModpackScene(MainPane main) {
        super(main);
        this.search = new SearchPanel();
        this.categoriesBox = new JComboBox<Category>(){
            private ItemListener listener = e -> {
                if (e.getStateChange() == 1) {
                    ModpackScene.this.prepareRightPanel();
                }
            };

            @Override
            public void setModel(ComboBoxModel<Category> aModel) {
                this.removeItemListener(this.listener);
                super.setModel(aModel);
                this.addItemListener(this.listener);
            }
        };
        this.modpacksPanel = new GameEntityRightPanel(this.localmodpacks, this.search, this.categoriesBox, GameType.MODPACK);
        this.modsPanel = new GameEntityRightPanel(this.localmodpacks, this.search, this.categoriesBox, GameType.MOD);
        this.resourcePackPanel = new GameEntityRightPanel(this.localmodpacks, this.search, this.categoriesBox, GameType.RESOURCEPACK);
        this.mapsPanel = new GameEntityRightPanel(this.localmodpacks, this.search, this.categoriesBox, GameType.MAP);
        this.injector = TLauncher.getInjector();
        this.layoutCenterPanel = new JPanel(new CardLayout(0, 0));
        this.manager = (ModpackManager)this.injector.getInstance(ModpackManager.class);
        this.localmodpacks.setPreferredSize(new Dimension(200, 30));
        final ExtendedPanel buttons = new ExtendedPanel(){

            @Override
            protected void paintComponent(Graphics g0) {
                g0.drawImage(ImageCache.getBufferedImage((String)"modpack-top2-background.png"), 0, 0, null);
            }
        };
        buttons.setLayout(new FlowLayout(0, 0, 0));
        ExtendedPanel center = new ExtendedPanel();
        this.entitiesPanel = new ExtendedPanel(new CardLayout(0, 0));
        this.panel.setSize(SIZE);
        SpringLayout spring = new SpringLayout();
        this.panel.setLayout(spring);
        this.panel.setOpaque(true);
        center.setLayout(new BorderLayout());
        center.setOpaque(true);
        center.setBackground(Color.WHITE);
        LocalizableLabel nameModpackLabel = new LocalizableLabel("modpack.button.modpack");
        nameModpackLabel.setHorizontalAlignment(0);
        nameModpackLabel.setForeground(Color.WHITE);
        LocalizableLabel categoryLabel = new LocalizableLabel("modpack.filter.label");
        categoryLabel.setHorizontalAlignment(0);
        categoryLabel.setForeground(Color.WHITE);
        categoryLabel.setPreferredSize(new Dimension(98, 55));
        UpdaterFullButton create = new UpdaterFullButton(new Color(54, 153, 208), new Color(30, 136, 195), "modpack.create.button", "create-modpack.png");
        create.setIconTextGap(16);
        LocalizableLabel sortLabel = new LocalizableLabel("modpack.sort.label");
        ExtendedPanel wrapper = new ExtendedPanel(new FlowLayout(1, 0, 0));
        wrapper.setBorder(BorderFactory.createEmptyBorder(7, 0, 8, 0));
        this.sortBox = new JComboBox<UserCategory>(UserCategory.values());
        this.sortBox.setUI(new ModpackComboBoxUI(){

            @Override
            public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
                g.setColor(BACKGROUND_BOX);
                g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
                String name = Localizable.get("modpack." + ((UserCategory)((Object)ModpackScene.this.sortBox.getSelectedItem())).name().toLowerCase());
                this.paintText(g, bounds, name);
            }
        });
        ((Container)wrapper).add(this.sortBox);
        this.sortBox.setBorder(BorderFactory.createLineBorder(ModpackComboxRenderer.LINE, 1));
        this.sortBox.setRenderer(new UserCategoryListRenderer());
        this.categoriesBox.setPreferredSize(new Dimension(192, 40));
        CategoryListRenderer categoryListRenderer = new CategoryListRenderer();
        categoryListRenderer.setBackground(new Color(59, 165, 225));
        this.categoriesBox.setRenderer(categoryListRenderer);
        this.categoriesBox.setBorder(BorderFactory.createLineBorder(ModpackComboxRenderer.LINE, 1));
        final Color categoryBackground = new Color(59, 165, 225);
        this.categoriesBox.setUI(new ModpackComboBoxUI(){

            @Override
            public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
                g.setColor(categoryBackground);
                g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
                Object ob = ModpackScene.this.categoriesBox.getSelectedItem();
                if (ob == null) {
                    return;
                }
                String name = Localizable.get("modpack." + ((Category)((Object)ob)).name().toLowerCase());
                this.paintText(g, bounds, name);
            }

            @Override
            protected JButton createArrowButton() {
                JButton b = super.createArrowButton();
                b.setBackground(categoryBackground);
                return b;
            }
        });
        final GameRadioTextButton mods = new GameRadioTextButton("modpack.button.mod");
        this.modpacks = new GameRadioTextButton("modpack.button.modpack");
        GameRadioTextButton resourcepacks = new GameRadioTextButton("modpack.button.resourcepack");
        GameRadioTextButton maps = new GameRadioTextButton("modpack.button.map");
        this.group.add(mods);
        this.group.add(this.modpacks);
        this.group.add(resourcepacks);
        this.group.add(maps);
        final ImageButton settings = new ImageButton("settings-modpack.png");
        settings.setPreferredSize(new Dimension(66, 55));
        buttons.add((Component)settings);
        buttons.add(Box.createHorizontalStrut(29));
        buttons.add((Component)this.modpacks, Box.createHorizontalStrut(20));
        buttons.add((Component)mods, Box.createHorizontalStrut(20));
        buttons.add((Component)resourcepacks, Box.createHorizontalStrut(20));
        buttons.add((Component)maps, Box.createHorizontalStrut(80));
        buttons.add((Component)categoryLabel);
        buttons.add(Box.createHorizontalStrut(6));
        buttons.add((Component)this.categoriesBox);
        this.layoutCenterPanel.add((Component)this.entitiesPanel, GameType.NOT_MODPACK.toString());
        CardLayout emptyRightLayout = new CardLayout();
        ExtendedPanel emptyRightPanel = new ExtendedPanel(emptyRightLayout);
        emptyRightPanel.add((Component)new EmptyRightView(GameType.MODPACK), EMPTY);
        emptyRightPanel.add((Component)this.modpacksPanel, NOT_EMPTY);
        this.layoutCenterPanel.add((Component)ModpackScene.createScrollWrapper(emptyRightPanel), GameType.MODPACK.toString());
        this.entitiesPanel.add((Component)new GameCenterPanel(this.modLeftPanel, this.modsPanel, GameType.MOD), GameType.MOD.toString());
        this.entitiesPanel.add((Component)new GameCenterPanel(this.resourceLeftPanel, this.resourcePackPanel, GameType.RESOURCEPACK), GameType.RESOURCEPACK.toString());
        this.entitiesPanel.add((Component)new GameCenterPanel(this.mapLeftPanel, this.mapsPanel, GameType.MAP), GameType.MAP.toString());
        center.add((Component)this.layoutCenterPanel, "Center");
        JPanel upPanel = new JPanel(new FlowLayout(0, 0, 0));
        upPanel.setBackground(new Color(60, 170, 232));
        UniverseBackPanel back = new UniverseBackPanel(new Color(54, 153, 208));
        back.setPreferredSize(new Dimension(66, 55));
        nameModpackLabel.setPreferredSize(new Dimension(114, 55));
        this.localmodpacks.setPreferredSize(new Dimension(172, 36));
        create.setPreferredSize(new Dimension(132, 36));
        this.search.setPreferredSize(new Dimension(194, 55));
        JPanel gup1 = new JPanel();
        gup1.setPreferredSize(new Dimension(1, 55));
        Color line = new Color(92, 190, 246);
        gup1.setBackground(line);
        JPanel gup2 = new JPanel();
        gup2.setPreferredSize(new Dimension(1, 55));
        gup2.setBackground(line);
        sortLabel.setPreferredSize(new Dimension(125, 55));
        sortLabel.setHorizontalAlignment(0);
        this.sortBox.setPreferredSize(new Dimension(192, 40));
        wrapper.setPreferredSize(new Dimension(192, 55));
        upPanel.add(back);
        upPanel.add(nameModpackLabel);
        upPanel.add(this.localmodpacks);
        upPanel.add(Box.createHorizontalStrut(16));
        upPanel.add(create);
        upPanel.add(Box.createHorizontalStrut(34));
        upPanel.add(gup1);
        upPanel.add(this.search);
        upPanel.add(gup2);
        upPanel.add(sortLabel);
        upPanel.add(wrapper);
        spring.putConstraint("West", (Component)upPanel, 0, "West", (Component)this.panel);
        spring.putConstraint("East", (Component)upPanel, 0, "East", (Component)this.panel);
        spring.putConstraint("North", (Component)upPanel, 0, "North", (Component)this.panel);
        spring.putConstraint("South", (Component)upPanel, 55, "North", (Component)this.panel);
        this.panel.add((Component)upPanel);
        spring.putConstraint("West", (Component)buttons, 0, "West", (Component)this.panel);
        spring.putConstraint("East", (Component)buttons, 0, "East", (Component)this.panel);
        spring.putConstraint("North", (Component)buttons, 0, "South", (Component)upPanel);
        spring.putConstraint("South", (Component)buttons, 55, "South", (Component)upPanel);
        this.panel.add((Component)buttons);
        spring.putConstraint("West", (Component)center, 0, "West", (Component)this.panel);
        spring.putConstraint("East", (Component)center, 0, "East", (Component)this.panel);
        spring.putConstraint("North", (Component)center, 110, "North", (Component)this.panel);
        spring.putConstraint("South", (Component)center, 0, "South", (Component)this.panel);
        this.panel.add((Component)center);
        this.add((Component)this.panel);
        SwingUtil.changeFontFamily(this.localmodpacks, FontTL.ROBOTO_REGULAR, 14);
        SwingUtil.changeFontFamily(this.search, FontTL.ROBOTO_REGULAR, 14);
        SwingUtil.changeFontFamily(this.sortBox, FontTL.ROBOTO_REGULAR, 14);
        SwingUtil.changeFontFamily(this.categoriesBox, FontTL.ROBOTO_REGULAR, 14);
        SwingUtil.changeFontFamily(nameModpackLabel, FontTL.ROBOTO_REGULAR, 14);
        SwingUtil.changeFontFamily(create, FontTL.ROBOTO_REGULAR, 14);
        SwingUtil.changeFontFamily(sortLabel, FontTL.ROBOTO_REGULAR, 14, Color.WHITE);
        SwingUtil.changeFontFamily(mods, FontTL.ROBOTO_REGULAR, 14);
        SwingUtil.changeFontFamily(this.modpacks, FontTL.ROBOTO_REGULAR, 14);
        SwingUtil.changeFontFamily(resourcepacks, FontTL.ROBOTO_REGULAR, 14);
        SwingUtil.changeFontFamily(maps, FontTL.ROBOTO_REGULAR, 14);
        SwingUtil.changeFontFamily(categoryLabel, FontTL.ROBOTO_MEDIUM, 14, Color.WHITE);
        create.addActionListener(e -> {
            List<GameVersionDTO> list = this.manager.getInfoMod().getGameVersions();
            if (list.isEmpty()) {
                Alert.showLocMessage("modpack.internet.update");
                return;
            }
            new ModpackCreation(this.getMainPane().getRootFrame(), list).setVisible(true);
        });
        create.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
            }
        });
        this.modpacks.addActionListener(e -> {
            this.current = GameType.MODPACK;
            this.categoriesBox.setModel(new DefaultComboBoxModel<Category>(Category.getCategories(this.current)));
            this.prepareRightPanel();
        });
        mods.addActionListener(e -> {
            this.current = GameType.MOD;
            this.categoriesBox.setModel(new DefaultComboBoxModel<Category>(Category.getCategories(this.current)));
            this.prepareRightPanel();
        });
        resourcepacks.addActionListener(e -> {
            this.current = GameType.RESOURCEPACK;
            this.categoriesBox.setModel(new DefaultComboBoxModel<Category>(Category.getCategories(this.current)));
            this.prepareRightPanel();
        });
        maps.addActionListener(e -> {
            this.current = GameType.MAP;
            this.categoriesBox.setModel(new DefaultComboBoxModel<Category>(Category.getCategories(this.current)));
            this.prepareRightPanel();
        });
        this.sortBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.setSorters();
                this.getRightPanelByType(this.current).filterRightPanel(this.current);
            }
        });
        this.localmodpacks.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                if (this.current != GameType.MODPACK) {
                    this.prepareRightPanel();
                }
                TLauncher.getInstance().getConfiguration().set("modpack.combobox.index", (Object)this.localmodpacks.getSelectedIndex());
            }
        });
        settings.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    ModpackPopup menu = new ModpackPopup(ModpackScene.this.localmodpacks);
                    menu.show(settings, e.getX(), e.getY());
                }
            }
        });
        final ActionListener modpackListener = e -> SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                mods.repaint();
                Point point = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(point, ModpackScene.this.localmodpacks);
                if (point.getX() < (double)ModpackScene.this.localmodpacks.getWidth() && point.getX() > (double)(ModpackScene.this.localmodpacks.getWidth() - 40) && ModpackScene.this.localmodpacks.getSelectedIndex() > 0) {
                    ModpackConfigFrame modpackConfigFrame = new ModpackConfigFrame(TLauncher.getInstance().getFrame(), (CompleteVersion)ModpackScene.this.localmodpacks.getSelectedValue());
                    modpackConfigFrame.setVisible(true);
                    modpackConfigFrame.addComponentListener(new ComponentAdapter(){

                        @Override
                        public void componentHidden(ComponentEvent e) {
                            buttons.repaint();
                        }
                    });
                }
            }
        });
        this.localmodpacks.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                ModpackScene.this.localmodpacks.addActionListener(modpackListener);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ModpackScene.this.localmodpacks.removeActionListener(modpackListener);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                ModpackScene.this.localmodpacks.removeActionListener(modpackListener);
            }
        });
        this.manager.addGameListener(GameType.MOD, this.modLeftPanel);
        this.manager.addGameListener(GameType.MOD, this.modsPanel);
        this.manager.addGameListener(GameType.RESOURCEPACK, this.resourceLeftPanel);
        this.manager.addGameListener(GameType.RESOURCEPACK, this.resourcePackPanel);
        this.manager.addGameListener(GameType.MAP, this.mapLeftPanel);
        this.manager.addGameListener(GameType.MAP, this.mapsPanel);
        this.manager.addGameListener(GameType.MODPACK, this.localmodpacks);
        this.manager.addGameListener(GameType.MODPACK, this.modpacksPanel);
    }

    public static ScrollPane createScrollWrapper(JComponent panel) {
        ScrollPane pane = new ScrollPane((Component)panel, ScrollPane.ScrollBarPolicy.AS_NEEDED, ScrollPane.ScrollBarPolicy.NEVER);
        pane.getVerticalScrollBar().setUnitIncrement(30);
        pane.getVerticalScrollBar().setPreferredSize(new Dimension(13, 0));
        pane.setPreferredSize(new Dimension(200, 100));
        pane.getVerticalScrollBar().setUI(new ModpackScrollBarUI());
        pane.setBorder(BorderFactory.createEmptyBorder());
        return pane;
    }

    private void setSorters() {
        for (GameType type : GAME_TYPES) {
            GameEntityRightPanel panel = this.getRightPanelByType(type);
            TableRowSorter<RightTableModel> sorter = new TableRowSorter<RightTableModel>((RightTableModel)panel.getModel());
            sorter.setComparator(0, new UserCategoryComparator((UserCategory)((Object)this.sortBox.getSelectedItem())));
            ArrayList<RowSorter.SortKey> key = new ArrayList<RowSorter.SortKey>();
            key.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            sorter.setSortKeys(key);
            panel.setRowSorter(sorter);
            sorter.sort();
        }
        this.getRightPanelByType(this.current).editCellAt(0, 0);
    }

    private void createTextField(LocalizableTextField search, final DeferredDocumentListener listener) {
        search.getDocument().addDocumentListener(listener);
        search.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                listener.start();
            }

            @Override
            public void focusLost(FocusEvent e) {
                listener.stop();
            }
        });
    }

    public void prepareView(InfoMod infoMod, List<CompleteVersion> modpackVersions) {
        SwingUtilities.invokeLater(() -> {
            U.debug("prepare view modpack");
            this.prepareLocalModpack(modpackVersions);
            U.debug("prepared local modpack");
            for (GameType type : GAME_TYPES) {
                this.getRightPanelByType(type).addElements(infoMod.getByType(type), type);
            }
            this.setSorters();
            this.setDefault();
            U.debug("fill view by game entities ");
            U.gc();
        });
    }

    private void changeEntityView(GameType gameType) {
        if (this.last == GameType.MODPACK && gameType != GameType.MODPACK) {
            ((CardLayout)this.layoutCenterPanel.getLayout()).show(this.layoutCenterPanel, GameType.NOT_MODPACK.toString());
        } else if (gameType == GameType.MODPACK) {
            ((CardLayout)this.layoutCenterPanel.getLayout()).show(this.layoutCenterPanel, GameType.MODPACK.toString());
            this.last = gameType;
            return;
        }
        this.last = this.current;
        ((CardLayout)this.entitiesPanel.getLayout()).show(this.entitiesPanel, gameType.toString());
    }

    private GameEntityRightPanel getRightPanelByType(GameType type) {
        switch (type) {
            case MOD: {
                return this.modsPanel;
            }
            case MAP: {
                return this.mapsPanel;
            }
            case RESOURCEPACK: {
                return this.resourcePackPanel;
            }
            case MODPACK: {
                return this.modpacksPanel;
            }
        }
        throw new NullPointerException();
    }

    private void fillLeftPanel() {
        if (this.current == GameType.MODPACK) {
            return;
        }
        if (this.localmodpacks.getSelectedIndex() < 1) {
            this.getLeftPanelByType(this.current).cleanLeftPanel();
            this.getLeftPanelByType(this.current).fireCounterChanged();
        } else {
            this.manager.checkFolderSubGameEntity((CompleteVersion)this.localmodpacks.getSelectedValue(), this.current);
            ModpackVersionDTO version = (ModpackVersionDTO)((CompleteVersion)this.localmodpacks.getSelectedValue()).getModpack().getVersion();
            this.getLeftPanelByType(this.current).addElements(version.getByType(this.current), this.current);
        }
        this.getLeftPanelByType(this.current).revalidate();
        this.getLeftPanelByType(this.current).repaint();
    }

    private GameEntityLeftPanel getLeftPanelByType(GameType type) {
        switch (type) {
            case MOD: {
                return this.modLeftPanel;
            }
            case MAP: {
                return this.mapLeftPanel;
            }
            case RESOURCEPACK: {
                return this.resourceLeftPanel;
            }
        }
        throw new NullPointerException();
    }

    @Override
    public void onResize() {
        super.onResize();
        this.panel.setLocation(this.getWidth() / 2 - this.panel.getWidth() / 2, (this.getHeight() - LoginForm.LOGIN_SIZE.height) / 2 - this.panel.getHeight() / 2);
    }

    public void prepareLocalModpack(List<CompleteVersion> modpackVersions) {
        int index = TLauncher.getInstance().getConfiguration().getInteger("modpack.combobox.index");
        this.localmodpacks.removeAllItems();
        for (CompleteVersion v : modpackVersions) {
            this.localmodpacks.addItem(v);
        }
        if (this.localmodpacks.getModel().getSize() > index) {
            this.localmodpacks.setSelectedIndex(index);
        }
    }

    @Override
    public void setShown(boolean shown, boolean animate) {
        if (shown) {
            this.localmodpacks.addItemListener(this.modpackBoxListener);
        } else {
            this.localmodpacks.removeItemListener(this.modpackBoxListener);
        }
        super.setShown(shown, animate);
    }

    public void setDefault() {
        this.modpacks.setSelected(true);
        this.current = GameType.MODPACK;
        this.last = GameType.MODPACK;
        this.categoriesBox.setModel(new DefaultComboBoxModel<Category>(Category.getCategories(this.current)));
        this.prepareRightPanel();
    }

    @Override
    public void setShown(boolean shown) {
        super.setShown(shown);
    }

    public CompleteVersion getSelectedCompleteVersion() {
        return (CompleteVersion)this.localmodpacks.getSelectedValue();
    }

    public boolean isSelectedCompleteVersion() {
        return this.localmodpacks.getSelectedIndex() > 0;
    }

    public CompleteVersion getCompleteVersion(ModpackDTO dto, VersionDTO versionDTO) {
        return this.localmodpacks.findByModpack(dto, versionDTO);
    }

    private void prepareRightPanel() {
        this.getRightPanelByType(this.current).filterRightPanel(this.current);
        this.fillLeftPanel();
        this.changeEntityView(this.current);
    }

    public GameType getCurrent() {
        return this.current;
    }

    @Override
    public void onMinecraftPrepare() {
    }

    @Override
    public void onMinecraftAbort() {
    }

    @Override
    public void onMinecraftLaunch() {
    }

    @Override
    public void onMinecraftClose() {
        if (this.current != GameType.MODPACK) {
            this.fillLeftPanel();
        }
    }

    @Override
    public void onMinecraftError(Throwable e) {
    }

    @Override
    public void onMinecraftKnownError(MinecraftException e) {
    }

    @Override
    public void onMinecraftCrash(Crash crash) {
    }

    class GameEntityLeftPanel
    extends GameEntityPanel {
        private List<ElementCounterListener> observer;

        public GameEntityLeftPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.observer = new ArrayList<ElementCounterListener>();
        }

        public void addElements(List<? extends SubModpackDTO> list, GameType type) {
            this.cleanLeftPanel();
            for (SubModpackDTO subModpackDTO : list) {
                this.add((Component)new GameLeftElement(subModpackDTO, type));
            }
            this.fireCounterChanged();
        }

        protected void cleanLeftPanel() {
            for (Component c : Arrays.asList(this.getComponents())) {
                if (!(c instanceof GameLeftElement)) continue;
                this.remove(c);
            }
        }

        @Override
        public void activationStarted(GameEntityDTO e) {
            for (Component c : Arrays.asList(this.getComponents())) {
                if (!(c instanceof GameLeftElement)) continue;
                ((GameLeftElement)c).processingActivation();
            }
        }

        @Override
        public void removeEntity(GameEntityDTO e) {
            GameLeftElement elem = this.find(e);
            if (elem != null) {
                this.remove(elem);
                this.revalidate();
                this.repaint();
            }
            this.fireCounterChanged();
        }

        @Override
        public void activation(GameEntityDTO e) {
            for (Component c : Arrays.asList(this.getComponents())) {
                if (!(c instanceof GameLeftElement)) continue;
                ((GameLeftElement)c).initGameEntity();
            }
        }

        @Override
        public void activationError(GameEntityDTO e, Throwable t) {
            for (Component c : Arrays.asList(this.getComponents())) {
                if (!(c instanceof GameLeftElement)) continue;
                ((GameLeftElement)c).initGameEntity();
            }
        }

        private GameLeftElement find(GameEntityDTO e) {
            for (Component c : Arrays.asList(this.getComponents())) {
                GameLeftElement el;
                if (!(c instanceof GameLeftElement) || !(el = (GameLeftElement)c).getEntity().getId().equals(e.getId())) continue;
                return el;
            }
            return null;
        }

        @Override
        public void installEntity(GameEntityDTO e, GameType type) {
            this.add((Component)new GameLeftElement((SubModpackDTO)e, type));
            this.revalidate();
            this.repaint();
            this.fireCounterChanged();
        }

        public void fireCounterChanged() {
            for (ElementCounterListener el : this.observer) {
                el.changeCounter(this.getComponentCount());
            }
        }

        public void addCounterListener(ElementCounterListener l) {
            this.observer.add(l);
        }
    }

    class UserCategoryComparator
    implements Comparator<GameEntityDTO> {
        private UserCategory category;

        public UserCategoryComparator(UserCategory category) {
            this.category = category;
        }

        @Override
        public int compare(GameEntityDTO o1, GameEntityDTO o2) {
            switch (this.category) {
                case NAME: {
                    return o1.getName().compareTo(o2.getName());
                }
                case FAVORITE: {
                    if (o1.isPopulateStatus()) {
                        if (o2.isPopulateStatus()) {
                            return 0;
                        }
                        return -1;
                    }
                    if (o2.isPopulateStatus()) {
                        return 1;
                    }
                    return 0;
                }
                case POPULATE_ALL_TIME: {
                    return o2.getDownloadALL().compareTo(o1.getDownloadALL());
                }
                case POPULATE_MONTH: {
                    return o2.getDownloadMonth().compareTo(o1.getDownloadMonth());
                }
                case DATE: {
                    return o2.getVersions().get(0).getUpdateDate().compareTo(o1.getVersions().get(0).getUpdateDate());
                }
            }
            return 0;
        }
    }

    public class SearchPanel
    extends JPanel {
        private final LocalizableTextField field;

        public SearchPanel() {
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(194, 55));
            SpringLayout spring = new SpringLayout();
            this.setLayout(spring);
            this.field = new LocalizableTextField("modpack.search.text"){

                public void setBackColor() {
                    if (!OS.is(OS.LINUX)) {
                        this.setForeground(Color.WHITE);
                    }
                }

                @Override
                protected void onFocusLost() {
                    super.onFocusLost();
                    this.setBackColor();
                }

                @Override
                protected void onFocusGained() {
                    super.onFocusGained();
                    this.setBackColor();
                }

                @Override
                public void updateLocale() {
                    super.updateLocale();
                    this.setBackColor();
                }
            };
            this.field.setOpaque(false);
            this.field.setBorder(BorderFactory.createEmptyBorder());
            this.field.setCaretColor(Color.WHITE);
            if (!OS.is(OS.LINUX)) {
                SwingUtil.changeFontFamily(this.field, FontTL.ROBOTO_REGULAR, 14, Color.WHITE);
            }
            spring.putConstraint("West", (Component)this.field, 17, "West", (Component)this);
            spring.putConstraint("East", (Component)this.field, -50, "East", (Component)this);
            spring.putConstraint("North", (Component)this.field, 17, "North", (Component)this);
            spring.putConstraint("South", (Component)this.field, -20, "South", (Component)this);
            this.add(this.field);
            Color lineYellow = new Color(254, 254, 168);
            JPanel linePanel = new JPanel();
            linePanel.setBackground(lineYellow);
            spring.putConstraint("West", (Component)linePanel, 17, "West", (Component)this);
            spring.putConstraint("East", (Component)linePanel, -17, "East", (Component)this);
            spring.putConstraint("North", (Component)linePanel, -12, "South", (Component)this);
            spring.putConstraint("South", (Component)linePanel, -11, "South", (Component)this);
            this.add(linePanel);
            JLabel image = new JLabel(ImageCache.getNativeIcon((String)"search-modpack-element.png"));
            spring.putConstraint("West", (Component)image, -35, "East", (Component)this);
            spring.putConstraint("East", (Component)image, -19, "East", (Component)this);
            spring.putConstraint("North", (Component)image, 18, "North", (Component)this);
            spring.putConstraint("South", (Component)image, -21, "South", (Component)this);
            this.add(image);
            DeferredDocumentListener listener = new DeferredDocumentListener(500, e -> {
                if (ModpackScene.this.isVisible()) {
                    ModpackScene.this.getRightPanelByType(ModpackScene.this.current).filterRightPanel(ModpackScene.this.current);
                }
            }, false);
            ModpackScene.this.createTextField(this.field, listener);
        }

        public boolean isNotEmpty() {
            return this.field.getValue() != null && !this.field.getValue().isEmpty();
        }

        public String getSearchLine() {
            return this.field.getValue();
        }
    }

    class GameLeftElement
    extends ExtendedPanel
    implements UpdateGameListener {
        private final JLabel name = new JLabel();
        private final StateModpackElementButton clickButton;
        private final Dimension DEFAULT_SIZE = new Dimension(LEFT_WIDTH, 39);
        private final Color MOUSE_UNDER_BACKGROUND = new Color(242, 242, 242);
        private final Color BACKGROUND_COLOR = new Color(235, 235, 235);
        private SubModpackDTO entity;
        private GameType type;
        private JLabel leftLabel;

        public GameLeftElement(SubModpackDTO e, final GameType type) {
            this.type = type;
            this.setPreferredSize(this.DEFAULT_SIZE);
            this.setMaximumSize(this.DEFAULT_SIZE);
            this.setMinimumSize(this.DEFAULT_SIZE);
            this.setLayout(new BorderLayout());
            this.entity = e;
            SpringLayout layout = new SpringLayout();
            ExtendedPanel wrapperEast = new ExtendedPanel(layout);
            wrapperEast.setPreferredSize(new Dimension(67, 39));
            this.clickButton = new StateModpackElementButton(e, type);
            this.leftLabel = this.entity.isUserInstall() ? new JLabel((Icon)ImageCache.getIcon((String)"modpack-element-left-hanlde.png")) : new JLabel((Icon)ImageCache.getIcon((String)"modpack-element-left.png"));
            layout.putConstraint("West", (Component)this.clickButton, 0, "West", (Component)wrapperEast);
            layout.putConstraint("East", (Component)this.clickButton, -16, "East", (Component)wrapperEast);
            layout.putConstraint("North", (Component)this.clickButton, 10, "North", (Component)wrapperEast);
            layout.putConstraint("South", (Component)this.clickButton, -9, "South", (Component)wrapperEast);
            ((Container)wrapperEast).add(this.clickButton);
            this.leftLabel.setPreferredSize(new Dimension(39, 29));
            this.add((Component)this.leftLabel, "West");
            final Border nameBorder = BorderFactory.createEmptyBorder(10, 1, 10, 1);
            this.name.setBorder(nameBorder);
            this.add((Component)this.name, "Center");
            if (GameType.MAP != type) {
                this.add((Component)wrapperEast, "East");
            }
            this.initGameEntity();
            this.setOpaque(true);
            SwingUtil.changeFontFamily(this.name, FontTL.ROBOTO_BOLD, 14, ColorUtil.COLOR_16);
            MouseAdapter click = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        ModpackPopup popupMenu = new ModpackPopup();
                        ModpackPopup.ModpackMenuItem delete = new ModpackPopup.ModpackMenuItem("modpack.popup.delete");
                        popupMenu.add(delete);
                        delete.addActionListener(e1 -> {
                            popupMenu.setVisible(false);
                            List<GameEntityDTO> list = ModpackScene.this.manager.findDependenciesFromGameEntityDTO(GameLeftElement.this.entity);
                            StringBuilder b = ModpackUtil.buildMessage(list);
                            if (list.isEmpty()) {
                                ModpackScene.this.manager.removeEntity(GameLeftElement.this.entity, GameLeftElement.this.entity.getVersion(), type, false);
                            } else if (Alert.showQuestion("", Localizable.get("modpack.left.element.remove.question", GameLeftElement.this.entity.getName(), b.toString()))) {
                                ModpackScene.this.manager.removeEntity(GameLeftElement.this.entity, GameLeftElement.this.entity.getVersion(), type, false);
                            }
                        });
                        popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    } else {
                        if (GameLeftElement.this.entity.isUserInstall()) {
                            return;
                        }
                        ModpackScene.this.manager.showFullGameEntity(GameLeftElement.this.entity, type);
                    }
                }
            };
            MouseAdapter backgroundListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    GameLeftElement.this.setBackground(GameLeftElement.this.MOUSE_UNDER_BACKGROUND);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    GameLeftElement.this.setBackground(GameLeftElement.this.BACKGROUND_COLOR);
                }
            };
            final AtomicInteger padding = new AtomicInteger();
            final Timer timer = new Timer(30, e12 -> {
                int width = this.name.getWidth();
                if (padding.get() + width < 0) {
                    padding.set(width - 20);
                }
                this.name.setBorder(new EmptyBorder(0, padding.getAndDecrement(), 0, 0));
            });
            this.name.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    padding.set(0);
                    if (((GameLeftElement)GameLeftElement.this).name.getPreferredSize().width > 120) {
                        timer.restart();
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    timer.stop();
                    GameLeftElement.this.name.setBorder(nameBorder);
                }
            });
            this.addMouseListenerOriginally(click);
            this.name.addMouseListener(click);
            this.leftLabel.addMouseListener(click);
            this.addMouseListener(backgroundListener);
            this.addMouseListenerOriginally(backgroundListener);
        }

        @Override
        public void initGameEntity() {
            this.name.setText(this.entity.getName());
            if (this.type != GameType.MAP) {
                this.clickButton.setState(this.entity.getStateGameElement());
            }
        }

        @Override
        public void processingActivation() {
        }

        @Override
        public void processingInstall() {
        }

        private GameLeftElement find(GameEntityDTO e) {
            for (Component c : Arrays.asList(this.getComponents())) {
                GameLeftElement el;
                if (!(c instanceof GameLeftElement) || !(el = (GameLeftElement)c).getEntity().getId().equals(e.getId())) continue;
                return el;
            }
            return null;
        }

        public SubModpackDTO getEntity() {
            return this.entity;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Rectangle rec = this.getVisibleRect();
            SwingUtil.paintShadowLine(rec, g, this.getBackground().getRed(), 12);
        }
    }

    class GameCenterPanel
    extends ExtendedPanel {
        Color color241 = new Color(241, 241, 241);
        private String COLLAPSE = "0";
        private String NOT_COLLAPSE = "1";

        public GameCenterPanel(GameEntityLeftPanel leftEntityPanel, final GameEntityRightPanel rightPanel, GameType gameType) {
            this.setLayout(new BorderLayout(0, 0));
            ShadowButton collapse = new ShadowButton(this.color241, ColorUtil.COLOR_215, "modpack.element.collapse", "left-array-collapse.png");
            collapse.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 0));
            collapse.setPreferredSize(new Dimension(LEFT_WIDTH, 39));
            collapse.setIconTextGap(15);
            collapse.setForeground(Color.BLACK);
            ImageUdaterButton unCollapse = new ImageUdaterButton(new Color(200, 200, 200), new Color(200, 200, 200), "un-collapse-arrow.png", "un-collapse-arrow-up.png");
            JPanel leftPanel = new JPanel(new BorderLayout());
            leftPanel.setBackground(Color.WHITE);
            JPanel search = new JPanel(new BorderLayout());
            search.setBackground(Color.WHITE);
            LocalizableTextField field = new LocalizableTextField("modpack.search.textfield." + gameType.toString()){

                @Override
                protected void onFocusLost() {
                    super.onFocusLost();
                    this.setForeground(Color.BLACK);
                }

                @Override
                protected void onFocusGained() {
                    super.onFocusGained();
                    this.setForeground(Color.BLACK);
                }

                @Override
                public void updateLocale() {
                    super.updateLocale();
                    this.setForeground(Color.BLACK);
                }
            };
            JLabel searchLabel = new JLabel(ImageCache.getNativeIcon((String)"search-left-panel.png"));
            searchLabel.setPreferredSize(new Dimension(38, 38));
            search.setPreferredSize(new Dimension(0, 38));
            field.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 7));
            search.add((Component)field, "Center");
            search.add((Component)searchLabel, "West");
            leftPanel.add((Component)search, "North");
            CardLayout emptyLayout = new CardLayout();
            ExtendedPanel emptyPanel = new ExtendedPanel(emptyLayout);
            emptyPanel.add((Component)new EmptyGameEntityView(gameType), EMPTY);
            ScrollPane pane = ModpackScene.createScrollWrapper(leftEntityPanel);
            pane.setPreferredSize(new Dimension(LEFT_WIDTH, this.getPreferredSize().height));
            emptyPanel.add((Component)pane, NOT_EMPTY);
            leftEntityPanel.addCounterListener(currentCounter -> {
                if (currentCounter == 0) {
                    emptyLayout.show(emptyPanel, EMPTY);
                } else {
                    emptyLayout.show(emptyPanel, NOT_EMPTY);
                }
            });
            leftEntityPanel.fireCounterChanged();
            leftPanel.add((Component)emptyPanel, "Center");
            leftPanel.add((Component)collapse, "South");
            final CardLayout card = new CardLayout();
            final JPanel leftCenterPanel = new JPanel(card);
            leftCenterPanel.setPreferredSize(new Dimension(LEFT_WIDTH, 0));
            leftCenterPanel.add((Component)leftPanel, this.NOT_COLLAPSE);
            leftCenterPanel.add((Component)unCollapse, this.COLLAPSE);
            this.add((Component)leftCenterPanel, "West");
            SwingUtil.changeFontFamily(field, FontTL.ROBOTO_REGULAR, 14, new Color(16, 16, 16));
            SwingUtil.changeFontFamily(collapse, FontTL.ROBOTO_BOLD, 14);
            CardLayout emptyRightLayout = new CardLayout();
            ExtendedPanel emptyRightPanel = new ExtendedPanel(emptyRightLayout);
            EmptyRightView emptyRightView = new EmptyRightView(gameType);
            emptyRightPanel.add((Component)emptyRightView, EMPTY);
            emptyRightPanel.add((Component)rightPanel, NOT_EMPTY);
            this.add((Component)ModpackScene.createScrollWrapper(emptyRightPanel), "Center");
            card.show(leftCenterPanel, this.NOT_COLLAPSE);
            DeferredDocumentListener listener = new DeferredDocumentListener(500, e -> {
                if (ModpackScene.this.localmodpacks.getSelectedIndex() > 0) {
                    List<? extends GameEntityDTO> list = ((ModpackVersionDTO)((CompleteVersion)ModpackScene.this.localmodpacks.getSelectedValue()).getModpack().getVersion()).getByType(gameType);
                    String text = field.getValue();
                    if (text == null || text.isEmpty()) {
                        leftEntityPanel.addElements(list, gameType);
                    } else {
                        List<? extends GameEntityDTO> res = new BaseModpackFilter<GameEntityDTO>(new NameFilter(text)).findAll(list);
                        leftEntityPanel.addElements(res, gameType);
                    }
                    leftEntityPanel.revalidate();
                    leftEntityPanel.repaint();
                }
            }, false);
            collapse.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        card.show(leftCenterPanel, GameCenterPanel.this.COLLAPSE);
                        leftCenterPanel.setPreferredSize(new Dimension(30, 0));
                        rightPanel.setPreferredSize(new Dimension(ModpackScene.SIZE.width - 30, rightPanel.getHeight()));
                    }
                }
            });
            ModpackScene.this.createTextField(field, listener);
            unCollapse.addActionListener(e -> {
                card.show(leftCenterPanel, this.NOT_COLLAPSE);
                leftCenterPanel.setPreferredSize(new Dimension(LEFT_WIDTH, 0));
                rightPanel.setPreferredSize(new Dimension(RIGHT_WIDTH, rightPanel.getHeight()));
                rightPanel.revalidate();
                rightPanel.repaint();
            });
            ModpackScene.this.localmodpacks.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    if (ModpackScene.this.current != GameType.MODPACK) {
                        ModpackScene.this.prepareRightPanel();
                    }
                    emptyRightView.updateText();
                }
            });
        }

        private class EmptyGameEntityView
        extends ExtendedPanel
        implements LocalizableComponent {
            private JLabel notHaveSumEntities;
            private JLabel intallThem;
            private GameType gameType;

            public EmptyGameEntityView(GameType gameType) {
                this.gameType = gameType;
                this.setLayout(new FlowLayout(0, 0, 0));
                JLabel image = new JLabel((Icon)ImageCache.getIcon((String)"empty-left-panel.png", (int)225, (int)165));
                image.setHorizontalAlignment(0);
                this.notHaveSumEntities = new LocalizableLabel("modpack.left.empty.mod.label." + gameType.toString());
                this.intallThem = new LocalizableLabel("modpack.left.fast.install");
                this.notHaveSumEntities.setHorizontalAlignment(0);
                this.intallThem.setHorizontalAlignment(0);
                this.notHaveSumEntities.setVerticalAlignment(3);
                this.intallThem.setVerticalAlignment(1);
                this.notHaveSumEntities.setPreferredSize(new Dimension(LEFT_WIDTH, 40));
                this.intallThem.setPreferredSize(new Dimension(LEFT_WIDTH, 40));
                SwingUtil.changeFontFamily(this.notHaveSumEntities, FontTL.ROBOTO_BOLD, 14);
                SwingUtil.changeFontFamily(this.intallThem, FontTL.ROBOTO_BOLD, 14);
                this.setBorder(BorderFactory.createEmptyBorder(80, 0, 0, 0));
                this.add((Component)image);
                this.add((Component)this.notHaveSumEntities);
                this.add((Component)this.intallThem);
            }

            @Override
            public void updateLocale() {
                this.notHaveSumEntities.setText("modpack.left.empty.mod.label." + this.gameType.toString());
                this.intallThem.setText("modpack.left.fast.install");
            }
        }
    }

    private class EmptyRightView
    extends ExtendedPanel {
        LocalizableHTMLLabel jLabel;
        private GameType gameType;

        public EmptyRightView(GameType gameType) {
            this.gameType = gameType;
            this.setLayout(new BorderLayout());
            this.jLabel = new LocalizableHTMLLabel(""){

                @Override
                public void updateLocale() {
                    EmptyRightView.this.updateText();
                }
            };
            this.jLabel.setHorizontalAlignment(0);
            this.jLabel.setAlignmentY(0.0f);
            SwingUtil.setFontSize(this.jLabel, 18.0f, 1);
            this.add((Component)this.jLabel, "Center");
            this.updateText();
        }

        public void updateText() {
            String value = Localizable.get("modpack.criteria.not.found." + (Object)((Object)this.gameType));
            String additional = "";
            if (!this.gameType.equals((Object)GameType.MODPACK) && ModpackScene.this.localmodpacks.getSelectedIndex() > 0) {
                additional = Localizable.get("modpack.search.without.modpack", Localizable.get("modpack.local.box.default"));
            }
            String text = value + additional;
            this.jLabel.setText(String.format("<div WIDTH=%d><center>%s</center></div>", 600, text));
        }
    }

    static interface ElementCounterListener {
        public void changeCounter(int var1);
    }

    public static enum UserCategory {
        POPULATE_MONTH,
        FAVORITE,
        NAME,
        POPULATE_ALL_TIME,
        DATE;

    }
}

