/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.configuration.LangConfiguration;
import org.tlauncher.tlauncher.configuration.enums.ActionOnLaunch;
import org.tlauncher.tlauncher.configuration.enums.ConnectionQuality;
import org.tlauncher.tlauncher.configuration.enums.ConsoleType;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.converter.ActionOnLaunchConverter;
import org.tlauncher.tlauncher.ui.converter.ConnectionQualityConverter;
import org.tlauncher.tlauncher.ui.converter.ConsoleTypeConverter;
import org.tlauncher.tlauncher.ui.converter.LocaleConverter;
import org.tlauncher.tlauncher.ui.editor.EditorCheckBox;
import org.tlauncher.tlauncher.ui.editor.EditorComboBox;
import org.tlauncher.tlauncher.ui.editor.EditorFieldChangeListener;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.tlauncher.ui.settings.HandlerSettings;
import org.tlauncher.tlauncher.ui.settings.PageSettings;
import org.tlauncher.tlauncher.ui.settings.ResetView;
import org.tlauncher.tlauncher.ui.settings.SettingElement;
import org.tlauncher.tlauncher.ui.swing.scroll.VersionScrollBarUI;
import org.tlauncher.tlauncher.ui.ui.TlauncherBasicComboBoxUI;
import org.tlauncher.util.OS;
import org.tlauncher.util.SwingUtil;

public class TlauncherSettings
extends PageSettings {
    public final TLauncher tlauncher = TLauncher.getInstance();
    public final Configuration global = this.tlauncher.getConfiguration();
    public final LangConfiguration lang = this.tlauncher.getLang();
    private EditorComboBox<Locale> local;

    public TlauncherSettings() {
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        EditorComboBox<ConsoleType> consoleConverter = new EditorComboBox<ConsoleType>(new ConsoleTypeConverter(), ConsoleType.values());
        EditorCheckBox fullCommand = new EditorCheckBox("settings.console.fullcommand");
        EditorCheckBox statistics = new EditorCheckBox("statistics.settings.checkbox.name");
        EditorCheckBox guard = new EditorCheckBox("settings.guard");
        EditorCheckBox recommendedServers = new EditorCheckBox("settings.servers.recommendation");
        JLabel questionLabel = new JLabel(ImageCache.getNativeIcon((String)"qestion-option-panel.png"));
        EditorComboBox<ConnectionQuality> connQuality = new EditorComboBox<ConnectionQuality>(new ConnectionQualityConverter(), ConnectionQuality.values());
        EditorComboBox<ActionOnLaunch> launchAction = new EditorComboBox<ActionOnLaunch>(new ActionOnLaunchConverter(), ActionOnLaunch.values());
        this.local = new EditorComboBox<Locale>(new LocaleConverter(), this.global.getLocales());
        TlauncherSettings.setTLauncherBasicComboBoxUI(consoleConverter);
        TlauncherSettings.setTLauncherBasicComboBoxUI(connQuality);
        TlauncherSettings.setTLauncherBasicComboBoxUI(launchAction);
        TlauncherSettings.setTLauncherBasicComboBoxUI(this.local);
        SettingElement settingElement = new SettingElement("settings.console.label", consoleConverter, 21);
        springLayout.putConstraint("North", (Component)settingElement, 0, "North", (Component)this);
        springLayout.putConstraint("West", (Component)settingElement, 0, "West", (Component)this);
        springLayout.putConstraint("South", (Component)settingElement, 21, "North", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement, 0, "East", (Component)this);
        this.add((Component)settingElement);
        SettingElement settingElement_1 = new SettingElement("settings.console.fullcommand.label", fullCommand, 17, -1);
        springLayout.putConstraint("North", (Component)settingElement_1, 21, "South", (Component)settingElement);
        springLayout.putConstraint("West", (Component)settingElement_1, 0, "West", (Component)this);
        springLayout.putConstraint("South", (Component)settingElement_1, 36, "South", (Component)settingElement);
        springLayout.putConstraint("East", (Component)settingElement_1, 0, "East", (Component)this);
        this.add((Component)settingElement_1);
        SettingElement settingElement_2 = new SettingElement("statistics.settings.title", statistics, 17, -1);
        springLayout.putConstraint("North", (Component)settingElement_2, 19, "South", (Component)settingElement_1);
        springLayout.putConstraint("West", (Component)settingElement_2, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement_2, 0, "East", (Component)this);
        springLayout.putConstraint("South", (Component)settingElement_2, 38, "South", (Component)settingElement_1);
        this.add((Component)settingElement_2);
        SettingElement settingElement_guard = new SettingElement("settings.guard.title", guard, 19, -1, questionLabel);
        questionLabel.setBounds(0, 0, 20, 19);
        springLayout.putConstraint("North", (Component)settingElement_guard, 15, "South", (Component)settingElement_2);
        springLayout.putConstraint("West", (Component)settingElement_guard, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement_guard, 0, "East", (Component)this);
        springLayout.putConstraint("South", (Component)settingElement_guard, 38, "South", (Component)settingElement_2);
        this.add((Component)settingElement_guard);
        SettingElement settingElement_servers = new SettingElement("settings.servers.recommendation.title", recommendedServers, 19, -1);
        springLayout.putConstraint("North", (Component)settingElement_servers, 15, "South", (Component)settingElement_guard);
        springLayout.putConstraint("West", (Component)settingElement_servers, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement_servers, 0, "East", (Component)this);
        this.add((Component)settingElement_servers);
        SettingElement settingElement_3 = new SettingElement("settings.connection.label", connQuality, 21);
        springLayout.putConstraint("North", (Component)settingElement_3, 20, "South", (Component)settingElement_servers);
        springLayout.putConstraint("West", (Component)settingElement_3, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement_3, 0, "East", (Component)this);
        this.add((Component)settingElement_3);
        SettingElement settingElement_4 = new SettingElement("settings.launch-action.label", launchAction, 21);
        springLayout.putConstraint("North", (Component)settingElement_4, 19, "South", (Component)settingElement_3);
        springLayout.putConstraint("West", (Component)settingElement_4, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement_4, 0, "East", (Component)this);
        this.add((Component)settingElement_4);
        SettingElement settingElement_5 = new SettingElement("settings.lang.label", this.local, 21);
        springLayout.putConstraint("North", (Component)settingElement_5, 21, "South", (Component)settingElement_4);
        springLayout.putConstraint("West", (Component)settingElement_5, 0, "West", (Component)settingElement);
        springLayout.putConstraint("East", (Component)settingElement_5, 0, "East", (Component)settingElement);
        this.add((Component)settingElement_5);
        UpdaterButton reset = new UpdaterButton(new Color(222, 64, 43), new Color(222, 31, 8), Color.WHITE, "settings.reset.button");
        SwingUtil.setFontSize(reset, 13.0f, 1);
        springLayout.putConstraint("North", (Component)reset, 19, "South", (Component)settingElement_5);
        springLayout.putConstraint("South", (Component)reset, 45, "South", (Component)settingElement_5);
        springLayout.putConstraint("West", (Component)reset, 0, "West", (Component)settingElement);
        springLayout.putConstraint("East", (Component)reset, 178, "West", (Component)settingElement);
        this.add((Component)reset);
        EditorFieldChangeListener changeListener = new EditorFieldChangeListener(){

            @Override
            public void onChange(String oldvalue, String newvalue) {
                if (ConsoleType.get(newvalue) == null) {
                    return;
                }
                switch (ConsoleType.get(newvalue)) {
                    case GLOBAL: {
                        TLauncher.getConsole().show(false);
                        break;
                    }
                    case MINECRAFT: 
                    case NONE: {
                        TLauncher.getConsole().hide();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown console type!");
                    }
                }
            }
        };
        EditorFieldChangeListener conQualityListener = new EditorFieldChangeListener(){

            @Override
            public void onChange(String oldValue, String newValue) {
                TlauncherSettings.this.tlauncher.getDownloader().setConfiguration(TlauncherSettings.this.global.getConnectionQuality());
            }
        };
        EditorFieldChangeListener localeListener = new EditorFieldChangeListener(){

            @Override
            public void onChange(String oldvalue, String newvalue) {
                if (TlauncherSettings.this.tlauncher.getFrame() != null) {
                    TlauncherSettings.this.tlauncher.getFrame().updateLocales();
                }
            }
        };
        this.addHandler(new HandlerSettings("gui.console", consoleConverter, changeListener));
        this.addHandler(new HandlerSettings("gui.console.fullcommand", fullCommand));
        this.addHandler(new HandlerSettings("gui.statistics.checkbox", statistics));
        this.addHandler(new HandlerSettings("gui.settings.guard.checkbox", guard));
        this.addHandler(new HandlerSettings("gui.settings.servers.recommendation", recommendedServers));
        this.addHandler(new HandlerSettings("connection", connQuality, conQualityListener));
        this.addHandler(new HandlerSettings("minecraft.onlaunch", launchAction));
        this.addHandler(new HandlerSettings("locale", this.local, localeListener));
        reset.addActionListener(e -> {
            ResetView view = new ResetView();
            Alert.showMessage(Localizable.get("settings.reset.button"), view, new JButton[]{view.getResetAgain()});
        });
        questionLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    String url = String.format("https://tlauncher.org/%s/guard.html", TLauncher.getInstance().getConfiguration().isUSSRLocale() ? "ru" : "en");
                    OS.openLink(url);
                }
            }
        });
        ActionListener l = e -> {
            if (!this.tlauncher.getProfileManager().hasPremium()) {
                ((JCheckBox)e.getSource()).setSelected(true);
                Alert.showHtmlMessage("", Localizable.get("account.premium.not.available"), 1, 400);
            }
        };
        recommendedServers.addActionListener(l);
        guard.addActionListener(l);
    }

    private static <T> void setTLauncherBasicComboBoxUI(JComboBox<T> comboBox) {
        comboBox.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(149, 149, 149)));
        comboBox.setUI(new TlauncherBasicComboBoxUI(){

            @Override
            protected ComboPopup createPopup() {
                BasicComboPopup basic = new BasicComboPopup(this.comboBox){

                    @Override
                    protected JScrollPane createScroller() {
                        VersionScrollBarUI barUI = new VersionScrollBarUI(){

                            @Override
                            protected Dimension getMinimumThumbSize() {
                                return new Dimension(10, 40);
                            }

                            @Override
                            public Dimension getMaximumSize(JComponent c) {
                                Dimension dim = super.getMaximumSize(c);
                                dim.setSize(10.0, dim.getHeight());
                                return dim;
                            }

                            @Override
                            public Dimension getPreferredSize(JComponent c) {
                                Dimension dim = super.getPreferredSize(c);
                                dim.setSize(13.0, dim.getHeight());
                                return dim;
                            }
                        };
                        barUI.setGapThubm(5);
                        JScrollPane scroller = new JScrollPane(this.list, 20, 31);
                        scroller.getVerticalScrollBar().setUI(barUI);
                        return scroller;
                    }
                };
                basic.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, Color.GRAY));
                return basic;
            }
        });
    }

    public boolean chooseChinaLocal() {
        return ((Locale)this.local.getSelectedValue()).getLanguage().equals(new Locale("zh").getLanguage()) || this.global.getLocale().getLanguage().equals(new Locale("zh").getLanguage());
    }
}

