/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.swing.progress;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JProgressBar;
import org.tlauncher.tlauncher.downloader.Downloadable;
import org.tlauncher.tlauncher.downloader.Downloader;
import org.tlauncher.tlauncher.downloader.DownloaderListener;
import org.tlauncher.tlauncher.minecraft.crash.Crash;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftException;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftExtendedListener;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableComponent;
import org.tlauncher.tlauncher.ui.progress.login.LauncherProgress;
import org.tlauncher.tlauncher.ui.progress.login.LauncherProgressListener;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;

public class ProgressBarPanel
extends JLayeredPane
implements LocalizableComponent,
DownloaderListener,
MinecraftExtendedListener,
LauncherProgressListener {
    public static final Dimension SIZE = new Dimension(1050, 24);
    private JProgressBar bar;
    private JLabel percentLabel;
    private JLabel centerLabel;
    private JLabel speedLabel;
    private JLabel fileLabel;
    private boolean downloadingStart;
    private ExtendedPanel upperPanel;

    public ProgressBarPanel(Icon speed, Icon file, LauncherProgress bar) {
        this.bar = bar;
        this.setVisible(false);
        this.upperPanel = new ExtendedPanel(new BorderLayout(0, 0));
        this.speedLabel = this.createLabel(speed);
        this.fileLabel = this.createLabel(file);
        this.percentLabel = this.createLabel(null);
        this.centerLabel = this.createLabel(null);
        this.centerLabel.setHorizontalAlignment(0);
        this.percentLabel.setFont(this.percentLabel.getFont().deriveFont(1));
        this.upperPanel.setPreferredSize(SIZE);
        this.upperPanel.setInsets(0, 20, 0, 20);
        this.setPreferredSize(SIZE);
        ExtendedPanel leftPanel = new ExtendedPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 0));
        leftPanel.add((Component)this.fileLabel);
        leftPanel.add(Box.createHorizontalStrut(15));
        leftPanel.add((Component)this.speedLabel);
        this.upperPanel.add((Component)this.centerLabel, "Center");
        this.upperPanel.add((Component)this.percentLabel, "East");
        this.upperPanel.add((Component)leftPanel, "West");
        this.add((Component)bar, 1);
        this.add((Component)this.upperPanel, 0);
        bar.setBounds(0, 0, ProgressBarPanel.SIZE.width, ProgressBarPanel.SIZE.height);
        this.upperPanel.setBounds(0, 0, ProgressBarPanel.SIZE.width, ProgressBarPanel.SIZE.height);
    }

    private JLabel createLabel(Icon icon) {
        JLabel jLabel = new JLabel();
        jLabel.setFont(jLabel.getFont().deriveFont(0, 12.0f));
        if (icon != null) {
            jLabel.setIcon(icon);
        }
        jLabel.setHorizontalTextPosition(4);
        return jLabel;
    }

    private void startProgress() {
        this.setVisible(true);
    }

    private void stopProgress() {
        this.setVisible(false);
        this.fileLabel.setVisible(false);
        this.speedLabel.setVisible(false);
        this.centerLabel.setVisible(false);
        this.bar.setValue(0);
        this.downloadingStart = true;
    }

    @Override
    public void updateLocale() {
    }

    @Override
    public void onDownloaderStart(Downloader d, int files) {
        this.startProgress();
        this.updateStateDownloading(d);
    }

    @Override
    public void onDownloaderAbort(Downloader d) {
        this.stopProgress();
    }

    @Override
    public void onDownloaderProgress(Downloader d, double progress, double speed) {
        this.updateStateDownloading(d);
    }

    @Override
    public void onDownloaderFileComplete(Downloader d, Downloadable file) {
        this.updateStateDownloading(d);
    }

    private void updateStateDownloading(Downloader d) {
        if (d.getProgress() > 0.0) {
            int dprogress = (int)(d.getProgress() * 100.0);
            if (this.bar.getValue() > dprogress) {
                return;
            }
            this.bar.setValue(dprogress);
            StringBuilder b = new StringBuilder();
            b.append(d.getRemaining()).append(" ").append(Localizable.get("progress.bar.panel.file"));
            this.fileLabel.setText(b.toString());
            b = new StringBuilder();
            b.append((int)d.getSpeed()).append(" ").append(Localizable.get("progress.bar.panel.speed"));
            this.speedLabel.setText(b.toString());
            this.percentLabel.setText(dprogress + "%");
            if (this.downloadingStart) {
                this.centerLabel.setVisible(false);
                this.fileLabel.setVisible(true);
                this.speedLabel.setVisible(true);
                this.downloadingStart = false;
            }
        }
    }

    @Override
    public void onDownloaderComplete(Downloader d) {
        this.stopProgress();
    }

    @Override
    public void onMinecraftPrepare() {
        this.clean();
        this.startProgress();
        this.centerLabel.setText(Localizable.get("progress.bar.panel.init"));
        this.centerLabel.setVisible(true);
        this.downloadingStart = true;
    }

    @Override
    public void onMinecraftAbort() {
        this.stopProgress();
    }

    @Override
    public void onMinecraftClose() {
    }

    @Override
    public void onMinecraftError(Throwable e) {
        this.stopProgress();
    }

    @Override
    public void onMinecraftKnownError(MinecraftException e) {
        this.stopProgress();
    }

    @Override
    public void onMinecraftCrash(Crash crash) {
    }

    @Override
    public void onMinecraftCollecting() {
    }

    @Override
    public void onMinecraftComparingAssets() {
    }

    @Override
    public void onMinecraftDownloading() {
    }

    @Override
    public void onMinecraftReconstructingAssets() {
    }

    @Override
    public void onMinecraftUnpackingNatives() {
    }

    @Override
    public void onMinecraftDeletingEntries() {
    }

    @Override
    public void onMinecraftConstructing() {
    }

    @Override
    public void onMinecraftLaunch() {
        this.stopProgress();
    }

    @Override
    public void onMinecraftPostLaunch() {
    }

    private void clean() {
        this.speedLabel.setVisible(false);
        this.fileLabel.setVisible(false);
        this.centerLabel.setVisible(false);
        this.speedLabel.setText("");
        this.fileLabel.setText("");
        this.percentLabel.setText("");
        this.bar.setValue(0);
    }

    public JProgressBar getBar() {
        return this.bar;
    }

    public void setBar(JProgressBar bar) {
        this.bar = bar;
    }

    @Override
    public void repaintPanel() {
        this.upperPanel.repaint();
    }
}

