/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.updater;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import org.tlauncher.tlauncher.controller.UpdaterFormController;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.images.ImageIcon;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.RoundUpdaterButton;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.tlauncher.ui.swing.HtmlTextPane;
import org.tlauncher.tlauncher.ui.swing.ImagePanel;
import org.tlauncher.tlauncher.ui.swing.OwnImageCheckBox;
import org.tlauncher.tlauncher.updater.client.Banner;
import org.tlauncher.tlauncher.updater.client.Offer;
import org.tlauncher.tlauncher.updater.client.PointOffer;
import org.tlauncher.tlauncher.updater.client.Update;
import org.tlauncher.util.OS;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.swing.FontTL;

public class UpdaterMessageView
extends JPanel {
    private static final Dimension SIZE = new Dimension(900, 600);
    private final UpdaterButton ok = new RoundUpdaterButton(Color.WHITE, new Color(107, 202, 45), new Color(91, 174, 37), "launcher.update.updater.button");
    private UpdaterButton updater = new RoundUpdaterButton(Color.WHITE, new Color(107, 202, 45), new Color(91, 174, 37), "launcher.update.updater.button");
    private UpdaterButton laterUpdater = new RoundUpdaterButton(Color.WHITE, new Color(235, 132, 46), new Color(200, 112, 38), "launcher.update.later.button");
    private JPanel down = new JPanel();
    private ImagePanel imageTop;
    private int result;
    private List<JCheckBox> checkBoxList = new ArrayList<JCheckBox>();

    public UpdaterMessageView(Update update, int messageType, String lang, boolean isAdmin) {
        this.setPreferredSize(SIZE);
        String image = messageType == 2 ? "offer.png" : (messageType == 1 ? "banner.png" : "without-banner-offer.png");
        this.imageTop = new ImagePanel(image, 1.0f, 1.0f, true);
        JLabel tlauncher = new JLabel("TLAUNCHER " + update.getVersion());
        JScrollPane message = HtmlTextPane.createNew(Localizable.get(update.isMandatory() ? "launcher.update.message.mandatory" : "launcher.update.message.optional"), 246);
        JScrollPane changes = HtmlTextPane.createNew(update.getDescription(), 246);
        JScrollPane notice = HtmlTextPane.createNew(Localizable.get("updater.notice"), 700);
        SpringLayout spring = new SpringLayout();
        SpringLayout topSpring = new SpringLayout();
        SpringLayout downSpring = new SpringLayout();
        this.setLayout(spring);
        this.imageTop.setLayout(topSpring);
        this.down.setLayout(downSpring);
        spring.putConstraint("West", (Component)this.imageTop, 0, "West", (Component)this);
        spring.putConstraint("East", (Component)this.imageTop, 0, "East", (Component)this);
        spring.putConstraint("North", (Component)this.imageTop, 0, "North", (Component)this);
        spring.putConstraint("South", (Component)this.imageTop, 453, "North", (Component)this);
        this.add(this.imageTop);
        spring.putConstraint("West", (Component)this.down, 0, "West", (Component)this);
        spring.putConstraint("East", (Component)this.down, 0, "East", (Component)this);
        spring.putConstraint("North", (Component)this.down, 453, "North", (Component)this);
        spring.putConstraint("South", (Component)this.down, 600, "North", (Component)this);
        this.add(this.down);
        topSpring.putConstraint("West", (Component)tlauncher, 40, "West", (Component)this.imageTop);
        topSpring.putConstraint("East", (Component)tlauncher, 286, "West", (Component)this.imageTop);
        topSpring.putConstraint("North", (Component)tlauncher, 37, "North", (Component)this.imageTop);
        topSpring.putConstraint("South", (Component)tlauncher, 67, "North", (Component)this.imageTop);
        this.imageTop.add((Component)tlauncher);
        topSpring.putConstraint("West", (Component)message, 40, "West", (Component)this.imageTop);
        topSpring.putConstraint("East", (Component)message, 286, "West", (Component)this.imageTop);
        topSpring.putConstraint("North", (Component)message, 60, "North", (Component)this.imageTop);
        topSpring.putConstraint("South", (Component)message, 160, "North", (Component)this.imageTop);
        this.imageTop.add((Component)message);
        topSpring.putConstraint("West", (Component)changes, 40, "West", (Component)this.imageTop);
        topSpring.putConstraint("East", (Component)changes, 286, "West", (Component)this.imageTop);
        topSpring.putConstraint("North", (Component)changes, 144, "North", (Component)this.imageTop);
        topSpring.putConstraint("South", (Component)changes, -40, "South", (Component)this.imageTop);
        this.imageTop.add((Component)changes);
        downSpring.putConstraint("West", (Component)notice, 40, "West", (Component)this.down);
        downSpring.putConstraint("East", (Component)notice, 0, "East", (Component)this.down);
        downSpring.putConstraint("North", (Component)notice, 5, "North", (Component)this.down);
        downSpring.putConstraint("South", (Component)notice, 65, "North", (Component)this.down);
        this.down.add(notice);
        if (update.isMandatory()) {
            downSpring.putConstraint("West", (Component)this.ok, 365, "West", (Component)this.down);
            downSpring.putConstraint("East", (Component)this.ok, 535, "West", (Component)this.down);
            downSpring.putConstraint("North", (Component)this.ok, 86, "North", (Component)this.down);
            downSpring.putConstraint("South", (Component)this.ok, 123, "North", (Component)this.down);
            this.down.add(this.ok);
        } else {
            downSpring.putConstraint("West", (Component)this.updater, 273, "West", (Component)this.down);
            downSpring.putConstraint("East", (Component)this.updater, 443, "West", (Component)this.down);
            downSpring.putConstraint("North", (Component)this.updater, 86, "North", (Component)this.down);
            downSpring.putConstraint("South", (Component)this.updater, 123, "North", (Component)this.down);
            this.down.add(this.updater);
            downSpring.putConstraint("West", (Component)this.laterUpdater, 454, "West", (Component)this.down);
            downSpring.putConstraint("East", (Component)this.laterUpdater, 624, "West", (Component)this.down);
            downSpring.putConstraint("North", (Component)this.laterUpdater, 86, "North", (Component)this.down);
            downSpring.putConstraint("South", (Component)this.laterUpdater, 123, "North", (Component)this.down);
            this.down.add(this.laterUpdater);
        }
        if (messageType == 1) {
            final Banner banner = update.getBanners().get(lang).get(0);
            JLabel imagePanel = null;
            try {
                imagePanel = new JLabel((Icon)new ImageIcon((Image)ImageCache.loadImage((URL)new URL(banner.getImage()))));
                imagePanel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        OS.openLink(banner.getClickLink());
                    }
                });
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            topSpring.putConstraint("West", imagePanel, 326, "West", (Component)this.imageTop);
            topSpring.putConstraint("East", (Component)imagePanel, 0, "East", (Component)this.imageTop);
            topSpring.putConstraint("North", (Component)imagePanel, 0, "North", (Component)this.imageTop);
            topSpring.putConstraint("South", (Component)imagePanel, 453, "North", (Component)this.imageTop);
            this.imageTop.add((Component)imagePanel);
        } else if (messageType == 2) {
            Offer offer = update.getOffers().get(0);
            JScrollPane pane = HtmlTextPane.createNew(offer.getTopText().get(lang), 574);
            topSpring.putConstraint("West", (Component)pane, 326, "West", (Component)this.imageTop);
            topSpring.putConstraint("East", (Component)pane, 0, "East", (Component)this.imageTop);
            topSpring.putConstraint("North", (Component)pane, 0, "North", (Component)this.imageTop);
            topSpring.putConstraint("South", (Component)pane, offer.getStartCheckboxSouth(), "North", (Component)this.imageTop);
            this.imageTop.add((Component)pane);
            int start = offer.getStartCheckboxSouth();
            for (PointOffer p : offer.getCheckBoxes()) {
                OwnImageCheckBox checkBox = new OwnImageCheckBox(p.getTexts().get(lang), "updater-checkbox-on.png", "updater-checkbox-off.png");
                if (isAdmin) {
                    checkBox.setSelected(p.isActive());
                } else {
                    checkBox.setSelected(false);
                }
                checkBox.setIconTextGap(18);
                checkBox.setActionCommand(p.getName());
                checkBox.setVerticalAlignment(0);
                SwingUtil.changeFontFamily(checkBox, FontTL.CALIBRI, 16);
                topSpring.putConstraint("West", (Component)checkBox, 378, "West", (Component)this.imageTop);
                topSpring.putConstraint("East", (Component)checkBox, 0, "East", (Component)this.imageTop);
                topSpring.putConstraint("North", (Component)checkBox, start, "North", (Component)this.imageTop);
                topSpring.putConstraint("South", (Component)checkBox, start + 39, "North", (Component)this.imageTop);
                start += 39;
                this.checkBoxList.add(checkBox);
                this.imageTop.add((Component)checkBox);
            }
            JScrollPane downDescription = HtmlTextPane.createNew(offer.getDownText().get(lang), 574);
            topSpring.putConstraint("West", (Component)downDescription, 328, "West", (Component)this.imageTop);
            topSpring.putConstraint("East", (Component)downDescription, 0, "East", (Component)this.imageTop);
            topSpring.putConstraint("North", (Component)downDescription, 320, "North", (Component)this.imageTop);
            topSpring.putConstraint("South", (Component)downDescription, 0, "South", (Component)this.imageTop);
            this.imageTop.add((Component)downDescription);
        }
        this.down.setBackground(Color.WHITE);
        SwingUtil.changeFontFamily(tlauncher, FontTL.CALIBRI_BOLD, 30);
        SwingUtil.changeFontFamily(this.updater, FontTL.ROBOTO_REGULAR, 13);
        SwingUtil.changeFontFamily(this.ok, FontTL.ROBOTO_REGULAR, 13);
        SwingUtil.changeFontFamily(this.laterUpdater, FontTL.ROBOTO_REGULAR, 13);
        tlauncher.setHorizontalTextPosition(2);
        this.updater.addActionListener(e -> {
            this.result = 1;
        });
        this.laterUpdater.addActionListener(e -> {
            this.result = 0;
        });
        this.ok.addActionListener(e -> {
            this.result = 1;
        });
    }

    public UpdaterFormController.UserResult showMessage() {
        this.result = -1;
        Alert.showMessage("  " + Localizable.get("launcher.update.title"), this, new JButton[]{this.updater, this.laterUpdater, this.ok});
        UpdaterFormController.UserResult res = new UpdaterFormController.UserResult();
        res.setUserChooser(this.result);
        StringBuilder builder = new StringBuilder();
        for (JCheckBox box : this.checkBoxList) {
            if (!box.isSelected()) continue;
            if (builder.length() > 0) {
                builder.append("+");
            }
            builder.append(box.getActionCommand());
            res.setSelectedAnyCheckBox(true);
        }
        res.setOfferArgs(builder.toString());
        return res;
    }
}

