/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.updater.bootstrapper.model;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.tlauncher.util.FileUtil;

public class DownloadedElement {
    private List<String> url;
    private String shaCode;
    private String storagePath;

    public boolean notExistOrValid(File folder) {
        File library = new File(folder, this.storagePath);
        if (library.exists() && library.isFile()) {
            String sha = FileUtil.getChecksum(library, "sha1");
            return !this.getShaCode().equals(sha);
        }
        return true;
    }

    public List<String> getUrl() {
        Collections.shuffle(this.url);
        return this.url;
    }

    public String getShaCode() {
        return this.shaCode;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public void setUrl(List<String> url) {
        this.url = url;
    }

    public void setShaCode(String shaCode) {
        this.shaCode = shaCode;
    }

    public void setStoragePath(String storagePath) {
        this.storagePath = storagePath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DownloadedElement)) {
            return false;
        }
        DownloadedElement other = (DownloadedElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$url = this.getUrl();
        List<String> other$url = other.getUrl();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        String this$shaCode = this.getShaCode();
        String other$shaCode = other.getShaCode();
        if (this$shaCode == null ? other$shaCode != null : !this$shaCode.equals(other$shaCode)) {
            return false;
        }
        String this$storagePath = this.getStoragePath();
        String other$storagePath = other.getStoragePath();
        return !(this$storagePath == null ? other$storagePath != null : !this$storagePath.equals(other$storagePath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DownloadedElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        String $shaCode = this.getShaCode();
        result = result * 59 + ($shaCode == null ? 43 : $shaCode.hashCode());
        String $storagePath = this.getStoragePath();
        result = result * 59 + ($storagePath == null ? 43 : $storagePath.hashCode());
        return result;
    }

    public String toString() {
        return "DownloadedElement(url=" + this.getUrl() + ", shaCode=" + this.getShaCode() + ", storagePath=" + this.getStoragePath() + ")";
    }
}

