/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.configuration.InnerConfiguration;
import org.tlauncher.tlauncher.configuration.LangConfiguration;
import org.tlauncher.tlauncher.downloader.Downloadable;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.log.LogFrame;
import org.tlauncher.tlauncher.updater.bootstrapper.model.JavaConfig;
import org.tlauncher.tlauncher.updater.bootstrapper.model.JavaDownloadedElement;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.MinecraftUtil;
import org.tlauncher.util.OS;
import org.tlauncher.util.U;
import org.tlauncher.util.async.AsyncThread;

public class TlauncherUtil {
    public static final String PROTECTED_DOUBLE_RUNNING_FILE = "doubleRunningProtection.txt";
    private static final int CAN_RUNNING_AFTER = 4;

    public static void sendLog(Throwable e) {
        if (TLauncher.DEBUG) {
            return;
        }
        if (Localizable.get() == null) {
            try {
                Configuration settings = Configuration.createConfiguration();
                Locale locale = settings.getLocale();
                InnerConfiguration innerConfig = new InnerConfiguration(FileUtil.getResourceAppStream("/inner.tlauncher.properties"));
                Localizable.setLang(new LangConfiguration(settings.getLocales(), locale, innerConfig.get("tlauncher.language.folder")));
            }
            catch (IOException e1) {
                e1.addSuppressed(e);
                e = e1;
                e1.printStackTrace();
            }
        }
        new LogFrame(TLauncher.getInstance().getFrame(), e).setVisible(true);
    }

    public static void checkRedirect() {
    }

    public static int hostAvailabilityCheck(String host) {
        if (host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        try {
            URL url = new URL(host);
            HttpURLConnection httpConn = Downloadable.setUp(url.openConnection(), true);
            httpConn.setRequestMethod("HEAD");
            httpConn.setInstanceFollowRedirects(true);
            httpConn.connect();
            U.debug(host + " : " + httpConn.getResponseCode());
            return httpConn.getResponseCode();
        }
        catch (Throwable e) {
            U.debug(host + " is down ");
            return 500;
        }
    }

    public static void deactivateSSL() {
        Configuration c = TLauncher.getInstance().getConfiguration();
        if (c.get("ssl.deactivate.date") == null || LocalDate.parse(c.get("ssl.deactivate.date")).isBefore(LocalDate.now())) {
            TLauncher.getInstance().getConfiguration().set("ssl.deactivate.date", (Object)LocalDate.now().plusMonths(1L));
            try {
                TLauncher.getInstance().getConfiguration().save();
            }
            catch (IOException e1) {
                U.log(e1);
            }
        }
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, new X509TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
        }
        catch (Throwable var1) {
            U.log(var1);
        }
        HttpsURLConnection.setDefaultHostnameVerifier((s, sslSession) -> true);
    }

    public static void checkServersAvalability(String[] array) {
        List<CompletableFuture> servers = Arrays.stream(array).map(link -> CompletableFuture.supplyAsync(() -> {
            if (TlauncherUtil.hostAvailabilityCheck(link) == 503) {
                U.log("     server code 503 -> " + link);
                return 503;
            }
            return 200;
        }, AsyncThread.getService())).collect(Collectors.toList());
        try {
            CompletableFuture.allOf(servers.toArray(new CompletableFuture[0])).get();
            if (servers.stream().allMatch(e -> {
                try {
                    return ((Integer)e.get()).equals(200);
                }
                catch (Exception exception) {
                    return false;
                }
            })) {
                U.log("#####    all servers are available   ######");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isDoubleRunning() {
        File f = MinecraftUtil.getTLauncherFile(PROTECTED_DOUBLE_RUNNING_FILE);
        if (Files.exists(f.toPath(), new LinkOption[0])) {
            try {
                Date start = new Date(Long.parseLong(FileUtil.readFile(f)));
                Date end = new Date(start.getTime() + 4000L);
                Date current = new Date();
                if (current.after(start) && current.before(end)) {
                    return true;
                }
            }
            catch (IOException | NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static String resolveHostName(String path) throws MalformedURLException, UnknownHostException {
        URL url = new URL(path);
        return url.getProtocol() + "://" + InetAddress.getByName(url.getHost()).getHostAddress() + ":" + url.getPort() + url.getFile();
    }

    public static boolean isAdmin() {
        if (!OS.is(OS.WINDOWS)) {
            return true;
        }
        try {
            String[] groups;
            Class<?> cl = Class.forName("com.sun.security.auth.module.NTSystem");
            if (Objects.isNull(cl)) {
                return true;
            }
            Method method = cl.getMethod("getGroupIDs", new Class[0]);
            for (String group : groups = (String[])method.invoke(cl.newInstance(), new Object[0])) {
                if (!group.equals("S-1-5-32-544")) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            U.log(e);
            return true;
        }
    }

    public static String getPageLanguage() {
        if (Objects.nonNull(TLauncher.getInstance()) && Objects.nonNull(TLauncher.getInstance().getConfiguration()) && TLauncher.getInstance().getConfiguration().isUSSRLocale()) {
            return "ru";
        }
        return "en";
    }

    public static boolean contains_OPTIONS_JAVA_XMX() {
        return Objects.nonNull(System.getenv("_java_options")) && System.getenv("_java_options").toLowerCase().contains("xmx");
    }

    public static String getStringError(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString().replaceAll(System.lineSeparator(), "<br>");
    }

    public static File getJVMFolder(JavaConfig config, File tlauncherFolder) {
        JavaDownloadedElement java = TlauncherUtil.getProperJavaElement(config);
        return new File(new File(tlauncherFolder, "jvms"), java.getJavaFolder());
    }

    public static JavaDownloadedElement getProperJavaElement(JavaConfig config) {
        if (TlauncherUtil.useX64JavaInsteadX32Java()) {
            return config.getConfig().get((Object)OS.CURRENT).get((Object)OS.Arch.x64);
        }
        return config.getConfig().get((Object)OS.CURRENT).get((Object)OS.Arch.CURRENT);
    }

    public static boolean useX64JavaInsteadX32Java() {
        if (OS.is(OS.WINDOWS) && OS.Arch.CURRENT.equals((Object)OS.Arch.x32)) {
            String s = OS.executeByTerminal("wmic os get osarchitecture");
            return s.contains("64");
        }
        return false;
    }

    public static void showCriticalProblem(String message) {
        Alert.showErrorHtml("A critical error has occurred, ask for help <br> <a href='https://vk.me/tlauncher'> https://vk.me/tlauncher </a> or by mail <b> support@tlauncher.org </b><br><br>" + message, 500);
    }

    public static void showCriticalProblem(Throwable e) {
        TlauncherUtil.showCriticalProblem(TlauncherUtil.getStringError(e));
        TLauncher.kill();
    }

    public static boolean hasCorrectJavaFX() {
        try {
            Class.forName("javafx.embed.swing.JFXPanel");
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public static void fillGPUInfo(Configuration con, boolean wait) {
        try {
            String res;
            List names;
            if (OS.is(OS.WINDOWS)) {
                Path dxdiag = Paths.get(MinecraftUtil.getWorkingDirectory().getAbsolutePath(), "logs", "tlauncher", "dxdiag.txt");
                boolean dxdiagExist = Files.exists(dxdiag, new LinkOption[0]);
                if (!dxdiagExist || FileUtils.isFileOlder(dxdiag.toFile(), DateUtils.addDays((Date)new Date(), (int)-10))) {
                    String command = String.format("dxdiag /whql:off /t %s", dxdiag.toString());
                    OS.executeByTerminal(command);
                }
                AsyncThread.execute(() -> {
                    if (wait) {
                        U.sleepFor(15000L);
                    }
                    if (Files.exists(dxdiag, new LinkOption[0])) {
                        try {
                            String gpu;
                            List names;
                            String file = FileUtil.readFile(dxdiag.toFile(), Charset.defaultCharset().name());
                            String[] params = file.split(System.lineSeparator());
                            String name = Arrays.stream(params).filter(e -> (e = e.toLowerCase()).contains("card name:") || e.contains("chip type:") || e.contains("display memory:")).map(s -> s.split(":")[1]).collect(Collectors.joining(","));
                            if (StringUtils.isNotBlank((CharSequence)name)) {
                                con.set("gpu.info.full", (Object)name);
                            }
                            if (!(names = Arrays.stream(params).filter(e -> {
                                e = e.toLowerCase();
                                return e.contains("card name:");
                            }).map(s -> s.split(":")[1]).collect(Collectors.toList())).isEmpty() && !(gpu = ((String)names.get(names.size() - 1)).trim()).equalsIgnoreCase("Intel(R) HD Graphics")) {
                                con.set("gpu.info", (Object)gpu);
                            }
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                });
            } else if (OS.is(OS.LINUX)) {
                String res2 = OS.executeByTerminal("lshw -C display");
                String[] params = res2.split(System.lineSeparator());
                List names2 = Arrays.stream(params).filter(e -> e.contains("product:")).map(s -> s.split(":")[1]).collect(Collectors.toList());
                if (!names2.isEmpty()) {
                    con.set("gpu.info", (Object)((String)names2.get(names2.size() - 1)).trim());
                    con.set("gpu.info.full", (Object)((String)names2.get(names2.size() - 1)).trim());
                }
            } else if (OS.is(OS.OSX) && !(names = Arrays.stream((res = OS.executeByTerminal("system_profiler SPDisplaysDataType")).split(System.lineSeparator())).filter(e -> e.toLowerCase().contains("chipset model:")).map(s -> s.split(":")[1]).collect(Collectors.toList())).isEmpty()) {
                con.set("gpu.info", (Object)((String)names.get(names.size() - 1)).trim());
                con.set("gpu.info.full", (Object)((String)names.get(names.size() - 1)).trim());
            }
        }
        catch (Throwable e2) {
            U.log(e2);
        }
    }
}

