/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util.gson.serializer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.share.Category;
import org.tlauncher.modpack.domain.client.share.JavaEnum;
import org.tlauncher.modpack.domain.client.version.VersionDTO;

public class ElementCollectionsPool {
    private static Map<String, String> stringElements = new HashMap<String, String>();
    private static Map<Set<String>, Set<String>> set = new HashMap<Set<String>, Set<String>>();
    private static Map<List<JavaEnum>, List<JavaEnum>> javaEnums = new HashMap<List<JavaEnum>, List<JavaEnum>>();
    private static Map<List<Category>, List<Category>> categories = new HashMap<List<Category>, List<Category>>();

    public static void fill(GameEntityDTO en) {
        if (en.getVersions() == null) {
            return;
        }
        for (VersionDTO v : en.getVersions()) {
            List<Category> listCategories;
            List<JavaEnum> java;
            if (v.getGameVersions() != null) {
                HashSet<String> games = new HashSet<String>();
                for (String s : v.getGameVersions()) {
                    if (!stringElements.containsKey(s)) {
                        stringElements.put(s, s);
                        s = stringElements.get(s);
                    }
                    games.add(stringElements.get(s));
                }
                if (set.containsKey(games)) {
                    v.setGameVersions(set.get(games));
                } else {
                    v.setGameVersions(games);
                    set.put(games, games);
                }
            }
            if ((java = v.getJavaVersions()) != null) {
                if (javaEnums.containsKey(java)) {
                    v.setJavaVersions(javaEnums.get(java));
                } else {
                    javaEnums.put(java, java);
                }
            }
            if ((listCategories = en.getCategories()) == null) continue;
            if (categories.containsKey(listCategories)) {
                en.setCategories(categories.get(listCategories));
                continue;
            }
            categories.put(listCategories, listCategories);
        }
    }
}

