/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.modpack.domain.client.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.springframework.stereotype.Component;

@Component
public class JsonDateDeserializer
extends JsonDeserializer<Date> {
    private final DateFormat enUsFormat = DateFormat.getDateTimeInstance(2, 2, Locale.US);
    private final DateFormat iso8601Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this.toDate(p.getText().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date toDate(String string) {
        DateFormat dateFormat = this.enUsFormat;
        synchronized (dateFormat) {
            try {
                return this.enUsFormat.parse(string);
            }
            catch (Exception exception) {
                try {
                    return this.iso8601Format.parse(string);
                }
                catch (Exception exception2) {
                    try {
                        String cleaned = string.replace("Z", "+00:00");
                        cleaned = cleaned.substring(0, 22) + cleaned.substring(23);
                        return this.iso8601Format.parse(cleaned);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        throw new IllegalArgumentException(((Object)((Object)this)).getClass() + " cannot deserialize " + string);
    }
}

