/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.modpack.domain.client.share;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.tlauncher.modpack.domain.client.share.GameType;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum Category {
    ALL,
    MAGIC,
    ADVENTURE_RPG,
    COSMETIC,
    ARMOR_WEAPONS_TOOLS,
    TECHNOLOGY,
    MAP_INFORMATION,
    LIBRARY_API,
    CHITA,
    ADDONS_FORESTRY,
    TECHNOLOGY_FARMING,
    ADDONS_THERMALEXPANSION,
    TECHNOLOGY_ENERGY,
    WORLD_MOBS,
    WORLD_BIOMES,
    SERVER_UTILITY,
    BLOOD_MAGIC,
    WORLD_DIMENSIONS,
    ADDONS_BUILDCRAFT,
    APPLIED_ENERGISTICS_2,
    TECHNOLOGY_ITEM_FLUID_ENERGY_TRANSPORT,
    TECHNOLOGY_PLAYER_TRANSPORT,
    MC_MISCELLANEOUS,
    WORLD_ORES_RESOURCES,
    MC_FOOD,
    REDSTONE,
    MC_ADDONS,
    WORLD_STRUCTURES,
    ADDONS_INDUSTRIALCRAFT,
    WORLD_GEN,
    TECHNOLOGY_PROCESSING,
    ADDONS_THAUMCRAFT,
    ADDONS_TINKERS_CONSTRUCT,
    TECHNOLOGY_GENETICS,
    ADVENTURE,
    CREATION,
    GAME_MAP,
    PARKOUR,
    SURVIVAL,
    PUZZLE,
    MODDED_WORLD,
    SIXTEEN_X,
    THIRTY_TWO_X,
    SIXTY_FOUR_X,
    ONE_TWENTY_EIGHT_X,
    TWO_FIFTY_SIX_X,
    FIVE_TWELVE_X_AND_BEYOND,
    ANIMATED,
    MEDIEVAL,
    MOD_SUPPORT,
    MODERN,
    PHOTO_REALISTIC,
    STEAMPUNK,
    TRADITIONAL,
    MISCELLANEOUS,
    ADVENTURE_AND_RPG,
    COMBAT_PVP,
    FTB_OFFICIAL_PACK,
    HARDCORE,
    MAP_BASED,
    MINI_GAME,
    MULTIPLAYER,
    QUESTS,
    SCI_FI,
    TECH,
    EXPLORATION,
    EXTRA_LARGE,
    SMALL_LIGHT;


    @JsonCreator
    public static Category createCategory(String value) {
        return Category.valueOf(value.toUpperCase());
    }

    @JsonValue
    public String toString() {
        return super.toString().toLowerCase();
    }

    public static Category[] getCategories(GameType type) {
        switch (type) {
            case MODPACK: {
                return new Category[]{ALL, ADVENTURE_AND_RPG, COMBAT_PVP, EXPLORATION, EXTRA_LARGE, FTB_OFFICIAL_PACK, HARDCORE, MAGIC, MAP_BASED, MINI_GAME, MULTIPLAYER, QUESTS, SCI_FI, SMALL_LIGHT, TECH};
            }
            case MOD: {
                return new Category[]{ALL, ADVENTURE_RPG, ARMOR_WEAPONS_TOOLS, COSMETIC, MC_FOOD, MAGIC, MAP_INFORMATION, REDSTONE, SERVER_UTILITY, TECHNOLOGY, TECHNOLOGY_ENERGY, TECHNOLOGY_ITEM_FLUID_ENERGY_TRANSPORT, TECHNOLOGY_FARMING, TECHNOLOGY_GENETICS, TECHNOLOGY_PLAYER_TRANSPORT, TECHNOLOGY_PROCESSING, WORLD_GEN, WORLD_BIOMES, WORLD_DIMENSIONS, WORLD_MOBS, WORLD_ORES_RESOURCES, WORLD_STRUCTURES, MC_ADDONS, APPLIED_ENERGISTICS_2, BLOOD_MAGIC, ADDONS_BUILDCRAFT, ADDONS_FORESTRY, ADDONS_INDUSTRIALCRAFT, ADDONS_THAUMCRAFT, ADDONS_THERMALEXPANSION, ADDONS_TINKERS_CONSTRUCT, LIBRARY_API, MC_MISCELLANEOUS, CHITA};
            }
            case MAP: {
                return new Category[]{ALL, ADVENTURE, CREATION, GAME_MAP, MODDED_WORLD, PARKOUR, PUZZLE, SURVIVAL};
            }
            case RESOURCEPACK: {
                return new Category[]{ALL, SIXTEEN_X, THIRTY_TWO_X, SIXTY_FOUR_X, ONE_TWENTY_EIGHT_X, TWO_FIFTY_SIX_X, FIVE_TWELVE_X_AND_BEYOND, ANIMATED, MEDIEVAL, MOD_SUPPORT, MODERN, PHOTO_REALISTIC, STEAMPUNK, TRADITIONAL, MISCELLANEOUS};
            }
        }
        return null;
    }

    public static Set<Category> getSubCategories() {
        Category[] categories = new Category[]{TECHNOLOGY_ENERGY, TECHNOLOGY_ITEM_FLUID_ENERGY_TRANSPORT, TECHNOLOGY_FARMING, TECHNOLOGY_GENETICS, TECHNOLOGY_PLAYER_TRANSPORT, TECHNOLOGY_PROCESSING, WORLD_BIOMES, WORLD_DIMENSIONS, WORLD_MOBS, WORLD_ORES_RESOURCES, WORLD_STRUCTURES, APPLIED_ENERGISTICS_2, BLOOD_MAGIC, ADDONS_BUILDCRAFT, ADDONS_FORESTRY, ADDONS_INDUSTRIALCRAFT, ADDONS_THAUMCRAFT, ADDONS_THERMALEXPANSION, ADDONS_TINKERS_CONSTRUCT};
        return new HashSet<Category>(Arrays.asList(categories));
    }
}

