/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.controller;

import com.google.common.collect.Maps;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import net.minecraft.launcher.Http;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.configuration.enums.ConnectionQuality;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.TLauncherFrame;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.updater.UpdaterMessageView;
import org.tlauncher.tlauncher.updater.client.Offer;
import org.tlauncher.tlauncher.updater.client.Update;
import org.tlauncher.util.OS;
import org.tlauncher.util.TlauncherUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.statistics.StatisticsUtil;

public class UpdaterFormController {
    private UpdaterMessageView view;
    private Update update;
    private int messageType;
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Configuration settings;

    public UpdaterFormController(Update update, Configuration settings) {
        Date offerDelay;
        this.update = update;
        this.settings = settings;
        int force = update.getUpdaterView();
        String lang = Localizable.get().getSelected().toString();
        boolean hashOfferDelay = false;
        if (settings.isExist("updater.offer.installer.empty.checkbox.delay") && (offerDelay = DateUtils.addDays((Date)new Date(settings.getLong("updater.offer.installer.empty.checkbox.delay")), (int)update.getOfferEmptyCheckboxDelay())).after(new Date())) {
            hashOfferDelay = true;
        }
        if (settings.isExist("updater.offer.installer.delay") && (offerDelay = DateUtils.addDays((Date)new Date(settings.getLong("updater.offer.installer.delay")), (int)update.getOfferDelay())).after(new Date())) {
            hashOfferDelay = true;
        }
        try {
            if (settings.isExist("updater.offer.installer.empty.checkbox.delay1") && (offerDelay = DateUtils.addDays((Date)FORMAT.parse(settings.get("updater.offer.installer.empty.checkbox.delay1")), (int)update.getOfferEmptyCheckboxDelay())).after(new Date())) {
                hashOfferDelay = true;
            }
            if (settings.isExist("updater.offer.installer.delay1") && (offerDelay = DateUtils.addDays((Date)FORMAT.parse(settings.get("updater.offer.installer.delay1")), (int)update.getOfferDelay())).after(new Date())) {
                hashOfferDelay = true;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.messageType = !hashOfferDelay && !update.getOffers().isEmpty() && OS.is(OS.WINDOWS) && update.getOffers().get(0).getTopText().get(lang) != null && force == 2 ? 2 : (!update.getBanners().isEmpty() && update.getBanners().get(lang) != null && force != 0 ? 1 : 0);
        this.view = new UpdaterMessageView(update, this.messageType, lang, TlauncherUtil.isAdmin());
    }

    public boolean getResult() {
        long delay = this.settings.getLong("updater.delay");
        int hours = TLauncher.getInnerSettings().getInteger("updater.chooser.delay");
        if (new Date().getTime() < new Date(delay).getTime() + (long)(hours * 3600 * 1000)) {
            return false;
        }
        return this.processUpdating();
    }

    private boolean processUpdating() {
        UserResult res = this.view.showMessage();
        switch (res.getUserChooser()) {
            case 1: {
                if (this.messageType == 2 && this.isExecutedOffer(res)) {
                    return this.processUpdating();
                }
                return true;
            }
            case 0: {
                if (this.messageType == 2 && this.isExecutedOffer(res)) {
                    return this.processUpdating();
                }
                this.settings.set("updater.delay", new Date().getTime(), true);
                return false;
            }
        }
        TLauncherFrame frame = TLauncher.getInstance().getFrame();
        if (Objects.isNull(frame)) {
            System.exit(0);
        }
        return false;
    }

    private boolean isExecutedOffer(UserResult res) {
        Offer offer = this.update.getOffers().get(0);
        try {
            if (res.getUserChooser() == 1 || res.getUserChooser() == 0 && this.update.isUpdaterLaterInstall()) {
                Path tempFile = Files.createTempFile("install", ".exe", new FileAttribute[0]);
                FileUtils.copyURLToFile(new URL(offer.getInstaller()), tempFile.toFile(), 15000, 15000);
                String args = offer.getArgs().get(res.getOfferArgs());
                String runningOffer = tempFile + " " + args;
                if (res.isSelectedAnyCheckBox()) {
                    Path runner = Files.createTempFile("TLauncherUpdater", ".exe", new FileAttribute[0]);
                    FileUtils.copyURLToFile(new URL(this.update.getRootAccessExe().get(0)), runner.toFile(), 15000, 15000);
                    TLauncher.getInstance().getDownloader().setConfiguration(ConnectionQuality.BAD);
                    String url = TlauncherUtil.resolveHostName(Http.get(TLauncher.getInnerSettings().get("statistics.url") + "updater/save", Maps.newHashMap()));
                    String data = TLauncher.getGson().toJson(StatisticsUtil.preparedUpdaterDTO(this.update, res));
                    Process p = Runtime.getRuntime().exec(new String[]{"cmd", "/c", runner.toString(), runningOffer.replace("\"", "\\\""), url, data.replace("\"", "\\\"")});
                    if (p.waitFor() == 1) {
                        return true;
                    }
                } else {
                    StatisticsUtil.sendUpdatingInfo(this.update, res);
                    Runtime.getRuntime().exec(runningOffer);
                }
            }
        }
        catch (Exception e) {
            U.log(e);
        }
        if (res.isSelectedAnyCheckBox()) {
            TLauncher.getInstance().getConfiguration().set("updater.offer.installer.delay1", FORMAT.format(new Date()), true);
        } else {
            TLauncher.getInstance().getConfiguration().set("updater.offer.installer.empty.checkbox.delay1", FORMAT.format(new Date()), true);
        }
        return false;
    }

    public static class UserResult {
        private String offerArgs;
        private int userChooser;
        private boolean selectedAnyCheckBox;

        public String getOfferArgs() {
            return this.offerArgs;
        }

        public int getUserChooser() {
            return this.userChooser;
        }

        public boolean isSelectedAnyCheckBox() {
            return this.selectedAnyCheckBox;
        }

        public void setOfferArgs(String offerArgs) {
            this.offerArgs = offerArgs;
        }

        public void setUserChooser(int userChooser) {
            this.userChooser = userChooser;
        }

        public void setSelectedAnyCheckBox(boolean selectedAnyCheckBox) {
            this.selectedAnyCheckBox = selectedAnyCheckBox;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserResult)) {
                return false;
            }
            UserResult other = (UserResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$offerArgs = this.getOfferArgs();
            String other$offerArgs = other.getOfferArgs();
            if (this$offerArgs == null ? other$offerArgs != null : !this$offerArgs.equals(other$offerArgs)) {
                return false;
            }
            if (this.getUserChooser() != other.getUserChooser()) {
                return false;
            }
            return this.isSelectedAnyCheckBox() == other.isSelectedAnyCheckBox();
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $offerArgs = this.getOfferArgs();
            result = result * 59 + ($offerArgs == null ? 43 : $offerArgs.hashCode());
            result = result * 59 + this.getUserChooser();
            result = result * 59 + (this.isSelectedAnyCheckBox() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "UpdaterFormController.UserResult(offerArgs=" + this.getOfferArgs() + ", userChooser=" + this.getUserChooser() + ", selectedAnyCheckBox=" + this.isSelectedAnyCheckBox() + ")";
        }
    }
}

