/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.downloader;

import java.io.File;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import org.tlauncher.tlauncher.downloader.AbortedDownloadException;
import org.tlauncher.tlauncher.downloader.DownloadableContainer;
import org.tlauncher.tlauncher.downloader.DownloadableHandler;
import org.tlauncher.tlauncher.downloader.RetryDownloadException;
import org.tlauncher.tlauncher.repository.Repo;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.OS;
import org.tlauncher.util.Reflect;
import org.tlauncher.util.U;

public class Downloadable {
    private static final boolean DEFAULT_FORCE = false;
    private static final boolean DEFAULT_FAST = false;
    private String path;
    private Repo repo;
    private File destination;
    private final List<File> additionalDestinations = Collections.synchronizedList(new ArrayList());
    private boolean forceDownload;
    private boolean fastDownload;
    private boolean insertUseragent;
    private boolean locked;
    private DownloadableContainer container;
    private final List<DownloadableHandler> handlers = Collections.synchronizedList(new ArrayList());
    private Throwable error;

    private Downloadable() {
    }

    public Downloadable(Repo repo, String path, File destination, boolean forceDownload, boolean fastDownload) {
        this();
        this.setURL(repo, path);
        this.setDestination(destination);
        this.forceDownload = forceDownload;
        this.fastDownload = fastDownload;
    }

    public Downloadable(Repo repo, String path, File destination, boolean forceDownload) {
        this(repo, path, destination, forceDownload, false);
    }

    public Downloadable(Repo repo, String path, File destination) {
        this(repo, path, destination, false, false);
    }

    private Downloadable(String url, File destination, boolean forceDownload, boolean fastDownload) {
        this();
        this.setURL(url);
        this.setDestination(destination);
        this.forceDownload = forceDownload;
        this.fastDownload = fastDownload;
    }

    public Downloadable(String url, File destination) {
        this(url, destination, false, false);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof Downloadable)) {
            return false;
        }
        Downloadable c = (Downloadable)o;
        return U.equal(this.path, c.path) && U.equal(this.repo, c.repo) && U.equal(this.destination, c.destination) && U.equal(this.additionalDestinations, c.additionalDestinations);
    }

    public boolean getInsertUA() {
        return this.insertUseragent;
    }

    public void setInsertUA(boolean ua) {
        this.checkLocked();
        this.insertUseragent = ua;
    }

    public boolean isForce() {
        return this.forceDownload;
    }

    public void setForce(boolean force) {
        this.checkLocked();
        this.forceDownload = force;
    }

    public boolean isFast() {
        return this.fastDownload;
    }

    public void setFast(boolean fast) {
        this.checkLocked();
        this.fastDownload = fast;
    }

    public String getURL() {
        return this.path;
    }

    public Repo getRepository() {
        return this.repo;
    }

    public boolean hasRepository() {
        return this.repo != null;
    }

    protected void setURL(Repo repo, String path) {
        if (repo == null) {
            throw new NullPointerException("Repository is NULL!");
        }
        if (path == null) {
            throw new NullPointerException("Path is NULL!");
        }
        this.checkLocked();
        this.repo = repo;
        this.path = path;
    }

    protected void setURL(String url) {
        if (url == null) {
            throw new NullPointerException();
        }
        if (url.isEmpty()) {
            throw new IllegalArgumentException("URL cannot be empty!");
        }
        this.checkLocked();
        this.repo = null;
        this.path = url;
    }

    public File getDestination() {
        return this.destination;
    }

    public String getFilename() {
        return FileUtil.getFilename(this.path);
    }

    protected void setDestination(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.checkLocked();
        this.destination = file;
    }

    public List<File> getAdditionalDestinations() {
        return Collections.unmodifiableList(this.additionalDestinations);
    }

    public void addAdditionalDestination(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.checkLocked();
        this.additionalDestinations.add(file);
    }

    public DownloadableContainer getContainer() {
        return this.container;
    }

    public boolean hasContainer() {
        return this.container != null;
    }

    public boolean hasConsole() {
        return this.container != null && this.container.hasConsole();
    }

    public void addHandler(DownloadableHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.checkLocked();
        this.handlers.add(handler);
    }

    protected void setContainer(DownloadableContainer container) {
        this.checkLocked();
        this.container = container;
    }

    public Throwable getError() {
        return this.error;
    }

    private void setLocked(boolean locked) {
        this.locked = locked;
    }

    protected void checkLocked() {
        if (this.locked) {
            throw new IllegalStateException("Downloadable is locked!");
        }
    }

    protected void onStart() {
        this.setLocked(true);
        for (DownloadableHandler handler : this.handlers) {
            handler.onStart(this);
        }
    }

    protected void onAbort(AbortedDownloadException ae) {
        this.setLocked(false);
        this.error = ae;
        for (DownloadableHandler handler : this.handlers) {
            handler.onAbort(this);
        }
        if (this.container != null) {
            this.container.onAbort(this);
        }
    }

    protected void onComplete() throws RetryDownloadException {
        this.setLocked(false);
        for (DownloadableHandler handler : this.handlers) {
            handler.onComplete(this);
        }
        if (this.container != null) {
            this.container.onComplete(this);
        }
    }

    protected void onError(Throwable e) {
        this.error = e;
        if (e == null) {
            return;
        }
        this.setLocked(false);
        for (DownloadableHandler handler : this.handlers) {
            handler.onError(this, e);
        }
        if (this.container != null) {
            this.container.onError(this, e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{path='" + this.path + "'; repo=" + this.repo + "; destinations=" + this.destination + "," + this.additionalDestinations + "; force=" + this.forceDownload + "; fast=" + this.fastDownload + "; locked=" + this.locked + "; container=" + this.container + "; handlers=" + this.handlers + "; error=" + this.error + ";}";
    }

    public static HttpURLConnection setUp(URLConnection connection0, int timeout, boolean fake) {
        String userAgent;
        if (connection0 == null) {
            throw new NullPointerException();
        }
        if (!(connection0 instanceof HttpURLConnection)) {
            throw new IllegalArgumentException("Unknown connection protocol: " + connection0);
        }
        HttpURLConnection connection = (HttpURLConnection)connection0;
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        connection.setUseCaches(false);
        connection.setDefaultUseCaches(false);
        connection.setRequestProperty("Cache-Control", "no-store,max-age=0,no-cache");
        connection.setRequestProperty("Expires", "0");
        connection.setRequestProperty("Pragma", "no-cache");
        HttpsURLConnection securedConnection = Reflect.cast(connection, HttpsURLConnection.class);
        if (!fake) {
            return connection;
        }
        switch (OS.CURRENT) {
            case OSX: {
                userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8) AppleWebKit/535.18.5 (KHTML, like Gecko) Version/5.2 Safari/535.18.5";
                break;
            }
            case WINDOWS: {
                userAgent = "Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; Trident/6.0; .NET4.0C)";
                break;
            }
            default: {
                userAgent = "Mozilla/5.0 (Linux; Linux x86_64; rv:29.0) Gecko/20100101 Firefox/29.0";
            }
        }
        connection.setRequestProperty("User-Agent", userAgent);
        return connection;
    }

    public static HttpURLConnection setUp(URLConnection connection, int timeout) {
        return Downloadable.setUp(connection, timeout, false);
    }

    public static HttpURLConnection setUp(URLConnection connection, boolean fake) {
        return Downloadable.setUp(connection, U.getConnectionTimeout(), fake);
    }

    public static HttpURLConnection setUp(URLConnection connection) {
        return Downloadable.setUp(connection, false);
    }

    public static String getEtag(String etag) {
        if (etag == null) {
            return "-";
        }
        if (etag.startsWith("\"") && etag.endsWith("\"")) {
            return etag.substring(1, etag.length() - 1);
        }
        return etag;
    }
}

