/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.entity;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.launcher.versions.Library;
import net.minecraft.launcher.versions.json.Argument;
import net.minecraft.launcher.versions.json.ArgumentType;
import org.tlauncher.tlauncher.downloader.Downloadable;
import org.tlauncher.tlauncher.repository.ClientInstanceRepo;
import org.tlauncher.tlauncher.repository.Repo;
import org.tlauncher.util.OS;
import org.tlauncher.util.U;

public class TLauncherLib
extends Library {
    private Pattern pattern;
    private Map<ArgumentType, List<Argument>> arguments;
    private String mainClass;
    private List<Library> requires = new ArrayList<Library>();
    private List<String> supports = new ArrayList<String>();

    public TLauncherLib() {
        this.setUrl("/libraries/");
    }

    public boolean matches(Library lib) {
        return this.pattern != null && this.pattern.matcher(lib.getName()).matches();
    }

    public boolean isSupport(String version) {
        return this.supports != null && this.supports.contains(version);
    }

    public boolean isApply(Library lib, String id) {
        return this.matches(lib) && (this.getSupports().isEmpty() || this.isSupport(id));
    }

    @Override
    public Downloadable getDownloadable(Repo versionSource, File file, OS os) {
        U.log(new Object[]{"getting downloadable", this.getName(), versionSource, file, os});
        return super.getDownloadable(ClientInstanceRepo.EXTRA_VERSION_REPO, file, os);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Map<ArgumentType, List<Argument>> getArguments() {
        return this.arguments;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public List<Library> getRequires() {
        return this.requires;
    }

    public List<String> getSupports() {
        return this.supports;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public void setArguments(Map<ArgumentType, List<Argument>> arguments) {
        this.arguments = arguments;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setRequires(List<Library> requires) {
        this.requires = requires;
    }

    public void setSupports(List<String> supports) {
        this.supports = supports;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TLauncherLib)) {
            return false;
        }
        TLauncherLib other = (TLauncherLib)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Pattern this$pattern = this.getPattern();
        Pattern other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        Map<ArgumentType, List<Argument>> this$arguments = this.getArguments();
        Map<ArgumentType, List<Argument>> other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        String this$mainClass = this.getMainClass();
        String other$mainClass = other.getMainClass();
        if (this$mainClass == null ? other$mainClass != null : !this$mainClass.equals(other$mainClass)) {
            return false;
        }
        List<Library> this$requires = this.getRequires();
        List<Library> other$requires = other.getRequires();
        if (this$requires == null ? other$requires != null : !((Object)this$requires).equals(other$requires)) {
            return false;
        }
        List<String> this$supports = this.getSupports();
        List<String> other$supports = other.getSupports();
        return !(this$supports == null ? other$supports != null : !((Object)this$supports).equals(other$supports));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TLauncherLib;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Pattern $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        Map<ArgumentType, List<Argument>> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        String $mainClass = this.getMainClass();
        result = result * 59 + ($mainClass == null ? 43 : $mainClass.hashCode());
        List<Library> $requires = this.getRequires();
        result = result * 59 + ($requires == null ? 43 : ((Object)$requires).hashCode());
        List<String> $supports = this.getSupports();
        result = result * 59 + ($supports == null ? 43 : ((Object)$supports).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "TLauncherLib(super=" + super.toString() + ", pattern=" + this.getPattern() + ", arguments=" + this.getArguments() + ", mainClass=" + this.getMainClass() + ", requires=" + this.getRequires() + ", supports=" + this.getSupports() + ")";
    }
}

