/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.launcher.versions.json.DateTypeAdapter;
import net.minecraft.launcher.versions.json.FileTypeAdapter;
import net.minecraft.launcher.versions.json.LowerCaseEnumTypeAdapterFactory;
import org.tlauncher.tlauncher.component.RefreshableComponent;
import org.tlauncher.tlauncher.managers.ComponentManager;
import org.tlauncher.tlauncher.managers.ProfileManagerListener;
import org.tlauncher.tlauncher.managers.TLauncherManager;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.minecraft.auth.AccountListener;
import org.tlauncher.tlauncher.minecraft.auth.AuthenticatorDatabase;
import org.tlauncher.tlauncher.minecraft.auth.UUIDTypeAdapter;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.browser.BrowserHolder;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.MinecraftUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.advertising.AdvertisingStatusObservable;

public class ProfileManager
extends RefreshableComponent {
    private static final String DEFAULT_PROFILE_FILENAME = "TlauncherProfiles.json";
    private static final String OLD_PROFILE_FILENAME = "tlauncher_profiles.json";
    private static final String LAUNCHER_PROFILE_FILENAME = "launcher_profiles.json";
    private final List<ProfileManagerListener> listeners;
    private final AccountListener accountListener;
    private final Gson gson;
    private File file;
    private UUID clientToken;
    private AuthenticatorDatabase authDatabase;

    ProfileManager(ComponentManager manager, File file) throws Exception {
        super(manager);
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.clientToken = UUID.randomUUID();
        this.accountListener = db -> {
            for (AccountListener accountListener : this.listeners) {
                accountListener.onAccountsRefreshed(db);
            }
        };
        this.authDatabase = new AuthenticatorDatabase();
        this.authDatabase.setListener(this.accountListener);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory(new LowerCaseEnumTypeAdapterFactory());
        builder.registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)File.class), new FileTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)AuthenticatorDatabase.class), new AuthenticatorDatabase.Serializer());
        builder.registerTypeAdapter((Type)((Object)UUIDTypeAdapter.class), new UUIDTypeAdapter());
        builder.setPrettyPrinting();
        this.gson = builder.create();
    }

    public ProfileManager(ComponentManager manager) throws Exception {
        this(manager, ProfileManager.getDefaultFile());
    }

    public void recreate() {
        this.setFile(ProfileManager.getDefaultFile());
        this.refresh();
    }

    @Override
    public boolean refresh() {
        this.loadProfiles();
        for (ProfileManagerListener listener : this.listeners) {
            listener.onProfilesRefreshed(this);
        }
        try {
            this.saveProfiles();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProfiles() {
        File launcherProfile;
        this.log("Refreshing profiles from:", this.file);
        File oldFile = new File(this.file.getParentFile(), OLD_PROFILE_FILENAME);
        OutputStreamWriter writer = null;
        if (!oldFile.isFile()) {
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(oldFile), Charset.forName("UTF-8"));
                this.gson.toJson((Object)new OldProfileList(), (Appendable)writer);
                writer.close();
            }
            catch (Exception e) {
                try {
                    this.log("Cannot write into", OLD_PROFILE_FILENAME, e);
                }
                catch (Throwable throwable) {
                    U.close(writer);
                    throw throwable;
                }
                U.close(writer);
            }
            U.close(writer);
        }
        RawProfileList raw = null;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(this.file.isFile() ? this.file : oldFile), Charset.forName("UTF-8"));
            raw = this.gson.fromJson((Reader)reader, RawProfileList.class);
        }
        catch (Exception e) {
            try {
                this.log("Cannot read from", DEFAULT_PROFILE_FILENAME, e);
            }
            catch (Throwable throwable) {
                U.close(reader);
                throw throwable;
            }
            U.close(reader);
        }
        U.close(reader);
        if (raw == null) {
            raw = new RawProfileList();
        }
        if (Files.notExists((launcherProfile = new File(MinecraftUtil.getWorkingDirectory(), LAUNCHER_PROFILE_FILENAME)).toPath(), new LinkOption[0])) {
            try {
                FileUtil.writeFile(launcherProfile, "{\n\"clientToken\": \"" + raw.clientToken + "\"\n,\"profiles\": {}}");
            }
            catch (IOException e) {
                this.log(e);
            }
        }
        this.clientToken = raw.clientToken;
        raw.authenticationDatabase.cleanFreeAccount();
        this.authDatabase = raw.authenticationDatabase;
        this.authDatabase.setListener(this.accountListener);
    }

    public void saveProfiles() throws IOException {
        RawProfileList raw = new RawProfileList();
        raw.clientToken = this.clientToken;
        raw.authenticationDatabase = this.authDatabase;
        FileUtil.writeFile(this.file, this.gson.toJson(raw));
    }

    public AuthenticatorDatabase getAuthDatabase() {
        return this.authDatabase;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
        for (ProfileManagerListener listener : this.listeners) {
            listener.onProfileManagerChanged(this);
        }
    }

    public UUID getClientToken() {
        return this.clientToken;
    }

    public void setClientToken(String uuid) {
        this.clientToken = UUID.fromString(uuid);
    }

    public void addListener(ProfileManagerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    private static File getDefaultFile() {
        return new File(MinecraftUtil.getWorkingDirectory(), DEFAULT_PROFILE_FILENAME);
    }

    public static void init() {
        ProfileManager profileManager = TLauncher.getInstance().getProfileManager();
        final TLauncherManager TLauncherManager2 = TLauncher.getInstance().getTLauncherManager();
        profileManager.addListener(new ProfileManagerListener(){

            @Override
            public void onAccountsRefreshed(AuthenticatorDatabase db) {
                TLauncherManager2.asyncRefresh();
            }

            @Override
            public void onProfilesRefreshed(ProfileManager pm) {
                this.onAccountsRefreshed(pm.getAuthDatabase());
            }

            @Override
            public void onProfileManagerChanged(ProfileManager pm) {
                this.onAccountsRefreshed(pm.getAuthDatabase());
            }
        });
        ProfileManagerListener listener = new ProfileManagerListener(){

            @Override
            public void onAccountsRefreshed(AuthenticatorDatabase db) {
            }

            @Override
            public void onProfilesRefreshed(ProfileManager pm) {
                AdvertisingStatusObservable adStatus = new AdvertisingStatusObservable();
                adStatus.setManager(pm);
                if (BrowserHolder.getInstance().getBrowser() != null) {
                    adStatus.addListeners(BrowserHolder.getInstance().getBrowser());
                }
                adStatus.run();
            }

            @Override
            public void onProfileManagerChanged(ProfileManager pm) {
            }
        };
        profileManager.addListener(listener);
        profileManager.refresh();
    }

    public boolean hasPremium() {
        return this.authDatabase.getAccounts().stream().anyMatch(Account::isPremiumAccount);
    }

    static class OldProfileList {
        UUID clientToken = UUID.randomUUID();
        Map<?, ?> profiles;

        OldProfileList() {
        }
    }

    static class RawProfileList {
        UUID clientToken = UUID.randomUUID();
        AuthenticatorDatabase authenticationDatabase = new AuthenticatorDatabase();

        RawProfileList() {
        }
    }
}

