/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.minecraft.launcher.server;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Named;
import net.minecraft.common.CompressedStreamTools;
import net.minecraft.common.NBTTagCompound;
import net.minecraft.common.NBTTagList;
import net.minecraft.launcher.versions.Version;
import org.apache.commons.lang3.time.DateUtils;
import org.tlauncher.exceptions.ParseException;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.entity.server.RemoteServer;
import org.tlauncher.tlauncher.entity.server.Server;
import org.tlauncher.tlauncher.managers.ServerList;
import org.tlauncher.tlauncher.managers.ServerListManager;
import org.tlauncher.tlauncher.minecraft.launcher.server.InnerMinecraftServer;
import org.tlauncher.tlauncher.modpack.ModpackUtil;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.MinecraftUtil;
import org.tlauncher.util.U;

@Singleton
public class InnerMinecraftServersImpl
implements InnerMinecraftServer {
    private static final File INNER_SERVERS_FILE = MinecraftUtil.getTLauncherFile("InnerStateServer-1.2.json");
    private static final File SERVERS_DAT_FILE = FileUtil.getRelative("servers.dat").toFile();
    @Inject
    private TLauncher tlauncher;
    private List<RemoteServer> innerServers;
    private List<Server> localServerList;
    @Inject
    @Named(value="GsonCompleteVersion")
    private Gson gson;

    @Override
    public void prepareInnerServer() throws IOException {
        U.classNameLog(InnerMinecraftServersImpl.class, "prepare inner servers");
        ServerList serverList = this.tlauncher.getManager().getComponent(ServerListManager.class).getList();
        Configuration settings = this.tlauncher.getConfiguration();
        if (!this.tlauncher.getProfileManager().hasPremium() || settings.getBoolean("gui.settings.servers.recommendation")) {
            this.addNewServers(serverList.getNewServers());
            this.innerServers.stream().filter(s -> s.getState().equals((Object)RemoteServer.ServerState.DEACTIVATED)).filter(s -> s.getMaxRemovingCountServer() > s.getRemovedTime().size()).filter(s -> {
                int hours = s.getRecoveryServerTime();
                Date addedDate = DateUtils.addHours((Date)new Date(s.getRemovedTime().get(s.getRemovedTime().size() - 1)), (int)hours);
                return new Date().after(addedDate);
            }).forEach(s -> {
                s.setState(RemoteServer.ServerState.ACTIVE);
                if (!this.localServerList.contains(s)) {
                    this.localServerList.add(0, (Server)s);
                }
            });
        }
        if (!this.tlauncher.getProfileManager().hasPremium() || settings.getBoolean("gui.settings.guard.checkbox")) {
            this.innerServers.removeIf(s -> serverList.getRemovedServers().stream().map(String::toLowerCase).collect(Collectors.toList()).contains(s.getAddress().toLowerCase()));
            this.localServerList.removeIf(s -> serverList.getRemovedServers().stream().map(String::toLowerCase).collect(Collectors.toList()).contains(s.getAddress().toLowerCase()));
        }
        try {
            this.writeServerDatFile(SERVERS_DAT_FILE, this.localServerList);
            FileUtil.writeFile(INNER_SERVERS_FILE, this.gson.toJson(this.innerServers));
        }
        catch (RuntimeException e) {
            U.log(e);
        }
    }

    @Override
    public void searchRemovedServers() throws IOException {
        U.classNameLog(InnerMinecraftServersImpl.class, "search changers of the servers");
        this.localServerList = this.readServerDatFile(SERVERS_DAT_FILE);
        this.innerServers.stream().filter(s -> s.getState().equals((Object)RemoteServer.ServerState.ACTIVE)).filter(s -> !this.localServerList.contains(s)).forEach(s -> {
            s.setState(RemoteServer.ServerState.DEACTIVATED);
            s.getRemovedTime().add(new Date().getTime());
        });
        this.innerServers.removeIf(s -> s.getState().equals((Object)RemoteServer.ServerState.DEACTIVATED) && s.getRemovedTime().size() >= s.getMaxRemovingCountServer() && new Date().after(DateUtils.addDays((Date)s.getAddedDate(), (int)5)));
    }

    @Override
    public void addPageServer(Server server) throws IOException {
        this.localServerList = this.readServerDatFile(SERVERS_DAT_FILE);
        this.localServerList.removeIf(s -> s.getAddress().equals(server.getAddress()));
        this.localServerList.add(0, server);
        this.writeServerDatFile(SERVERS_DAT_FILE, this.localServerList);
    }

    @Override
    public void addPageServerToModpack(Server server, Version c) throws IOException {
        Path path = ModpackUtil.getPathByVersion(c, "servers.dat");
        List<Object> list = new ArrayList();
        if (Files.exists(path, new LinkOption[0])) {
            list = this.readServerDatFile(path.toFile());
        }
        list.remove(server);
        list.add(0, server);
        this.writeServerDatFile(path.toFile(), list);
    }

    private void addNewServers(List<RemoteServer> remoteServers) {
        String lang = Localizable.get().getSelected().toString();
        remoteServers.stream().filter(s -> !this.localServerList.contains(s)).filter(s -> s.getLocales().isEmpty() || s.getLocales().contains(lang)).filter(s -> {
            if (!this.innerServers.contains(s)) {
                return true;
            }
            return this.innerServers.stream().filter(s1 -> s1.equals(s)).anyMatch(s1 -> s1.getState().equals((Object)RemoteServer.ServerState.ACTIVE));
        }).forEach(s -> {
            s.initRemote();
            if (!this.innerServers.contains(s)) {
                this.innerServers.add(0, (RemoteServer)s);
            }
            this.localServerList.add(0, (Server)s);
        });
    }

    @Override
    public void initInnerServers() {
        if (Files.exists(INNER_SERVERS_FILE.toPath(), new LinkOption[0])) {
            try {
                this.innerServers = (List)this.gson.fromJson(FileUtil.readFile(INNER_SERVERS_FILE), new TypeToken<List<RemoteServer>>(){}.getType());
                return;
            }
            catch (JsonParseException | IOException e) {
                U.log(e);
            }
        }
        this.innerServers = new ArrayList<RemoteServer>();
    }

    private List<Server> readServerDatFile(File file) throws IOException {
        ArrayList<Server> list = new ArrayList<Server>();
        NBTTagCompound compound = CompressedStreamTools.read(file);
        if (Objects.nonNull(compound)) {
            NBTTagList servers = compound.getTagList("servers");
            for (int i = 0; i < servers.tagCount(); ++i) {
                try {
                    list.add(Server.loadFromNBT((NBTTagCompound)servers.tagAt(i)));
                    continue;
                }
                catch (ParseException e) {
                    U.log("found server ", e);
                }
            }
            U.log("read servers from servers.dat", list);
        }
        return list;
    }

    private void writeServerDatFile(File file, List<Server> list) throws IOException {
        U.log("save servers to servers.dat");
        NBTTagList servers = new NBTTagList();
        list.forEach(s -> servers.appendTag(s.getNBT()));
        NBTTagCompound compound = new NBTTagCompound();
        compound.setTag("servers", servers);
        CompressedStreamTools.safeWrite(compound, file);
    }
}

