/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.console;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.configuration.enums.ConsoleType;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.console.ConsoleFrame;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedComponentAdapter;
import org.tlauncher.util.OS;
import org.tlauncher.util.StringUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.async.AsyncThread;
import org.tlauncher.util.pastebin.Paste;
import org.tlauncher.util.pastebin.PasteResult;
import org.tlauncher.util.stream.LinkedStringStream;
import org.tlauncher.util.stream.Logger;
import org.tlauncher.util.stream.PrintLogger;
import org.tlauncher.util.stream.StringStream;

public class Console
implements Logger {
    private static List<ConsoleFrame> frames = Collections.synchronizedList(new ArrayList());
    public final ConsoleFrame frame;
    private final Configuration global;
    private String name;
    private LinkedStringStream stream;
    private PrintLogger logger;
    private CloseAction close;
    private boolean killed;
    MinecraftLauncher launcher;

    public Console(final Configuration global, PrintLogger logger, String name, boolean show) {
        this.global = global;
        this.frame = new ConsoleFrame(this);
        this.setName(name);
        frames.add(this.frame);
        this.update();
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Console.this.setShown(false);
                global.set("gui.console", (Object)ConsoleType.NONE);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                U.log("Console", Console.this.name, "has been disposed.");
            }
        });
        this.frame.addComponentListener(new ExtendedComponentAdapter(this.frame){

            @Override
            public void componentShown(ComponentEvent e) {
                Console.this.save(true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                Console.this.save(true);
            }

            @Override
            public void onComponentResized(ComponentEvent e) {
                Console.this.save(true);
            }

            @Override
            public void onComponentMoved(ComponentEvent e) {
                Console.this.save(true);
            }
        });
        this.frame.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Console.this.save(false);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                Console.this.save(false);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                Console.this.save(true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                Console.this.save(true);
            }
        });
        if (logger == null) {
            this.logger = null;
            this.stream = new LinkedStringStream();
            this.stream.setLogger(this);
        } else {
            this.logger = logger;
            this.stream = logger.getStream();
        }
        if (show) {
            this.show();
        }
        this.stream.flush();
        if (logger != null) {
            logger.setMirror(this);
        }
    }

    public Console(PrintLogger logger, String name) {
        this(null, logger, name, true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.frame.setTitle(name);
    }

    public MinecraftLauncher getLauncher() {
        return this.launcher;
    }

    public void setLauncher(MinecraftLauncher launcher) {
        this.launcher = launcher;
        this.frame.bottom.kill.setEnabled(launcher != null);
    }

    @Override
    public void log(String s) {
        if (this.logger != null) {
            this.logger.rawlog(s);
        } else {
            this.stream.write(s.toCharArray());
        }
    }

    @Override
    public void log(Object ... o) {
        this.log(U.toLog(o));
    }

    @Override
    public void rawlog(String s) {
        if (StringUtil.lastChar(s) == '\n') {
            this.frame.print(s);
        } else {
            this.frame.println(s);
        }
    }

    public void rawlog(Object ... o) {
        this.rawlog(U.toLog(o));
    }

    @Override
    public void rawlog(char[] c) {
        this.rawlog(new String(c));
    }

    public PrintLogger getLogger() {
        return this.logger;
    }

    public String getOutput() {
        return this.frame.textarea.getText();
    }

    StringStream getStream() {
        return this.stream;
    }

    void update() {
        this.check();
        if (this.global == null) {
            return;
        }
        String prefix = "gui.console.";
        int width = this.global.getInteger(prefix + "width", 670);
        int height = this.global.getInteger(prefix + "height", 500);
        int x = this.global.getInteger(prefix + "x", 0);
        int y = this.global.getInteger(prefix + "y", 0);
        this.frame.setSize(width, height);
        this.frame.setLocation(x, y);
    }

    void save() {
        this.save(false);
    }

    void save(boolean flush) {
        this.check();
        if (this.global == null) {
            return;
        }
        String prefix = "gui.console.";
        int[] size = this.getSize();
        int[] position = this.getPosition();
        this.global.set(prefix + "width", size[0], false);
        this.global.set(prefix + "height", size[1], false);
        this.global.set(prefix + "x", position[0], false);
        this.global.set(prefix + "y", position[1], false);
    }

    private void check() {
        if (this.killed) {
            throw new IllegalStateException("Console is already killed!");
        }
    }

    public void setShown(boolean shown) {
        if (shown) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void show() {
        this.show(true);
    }

    public void show(boolean toFront) {
        this.check();
        this.frame.setVisible(true);
        this.frame.scrollDown();
        if (toFront) {
            this.frame.toFront();
        }
    }

    public void hide() {
        this.check();
        this.frame.setVisible(false);
    }

    public void clear() {
        this.check();
        this.stream.flush();
        this.frame.clear();
    }

    public void kill() {
        this.check();
        this.save();
        this.frame.dispose();
        this.frame.clear();
        frames.remove(this.frame);
        this.killed = true;
    }

    public void killIn(long millis) {
        this.check();
        this.save();
        this.frame.hideIn(millis);
    }

    public void sendPaste() {
        AsyncThread.execute(new Runnable(){

            @Override
            public void run() {
                Paste paste = new Paste();
                paste.addListener(Console.this.frame);
                paste.setTitle(Console.this.frame.getTitle());
                paste.setContent(Console.this.frame.console.getOutput());
                PasteResult result = paste.paste();
                if (result instanceof PasteResult.PasteUploaded) {
                    PasteResult.PasteUploaded uploaded = (PasteResult.PasteUploaded)result;
                    if (Alert.showLocQuestion("console.pastebin.sent", uploaded.getURL())) {
                        OS.openLink(uploaded.getURL());
                    }
                } else if (result instanceof PasteResult.PasteFailed) {
                    Throwable error = ((PasteResult.PasteFailed)result).getError();
                    if (error instanceof RuntimeException) {
                        Alert.showLocError("console.pastebin.invalid", error);
                    } else if (error instanceof IOException) {
                        Alert.showLocError("console.pastebin.failed", error);
                    }
                }
            }
        });
    }

    public boolean isKilled() {
        this.check();
        return this.killed;
    }

    boolean isHidden() {
        return !this.frame.isShowing();
    }

    Point getPositionPoint() {
        this.check();
        return this.frame.getLocation();
    }

    int[] getPosition() {
        this.check();
        Point p = this.getPositionPoint();
        return new int[]{p.x, p.y};
    }

    Dimension getDimension() {
        this.check();
        return this.frame.getSize();
    }

    int[] getSize() {
        this.check();
        Dimension d = this.getDimension();
        return new int[]{d.width, d.height};
    }

    public CloseAction getCloseAction() {
        return this.close;
    }

    public void setCloseAction(CloseAction action) {
        this.close = action;
    }

    private void onClose() {
        if (this.close == null) {
            return;
        }
        switch (this.close) {
            case KILL: {
                this.kill();
            }
        }
    }

    public static void updateLocale() {
        for (ConsoleFrame frame : frames) {
            frame.updateLocale();
        }
    }

    public static enum CloseAction {
        KILL,
        EXIT;

    }
}

