/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.listener;

import java.io.IOException;
import javax.swing.SwingUtilities;
import org.tlauncher.tlauncher.exceptions.auth.AuthenticatorException;
import org.tlauncher.tlauncher.exceptions.auth.NotCorrectTokenOrIdException;
import org.tlauncher.tlauncher.minecraft.auth.Authenticator;
import org.tlauncher.tlauncher.minecraft.auth.AuthenticatorListener;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.MainPane;
import org.tlauncher.tlauncher.ui.alert.Alert;

public class AuthUIListener
implements AuthenticatorListener {
    private final AuthenticatorListener listener;

    public AuthUIListener(AuthenticatorListener listener) {
        this.listener = listener;
    }

    @Override
    public void onAuthPassing(Authenticator auth) {
        if (this.listener == null) {
            return;
        }
        this.listener.onAuthPassing(auth);
    }

    @Override
    public void onAuthPassingError(Authenticator auth, Throwable e) {
        this.showError(e);
        if (this.listener != null) {
            this.listener.onAuthPassingError(auth, e);
        }
    }

    private void showError(Throwable e) {
        AuthenticatorException ae;
        String description = "unknown";
        if (e instanceof AuthenticatorException && (ae = (AuthenticatorException)e).getLangpath() != null) {
            description = ae.getLangpath();
        }
        Alert.showErrorHtml("auth.error.title", "auth.error." + description);
        if (e instanceof NotCorrectTokenOrIdException) {
            SwingUtilities.invokeLater(() -> {
                MainPane m = TLauncher.getInstance().getFrame().mp;
                m.openAccountEditor();
            });
        }
    }

    @Override
    public void onAuthPassed(Authenticator auth) {
        if (this.listener != null) {
            this.listener.onAuthPassed(auth);
        }
        this.saveProfiles();
    }

    public void saveProfiles() {
        try {
            TLauncher.getInstance().getProfileManager().saveProfiles();
        }
        catch (IOException e) {
            Alert.showLocError("auth.profiles.save-error");
        }
    }
}

