/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.loc.modpack;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.version.VersionDTO;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.modpack.ModpackUtil;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.listener.BlockClickListener;
import org.tlauncher.tlauncher.ui.loc.RoundUpdaterButton;
import org.tlauncher.tlauncher.ui.loc.modpack.ModpackActButton;
import org.tlauncher.tlauncher.ui.modpack.filter.BaseModpackFilter;
import org.tlauncher.tlauncher.ui.swing.box.ModpackComboBox;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.swing.FontTL;

public abstract class GameRightButton
extends ModpackActButton {
    public GameRightButton(final GameEntityDTO entity, final GameType type, final ModpackComboBox localmodpacks) {
        super(entity, type, localmodpacks);
        class Button
        extends RoundUpdaterButton {
            public Button(String value) {
                super(Color.WHITE, new Color(0, 183, 81), new Color(0, 222, 99), value);
            }
        }
        this.installButton = new Button("loginform.enter.install");
        this.removeButton = new Button("modpack.remove.button");
        this.processButton = new Button("modpack.process.button");
        this.add((Component)this.installButton, "INSTALL");
        this.add((Component)this.removeButton, "REMOVE");
        this.add((Component)this.processButton, "PROCESSING");
        SwingUtil.changeFontFamily(this.installButton, FontTL.ROBOTO_REGULAR, 12);
        SwingUtil.changeFontFamily(this.removeButton, FontTL.ROBOTO_REGULAR, 12);
        SwingUtil.changeFontFamily(this.processButton, FontTL.ROBOTO_REGULAR, 12);
        this.initButton();
        final ModpackManager manager = (ModpackManager)TLauncher.getInjector().getInstance(ModpackManager.class);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                manager.removeEntity(GameRightButton.this.getEntity(), entity.getVersion(), GameRightButton.this.getType());
            }
        });
        this.installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseModpackFilter<VersionDTO> filter = BaseModpackFilter.getBaseModpackStandardFilters(entity, type, localmodpacks);
                manager.installEntity(GameRightButton.this.entity, ModpackUtil.sortByDate(filter.findAll(entity.getVersions())).get(0), GameRightButton.this.getType(), true);
            }
        });
    }

    @Override
    public void initButton() {
        if (this.type == GameType.MODPACK) {
            for (GameEntityDTO gameEntityDTO : this.getSelectedModpackData()) {
                if (!this.entity.getId().equals(gameEntityDTO.getId()) || this.type != GameType.MODPACK) continue;
                this.setVisible(false);
                return;
            }
            this.setVisible(true);
        }
        for (GameEntityDTO gameEntityDTO : this.getSelectedModpackData()) {
            if (!this.entity.getId().equals(gameEntityDTO.getId())) continue;
            if (this.type == GameType.MODPACK) {
                this.setVisible(false);
                return;
            }
            this.setTypeButton("REMOVE");
            return;
        }
        this.setTypeButton("INSTALL");
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        if (l instanceof BlockClickListener) {
            return;
        }
        super.addMouseListener(l);
    }

    public abstract void updateRow();
}

